/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.galleon.Errors;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathFilter;
import org.wildfly.galleon.maven.AbstractFeaturePackBuildMojo;
import org.wildfly.galleon.maven.FeatureSpecGeneratorInvoker;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

@Mojo(name="build-feature-pack", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class WfFeaturePackBuildMojo
extends AbstractFeaturePackBuildMojo {
    private static Pattern windowsLineEndingPattern = Pattern.compile("(?<!\\r)\\n", 8);
    private static Pattern linuxLineEndingPattern = Pattern.compile("\\r\\n", 8);
    private static PathFilter windowsLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getFileName().toString().endsWith(".bat");
        }
    };
    private static PathFilter linuxLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getFileName().toString();
            return name.endsWith(".sh") || name.endsWith(".conf");
        }
    };
    @Parameter(alias="config-file", defaultValue="wildfly-feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Parameter(alias="feature-pack-artifact-id", defaultValue="${project.artifactId}", required=false)
    private String fpArtifactId;
    @Parameter(alias="fork-embedded", required=false)
    protected boolean forkEmbedded;
    @Parameter(alias="wildfly-home", property="wfgp.wildflyHome", defaultValue="${project.build.directory}/wildfly", required=true)
    protected File wildflyHome;
    @Parameter(alias="module-templates", property="wfgp.moduleTemplatesDir", defaultValue="${project.build.directory}/module-templates", required=true)
    protected File moduleTemplatesDir;
    @Parameter(alias="feature-specs-output", defaultValue="${project.build.directory}/resources/features", required=true)
    protected File featureSpecsOutput;
    private WildFlyFeaturePackBuild buildConfig;
    private Map<String, PackageSpec.Builder> extendedPackages = Collections.emptyMap();

    protected WildFlyFeaturePackBuild getBuildConfig() throws MojoExecutionException {
        return this.buildConfig == null ? (this.buildConfig = Util.loadFeaturePackBuildConfig(this.configDir, this.configFile)) : this.buildConfig;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        PackageSpec.Builder docsBuilder;
        FeaturePackLocation fpl;
        Path targetResources = Paths.get(this.buildName, "resources");
        Path specsDir = this.configDir.getAbsoluteFile().toPath().resolve(this.resourcesDir);
        if (Files.exists(specsDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)specsDir, (Path)targetResources);
            }
            catch (IOException e1) {
                throw new MojoExecutionException(Errors.copyFile((Path)specsDir, (Path)targetResources), (Exception)e1);
            }
        }
        this.setupDirs(this.buildName, this.fpArtifactId, "layout", targetResources);
        Path fpPackagesDir = this.getPackagesDir();
        this.buildConfig = this.getBuildConfig();
        if (this.buildConfig.hasStandaloneExtensions() || this.buildConfig.hasDomainExtensions() || this.buildConfig.hasHostExtensions()) {
            new FeatureSpecGeneratorInvoker(this).execute();
        }
        if (!(fpl = this.buildConfig.getProducer()).hasUniverse() && !fpl.hasBuild()) {
            fpl = FeaturePackLocation.fromString((String)(fpl.toString() + ":" + this.project.getVersion()));
        } else {
            String channel = fpl.getChannelName();
            if (channel == null || channel.isEmpty()) {
                String v = this.project.getVersion();
                int i = v.indexOf(46);
                channel = i < 0 ? v : v.substring(0, i);
            }
            fpl = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), channel, null, this.project.getVersion());
        }
        FeaturePackDescription.Builder fpBuilder = FeaturePackDescription.builder((FeaturePackSpec.Builder)FeaturePackSpec.builder((FeaturePackLocation.FPID)fpl.getFPID()));
        for (String path : this.buildConfig.getSystemPaths()) {
            fpBuilder.getSpecBuilder().addSystemPaths(path);
        }
        for (String defaultPackage : this.buildConfig.getDefaultPackages()) {
            fpBuilder.getSpecBuilder().addDefaultPackage(defaultPackage);
        }
        try {
            this.processFeaturePackDependencies(this.buildConfig, fpBuilder.getSpecBuilder());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependencies", e);
        }
        Path srcModulesDir = targetResources.resolve("modules");
        if (Files.exists(srcModulesDir, new LinkOption[0])) {
            this.addModulePackages(srcModulesDir, fpBuilder, targetResources);
        } else {
            this.getLog().warn((CharSequence)("No modules found at " + srcModulesDir));
        }
        Path contentDir = targetResources.resolve("content");
        if (Files.exists(contentDir, new LinkOption[0])) {
            try {
                this.packageContent(fpBuilder, contentDir, fpPackagesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process content", (Exception)e);
            }
        }
        if (this.buildConfig.hasSchemaGroups()) {
            this.addDocsSchemas(fpPackagesDir, fpBuilder);
        }
        if ((docsBuilder = this.getExtendedPackage("docs", false)) != null) {
            fpBuilder.getSpecBuilder().addDefaultPackage(this.addPackage(fpPackagesDir, fpBuilder, docsBuilder).getName());
        }
        if (!this.getFpDependencies().isEmpty() && !this.extendedPackages.isEmpty()) {
            for (Map.Entry<String, PackageSpec.Builder> entry : this.getFpDependencies().entrySet()) {
                FeaturePackDescription fpDepLayout = (FeaturePackDescription)entry.getValue();
                for (Map.Entry<String, PackageSpec.Builder> entry2 : this.extendedPackages.entrySet()) {
                    if (!fpDepLayout.hasPackage(entry2.getKey())) continue;
                    entry2.getValue().addPackageDep(entry.getKey(), entry2.getKey(), true);
                }
            }
        }
        for (Map.Entry<String, PackageSpec.Builder> entry : this.extendedPackages.entrySet()) {
            this.addPackage(fpPackagesDir, fpBuilder, entry.getValue());
        }
        this.buildFeaturePack(fpBuilder, this.buildConfig);
    }

    private PackageSpec.Builder getExtendedPackage(String name, boolean create) {
        PackageSpec.Builder pkgBuilder = this.extendedPackages.get(name);
        if (pkgBuilder == null) {
            if (!create) {
                return null;
            }
            pkgBuilder = PackageSpec.builder((String)name);
            this.extendedPackages = CollectionUtils.put(this.extendedPackages, (Object)name, (Object)pkgBuilder);
        }
        return pkgBuilder;
    }

    private void addModulePackages(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources) throws MojoExecutionException {
        Path addOnsDir;
        this.debug("WfFeaturePackBuildMojo adding module packages", new Object[0]);
        Path layersDir = srcModulesDir.resolve("system").resolve("layers");
        if (Files.exists(layersDir, new LinkOption[0])) {
            PackageSpec.Builder modulesAll = this.getExtendedPackage("modules.all", true);
            this.handleLayers(srcModulesDir, fpBuilder, targetResources, modulesAll);
        }
        if (Files.exists(addOnsDir = srcModulesDir.resolve("system").resolve("add-ons"), new LinkOption[0])) {
            PackageSpec.Builder modulesAll = this.getExtendedPackage("modules.all", true);
            this.handleAddOns(srcModulesDir, fpBuilder, targetResources, modulesAll);
        }
    }

    private void addDocsSchemas(Path fpPackagesDir, FeaturePackDescription.Builder fpBuilder) throws MojoExecutionException {
        this.getExtendedPackage("docs.schema", true);
        this.getExtendedPackage("docs", true).addPackageDep("docs.schema", true);
        Path schemasPackageDir = fpPackagesDir.resolve("docs.schema");
        Path schemaGroupsTxt = schemasPackageDir.resolve("pm").resolve("wildfly").resolve("schema-groups.txt");
        BufferedWriter writer = null;
        try {
            Util.mkdirs(schemasPackageDir);
            Util.mkdirs(schemaGroupsTxt.getParent());
            writer = Files.newBufferedWriter(schemaGroupsTxt, new OpenOption[0]);
            for (String group : this.buildConfig.getSchemaGroups()) {
                writer.write(group);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)schemaGroupsTxt.getParent()), (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void packageContent(FeaturePackDescription.Builder fpBuilder, Path contentDir, Path packagesDir) throws IOException, MojoExecutionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(contentDir);){
            for (Path p : stream) {
                String pkgName = p.getFileName().toString();
                Path pkgDir = packagesDir.resolve(pkgName);
                Path pkgContentDir = pkgDir.resolve("content").resolve(pkgName);
                PackageSpec.Builder pkgBuilder = this.getExtendedPackage(pkgName, true);
                if (pkgName.equals("docs")) {
                    try (DirectoryStream<Path> docsStream = Files.newDirectoryStream(p);){
                        for (Path docPath : docsStream) {
                            String docName = docPath.getFileName().toString();
                            String docPkgName = "docs." + docName;
                            Path docDir = packagesDir.resolve(docPkgName);
                            this.getExtendedPackage(docPkgName, true);
                            Path docContentDir = docDir.resolve("content").resolve("docs").resolve(docName);
                            IoUtils.copy((Path)docPath, (Path)docContentDir);
                            pkgBuilder.addPackageDep(docPkgName, true);
                            WfFeaturePackBuildMojo.ensureLineEndings(docContentDir);
                        }
                    }
                }
                if (pkgName.equals("bin")) {
                    Path binStandalonePkgDir = packagesDir.resolve("bin.standalone").resolve("content").resolve(pkgName);
                    Path binDomainPkgDir = packagesDir.resolve("bin.domain").resolve("content").resolve(pkgName);
                    Path binCommonPkgDir = packagesDir.resolve("bin.common").resolve("content").resolve(pkgName);
                    Path binAppClientPkgDir = packagesDir.resolve("bin.appclient").resolve("content").resolve(pkgName);
                    Path binWsToolsPkgDir = packagesDir.resolve("bin.wstools").resolve("content").resolve(pkgName);
                    Path binVaultToolsPkgDir = packagesDir.resolve("bin.vaulttools").resolve("content").resolve(pkgName);
                    Path binJdrToolsPkgDir = packagesDir.resolve("bin.jdrtools").resolve("content").resolve(pkgName);
                    Path toolsBinPkgDir = packagesDir.resolve("tools").resolve("content").resolve(pkgName);
                    Path coreToolsBinPkgDir = packagesDir.resolve("core-tools").resolve("content").resolve(pkgName);
                    try (DirectoryStream<Path> binStream = Files.newDirectoryStream(p);){
                        for (Path binPath : binStream) {
                            String fileName = binPath.getFileName().toString();
                            if (fileName.startsWith("standalone")) {
                                IoUtils.copy((Path)binPath, (Path)binStandalonePkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("domain")) {
                                IoUtils.copy((Path)binPath, (Path)binDomainPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("common")) {
                                IoUtils.copy((Path)binPath, (Path)binCommonPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("appclient")) {
                                IoUtils.copy((Path)binPath, (Path)binAppClientPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("ws")) {
                                IoUtils.copy((Path)binPath, (Path)binWsToolsPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("vault")) {
                                IoUtils.copy((Path)binPath, (Path)binVaultToolsPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("jdr")) {
                                IoUtils.copy((Path)binPath, (Path)binJdrToolsPkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("client") || fileName.startsWith("jconsole")) {
                                IoUtils.copy((Path)binPath, (Path)toolsBinPkgDir.resolve(fileName));
                                continue;
                            }
                            IoUtils.copy((Path)binPath, (Path)coreToolsBinPkgDir.resolve(fileName));
                        }
                    }
                    PackageSpec.Builder toolsBuilder = null;
                    if (Files.exists(toolsBinPkgDir, new LinkOption[0])) {
                        pkgBuilder.addPackageDep("tools");
                        toolsBuilder = this.getExtendedPackage("tools", true);
                    }
                    PackageSpec.Builder coreToolsBuilder = null;
                    if (Files.exists(coreToolsBinPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(coreToolsBinPkgDir);
                        coreToolsBuilder = this.getExtendedPackage("core-tools", true);
                        if (toolsBuilder == null) {
                            pkgBuilder.addPackageDep("tools");
                            toolsBuilder = this.getExtendedPackage("tools", true);
                        }
                        toolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"core-tools"));
                    }
                    if (Files.exists(binCommonPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binCommonPkgDir);
                        this.getExtendedPackage("bin.common", true);
                        if (coreToolsBuilder != null) {
                            coreToolsBuilder.addPackageDep(PackageDependencySpec.required((String)"bin.common"));
                        }
                        if (toolsBuilder != null) {
                            toolsBuilder.addPackageDep(PackageDependencySpec.required((String)"bin.common"));
                        }
                    }
                    if (Files.exists(binStandalonePkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binStandalonePkgDir);
                        this.getExtendedPackage("bin.standalone", true).addPackageDep("bin.common");
                    }
                    if (Files.exists(binDomainPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binDomainPkgDir);
                        this.getExtendedPackage("bin.domain", true).addPackageDep(pkgName);
                    }
                    if (Files.exists(binAppClientPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binAppClientPkgDir);
                        this.getExtendedPackage("bin.appclient", true).addPackageDep("bin.common");
                        if (toolsBuilder != null) {
                            toolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"bin.appclient"));
                        }
                    }
                    if (Files.exists(binWsToolsPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binWsToolsPkgDir);
                        this.getExtendedPackage("bin.wstools", true).addPackageDep("bin.common");
                        if (toolsBuilder != null) {
                            toolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"bin.wstools"));
                        }
                    }
                    if (Files.exists(binVaultToolsPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binVaultToolsPkgDir);
                        this.getExtendedPackage("bin.vaulttools", true).addPackageDep("bin.common");
                        if (coreToolsBuilder != null) {
                            coreToolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"bin.vaulttools"));
                        }
                        if (toolsBuilder != null) {
                            toolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"bin.vaulttools"));
                        }
                    }
                    if (Files.exists(binJdrToolsPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binJdrToolsPkgDir);
                        this.getExtendedPackage("bin.jdrtools", true).addPackageDep("bin.common");
                        if (toolsBuilder != null) {
                            toolsBuilder.addPackageDep(PackageDependencySpec.optional((String)"bin.jdrtools"));
                        }
                    }
                } else {
                    IoUtils.copy((Path)p, (Path)pkgContentDir);
                }
                if (!Files.exists(pkgContentDir, new LinkOption[0])) continue;
                WfFeaturePackBuildMojo.ensureLineEndings(pkgContentDir);
            }
        }
    }

    private static void ensureLineEndings(Path file) throws MojoExecutionException {
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (linuxLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, linuxLineEndingPattern, "\n");
                    } else if (windowsLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, windowsLineEndingPattern, "\r\n");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to adjust line endings for " + file, (Exception)e);
        }
    }

    private static void ensureLineEndings(Path file, Pattern pattern, String lineEnding) throws IOException {
        Matcher matcher;
        String fixedContent;
        String content = IoUtils.readFile((Path)file);
        if (content.equals(fixedContent = (matcher = pattern.matcher(content)).replaceAll(lineEnding))) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(fixedContent.getBytes("UTF-8"));){
            Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

