/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import org.wildfly.galleon.maven.ModuleIdentifier;

class ModuleParseResult {
    final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    final List<String> resourceRoots = new ArrayList<String>();
    final List<ArtifactName> artifacts = new ArrayList<ArtifactName>();
    final Document document;
    ModuleIdentifier identifier;
    ArtifactName versionArtifactName;

    ModuleParseResult(Document document) {
        this.document = document;
    }

    List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    List<String> getResourceRoots() {
        return this.resourceRoots;
    }

    List<ArtifactName> getArtifacts() {
        return this.artifacts;
    }

    ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    Document getDocument() {
        return this.document;
    }

    ArtifactName getVersionArtifactName() {
        return this.versionArtifactName;
    }

    static class ArtifactName {
        private final String artifactCoords;
        private final String options;
        private final Attribute attribute;

        ArtifactName(String artifactCoords, String options, Attribute attribute) {
            this.artifactCoords = artifactCoords;
            this.options = options;
            this.attribute = attribute;
        }

        String getArtifactCoords() {
            return this.artifactCoords;
        }

        String getOptions() {
            return this.options;
        }

        Attribute getAttribute() {
            return this.attribute;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.artifactCoords);
            if (this.options != null) {
                sb.append('?').append(this.options);
            }
            return sb.toString();
        }
    }

    static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

