/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

public class ModuleXmlVersionResolver {
    private static final String MODULES = "modules";

    public static void filterAndConvertModules(Path fpDirectory, final Path targetModuleDir, final Map<String, Artifact> artifacts, final Log log) throws IOException {
        Files.walkFileTree(fpDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (ModuleXmlVersionResolver.isModules(dir)) {
                    this.debug(log, "Copying %s to %s", dir, targetModuleDir);
                    ModuleXmlVersionResolver.convertModules(dir, targetModuleDir, artifacts, log);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            private void debug(Log log2, String format, Object ... args) {
                if (log2.isDebugEnabled()) {
                    log2.debug((CharSequence)String.format(format, args));
                }
            }
        });
    }

    public static void convertModules(final Path source, final Path target, final Map<String, Artifact> artifacts, final Log log) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        } else {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = target.resolve(source.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if ("module.xml".equals(file.getFileName().toString())) {
                        ModuleXmlVersionResolver.convertModule(file, target.resolve(source.relativize(file)), artifacts, log);
                    } else {
                        Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                    }
                }
                catch (XMLStreamException ex) {
                    log.error((CharSequence)("Error reading " + file), (Throwable)ex);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean isModules(Path dir) {
        return MODULES.equals(dir.getFileName().toString());
    }

    public static void convertModule(Path file, Path target, Map<String, Artifact> artifacts, Log log) throws IOException, XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        Files.deleteIfExists(target);
        try (BufferedReader is = Files.newBufferedReader(file, Charsets.UTF_8);
             BufferedWriter out = Files.newBufferedWriter(target, Charsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            ModuleXmlVersionResolver.convert(inputFactory.createXMLEventReader(is), outputFactory.createXMLEventWriter(out), artifacts, log);
        }
    }

    private static void convert(XMLEventReader r, XMLEventWriter w, Map<String, Artifact> artifacts, Log log) throws IOException, XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        while (r.hasNext()) {
            XMLEvent event = r.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    if ("module".equals(startElement.getName().getLocalPart())) {
                        StartElement convertedModule = ModuleXmlVersionResolver.convertModuleElement(eventFactory, startElement, artifacts);
                        log.debug((CharSequence)(startElement + " has been converted to " + convertedModule));
                        w.add(convertedModule);
                        break;
                    }
                    if ("artifact".equals(startElement.getName().getLocalPart())) {
                        StartElement convertedArtifact = ModuleXmlVersionResolver.convertArtifactElement(eventFactory, startElement, artifacts, log);
                        log.debug((CharSequence)(startElement + " has been converted to " + convertedArtifact));
                        w.add(convertedArtifact);
                        break;
                    }
                    w.add(event);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    w.add(event);
                }
            }
        }
        w.flush();
        w.close();
    }

    private static StartElement convertArtifactElement(XMLEventFactory eventFactory, StartElement artifactElement, Map<String, Artifact> artifacts, Log log) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iter = artifactElement.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            if ("name".equals(attribute.getName().getLocalPart())) {
                String artifactName = attribute.getValue();
                String artifactCoords = ModuleXmlVersionResolver.getArtifactCoordinates(artifactName);
                if (artifactCoords != null) {
                    Artifact artifact = artifacts.get(artifactCoords);
                    if (artifact == null) {
                        log.warn((CharSequence)("Couldn't find an artifact in the dependencies to resolve " + artifactCoords));
                        attributes.add(attribute);
                        continue;
                    }
                    StringJoiner joiner = new StringJoiner(":");
                    joiner.add(artifact.getGroupId());
                    joiner.add(artifact.getArtifactId());
                    joiner.add(artifact.getVersion());
                    if (artifact.hasClassifier()) {
                        joiner.add(artifact.getClassifier());
                    }
                    attributes.add(eventFactory.createAttribute(attribute.getName(), joiner.toString()));
                    continue;
                }
                attributes.add(attribute);
                continue;
            }
            attributes.add(attribute);
        }
        return eventFactory.createStartElement(artifactElement.getName(), attributes.iterator(), artifactElement.getNamespaces());
    }

    private static StartElement convertModuleElement(XMLEventFactory eventFactory, StartElement module, Map<String, Artifact> artifacts) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iter = module.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            if ("version".equals(attribute.getName().getLocalPart())) {
                String artifactName = attribute.getValue();
                String artifactCoords = ModuleXmlVersionResolver.getArtifactCoordinates(artifactName);
                if (artifactCoords != null) {
                    attributes.add(eventFactory.createAttribute("version", artifacts.get(artifactCoords).getVersion()));
                    continue;
                }
                attributes.add(attribute);
                continue;
            }
            attributes.add(attribute);
        }
        return eventFactory.createStartElement(module.getName(), attributes.iterator(), module.getNamespaces());
    }

    private static String getArtifactCoordinates(String artifactName) {
        String artifactCoords = null;
        if (artifactName.startsWith("${") && artifactName.endsWith("}")) {
            String ct = artifactName.substring(2, artifactName.length() - 1);
            if (ct.contains("?")) {
                String[] split = ct.split("\\?");
                artifactCoords = split[0];
            } else {
                artifactCoords = ct;
            }
        }
        return artifactCoords;
    }
}

