/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Arrays;
import org.jboss.galleon.ArtifactCoords;

public class ArtifactCoordsUtil {
    public static String toJBossModules(ArtifactCoords coords, boolean includeVersion) {
        StringBuilder buf = new StringBuilder();
        buf.append(coords.getGroupId()).append(':').append(coords.getArtifactId());
        if (coords.getClassifier() != null && !coords.getClassifier().isEmpty()) {
            buf.append(':');
            if (includeVersion && coords.getVersion() != null) {
                buf.append(coords.getVersion());
            }
            buf.append(':').append(coords.getClassifier());
        } else if (includeVersion && coords.getVersion() != null) {
            buf.append(':').append(coords.getVersion());
        }
        return buf.toString();
    }

    public static ArtifactCoords fromJBossModules(String str, String extension) {
        String[] parts = str.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = null;
        if (parts.length > 2) {
            if (!parts[2].isEmpty()) {
                version = parts[2];
            }
            if (parts.length > 3 && !parts[3].isEmpty()) {
                classifier = parts[3];
                if (parts.length > 4) {
                    throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
                }
            }
        }
        return new ArtifactCoords(groupId, artifactId, version, classifier, extension);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.asList("group:artifact:version".split(":")));
    }
}

