/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import nu.xom.ParsingException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackLayoutDescriber;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.maven.plugin.util.MavenPluginUtil;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PropertyUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleParseResult;
import org.wildfly.galleon.maven.ModuleXmlParser;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

@Mojo(name="build-feature-pack", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class WfFeaturePackBuildMojo
extends AbstractMojo {
    private static final boolean OS_WINDOWS = PropertyUtils.isWindows();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(alias="config-file", defaultValue="wildfly-feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Parameter(alias="release-name", defaultValue="${product.release.name}", required=true)
    private String releaseName;
    @Parameter(alias="feature-pack-artifact-id", defaultValue="${project.artifactId}", required=false)
    private String fpArtifactId;
    @Inject
    private MavenPluginUtil mavenPluginUtil;
    private MavenProjectArtifactVersions artifactVersions;
    private WildFlyFeaturePackBuild wfFpConfig;
    private Map<String, FeaturePackLayout> fpDependencies = Collections.emptyMap();
    private PackageSpec.Builder docsBuilder;
    private PackageSpec.Builder docsLicensesBuilder;
    private PackageSpec.Builder docsSchemasBuilder;

    private static boolean isProvided(String module) {
        return module.startsWith("java.") || module.startsWith("jdk.") || module.equals("org.jboss.modules.main");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    private void doExecute() throws MojoExecutionException, MojoFailureException {
        this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        if (!this.resourcesDir.isEmpty()) {
            switch (this.resourcesDir.charAt(0)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    this.resourcesDir = "/" + this.resourcesDir;
                }
            }
        }
        Path targetResources = Paths.get(this.buildName, "resources");
        Path specsDir = Paths.get(this.configDir.getAbsolutePath() + this.resourcesDir, new String[0]);
        if (Files.exists(specsDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)specsDir, (Path)targetResources);
            }
            catch (IOException e1) {
                throw new MojoExecutionException(Errors.copyFile((Path)specsDir, (Path)targetResources), (Exception)e1);
            }
        }
        Path workDir = Paths.get(this.buildName, "layout");
        IoUtils.recursiveDelete((Path)workDir);
        Path fpDir = workDir.resolve(this.project.getGroupId()).resolve(this.fpArtifactId).resolve(this.project.getVersion());
        Path fpPackagesDir = fpDir.resolve("packages");
        FeaturePackLayout.Builder fpBuilder = FeaturePackLayout.builder((FeaturePackSpec.Builder)FeaturePackSpec.builder((ArtifactCoords.Gav)ArtifactCoords.newGav((String)this.project.getGroupId(), (String)this.fpArtifactId, (String)this.project.getVersion())));
        try {
            this.wfFpConfig = Util.loadFeaturePackBuildConfig(this.getFPConfigFile());
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to load feature-pack config file", (Exception)((Object)e));
        }
        for (String defaultPackage : this.wfFpConfig.getDefaultPackages()) {
            fpBuilder.getSpecBuilder().addDefaultPackage(defaultPackage);
        }
        try {
            this.processFeaturePackDependencies(fpBuilder.getSpecBuilder());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependencies", e);
        }
        Path srcModulesDir = targetResources.resolve("modules").resolve("system").resolve("layers").resolve("base");
        if (Files.exists(srcModulesDir, new LinkOption[0])) {
            this.addModulesAll(srcModulesDir, fpBuilder, targetResources, fpPackagesDir);
        } else {
            this.getLog().warn((CharSequence)("No modules found at " + srcModulesDir));
        }
        Path contentDir = targetResources.resolve("content");
        if (Files.exists(contentDir, new LinkOption[0])) {
            try {
                this.packageContent(fpBuilder, contentDir, fpPackagesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process content", (Exception)e);
            }
        }
        if (this.wfFpConfig.hasSchemaGroups()) {
            this.addDocsSchemas(fpPackagesDir, fpBuilder);
        }
        if (!this.fpDependencies.isEmpty() && this.docsBuilder != null) {
            for (Map.Entry<String, FeaturePackLayout> fpDep : this.fpDependencies.entrySet()) {
                FeaturePackLayout fpDepLayout = fpDep.getValue();
                if (fpDepLayout.hasPackage("docs")) {
                    this.docsBuilder.addPackageDep(fpDep.getKey(), "docs");
                }
                if (this.docsLicensesBuilder != null && fpDepLayout.hasPackage("docs.licenses")) {
                    this.docsLicensesBuilder.addPackageDep(fpDep.getKey(), "docs.licenses");
                }
                if (this.docsSchemasBuilder == null || !fpDepLayout.hasPackage("docs.schema")) continue;
                this.docsSchemasBuilder.addPackageDep(fpDep.getKey(), "docs.licenses");
            }
        }
        if (this.docsBuilder != null) {
            if (this.docsLicensesBuilder != null) {
                this.docsLicensesBuilder.addPackageDep("docs.licenses.xsl");
                WfFeaturePackBuildMojo.addPackage(fpPackagesDir, fpBuilder, this.docsLicensesBuilder);
            }
            if (this.docsSchemasBuilder != null) {
                WfFeaturePackBuildMojo.addPackage(fpPackagesDir, fpBuilder, this.docsSchemasBuilder);
            }
            fpBuilder.getSpecBuilder().addDefaultPackage(WfFeaturePackBuildMojo.addPackage(fpPackagesDir, fpBuilder, this.docsBuilder).getName());
        }
        this.addConfigPackages(targetResources.resolve("config").resolve("packages"), fpDir.resolve("packages"), fpBuilder);
        if (this.wfFpConfig.hasConfigs()) {
            for (ConfigModel config : this.wfFpConfig.getConfigs()) {
                try {
                    fpBuilder.getSpecBuilder().addConfig(config);
                }
                catch (ProvisioningDescriptionException e) {
                    throw new MojoExecutionException("Failed to add config to the feature-pack", (Exception)((Object)e));
                }
            }
        }
        try {
            FeaturePackLayout fpLayout = fpBuilder.build();
            FeaturePackXmlWriter.getInstance().write((Object)fpLayout.getSpec(), fpDir.resolve("feature-pack.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningDescriptionException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)fpDir.resolve("feature-pack.xml")), (Exception)e);
        }
        this.copyDirIfExists(targetResources.resolve("features"), fpDir.resolve("features"));
        this.copyDirIfExists(targetResources.resolve("feature_groups"), fpDir.resolve("feature_groups"));
        Artifact mvnPluginsArtifact = (Artifact)this.project.getPluginArtifactMap().get("org.wildfly.galleon-plugins:wildfly-galleon-maven-plugins");
        this.addWildFlyPlugin(fpDir, mvnPluginsArtifact);
        Path resourcesWildFly = fpDir.resolve("resources").resolve("wildfly");
        WfFeaturePackBuildMojo.mkdirs(resourcesWildFly);
        this.addConfigGenerator(resourcesWildFly, mvnPluginsArtifact);
        try (OutputStream out = Files.newOutputStream(resourcesWildFly.resolve("wildfly-tasks.properties"), new OpenOption[0]);){
            this.getFPConfigProperties().store(out, "WildFly feature-pack properties");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store feature-pack properties", (Exception)e);
        }
        try {
            this.artifactVersions.store(resourcesWildFly.resolve("artifact-versions.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store artifact versions", (Exception)e);
        }
        Path scriptsDir = targetResources.resolve("scripts");
        if (Files.exists(scriptsDir, new LinkOption[0])) {
            if (!Files.isDirectory(scriptsDir, new LinkOption[0])) {
                throw new MojoExecutionException("scripts is not a directory");
            }
            try {
                IoUtils.copy((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts")), (Exception)e);
            }
        }
        try {
            this.repoSystem.install(this.repoSession, this.mavenPluginUtil.getInstallLayoutRequest(workDir, this.project));
        }
        catch (IOException | InstallationException e) {
            throw new MojoExecutionException(FpMavenErrors.featurePackInstallation(), (Exception)e);
        }
    }

    private static PackageSpec addPackage(Path fpPackagesDir, FeaturePackLayout.Builder fpBuilder, PackageSpec.Builder pkgBuilder) throws MojoExecutionException {
        PackageSpec pkg = pkgBuilder.build();
        fpBuilder.addPackage(pkg);
        WfFeaturePackBuildMojo.writeXml(pkg, fpPackagesDir.resolve(pkg.getName()));
        return pkg;
    }

    private PackageSpec.Builder getDocsBuilder() {
        if (this.docsBuilder == null) {
            this.docsBuilder = PackageSpec.builder((String)"docs");
        }
        return this.docsBuilder;
    }

    private void addModulesAll(Path srcModulesDir, FeaturePackLayout.Builder fpBuilder, Path targetResources, Path fpPackagesDir) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"WfFeaturePackBuildMojo adding modules.all");
        PackageSpec.Builder modulesAll = PackageSpec.builder((String)"modules.all");
        try {
            Map<String, Path> moduleXmlByPkgName = this.findModules(srcModulesDir);
            if (moduleXmlByPkgName.isEmpty()) {
                throw new MojoExecutionException("Modules not found in " + srcModulesDir);
            }
            this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, fpPackagesDir, modulesAll);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process modules content", (Exception)e);
        }
        if (!this.fpDependencies.isEmpty()) {
            for (Map.Entry<String, FeaturePackLayout> fpDep : this.fpDependencies.entrySet()) {
                FeaturePackLayout fpDepLayout = fpDep.getValue();
                if (!fpDepLayout.hasPackage("modules.all")) continue;
                modulesAll.addPackageDep(fpDep.getKey(), "modules.all");
            }
        }
        try {
            PackageSpec modulesAllPkg = modulesAll.build();
            PackageXmlWriter.getInstance().write((Object)modulesAllPkg, fpPackagesDir.resolve(modulesAllPkg.getName()).resolve("package.xml"));
            fpBuilder.addPackage(modulesAllPkg);
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException("Failed to add package", e);
        }
    }

    private void copyDirIfExists(Path srcDir, Path targetDir) throws MojoExecutionException {
        if (Files.exists(srcDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)srcDir, (Path)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)srcDir, (Path)targetDir), (Exception)e);
            }
        }
    }

    private void addWildFlyPlugin(Path fpDir, Artifact mvnPluginsArtifact) throws MojoExecutionException {
        Path wfPlugInPath;
        Path pluginsDir = fpDir.resolve("plugins");
        WfFeaturePackBuildMojo.mkdirs(pluginsDir);
        try {
            wfPlugInPath = this.resolveArtifact(ArtifactCoords.newInstance((String)mvnPluginsArtifact.getGroupId(), (String)"wildfly-galleon-plugins", (String)mvnPluginsArtifact.getVersion(), (String)"jar"));
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to build feature-pack", (Exception)((Object)e));
        }
        try {
            IoUtils.copy((Path)wfPlugInPath, (Path)pluginsDir.resolve(wfPlugInPath.getFileName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)wfPlugInPath, (Path)pluginsDir.resolve(wfPlugInPath.getFileName())));
        }
    }

    private void addConfigGenerator(Path resourcesDir, Artifact mvnPluginsArtifact) throws MojoExecutionException {
        Path wfPlugInPath;
        WfFeaturePackBuildMojo.mkdirs(resourcesDir);
        try {
            wfPlugInPath = this.resolveArtifact(ArtifactCoords.newInstance((String)mvnPluginsArtifact.getGroupId(), (String)"wildfly-config-gen", (String)mvnPluginsArtifact.getVersion(), (String)"jar"));
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to build feature-pack", (Exception)((Object)e));
        }
        try {
            IoUtils.copy((Path)wfPlugInPath, (Path)resourcesDir.resolve("wildfly-config-gen.jar"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)wfPlugInPath, (Path)resourcesDir.resolve(wfPlugInPath.getFileName())));
        }
    }

    private static void mkdirs(Path resourcesWildFly) throws MojoExecutionException {
        try {
            Files.createDirectories(resourcesWildFly, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)resourcesWildFly), (Exception)e);
        }
    }

    private void addDocsSchemas(Path fpPackagesDir, FeaturePackLayout.Builder fpBuilder) throws MojoExecutionException {
        this.getDocsBuilder().addPackageDep("docs.schema", true);
        Path schemasPackageDir = fpPackagesDir.resolve("docs.schema");
        Path schemaGroupsTxt = schemasPackageDir.resolve("pm").resolve("wildfly").resolve("schema-groups.txt");
        BufferedWriter writer = null;
        try {
            WfFeaturePackBuildMojo.mkdirs(schemasPackageDir);
            this.docsSchemasBuilder = PackageSpec.builder((String)"docs.schema");
            WfFeaturePackBuildMojo.mkdirs(schemaGroupsTxt.getParent());
            writer = Files.newBufferedWriter(schemaGroupsTxt, new OpenOption[0]);
            for (String group : this.wfFpConfig.getSchemaGroups()) {
                writer.write(group);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)schemaGroupsTxt.getParent()), (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addConfigPackages(Path configDir, Path packagesDir, FeaturePackLayout.Builder fpBuilder) throws MojoExecutionException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path configPackage : stream) {
                PackageSpec pkgSpec;
                Path packageDir = packagesDir.resolve(configPackage.getFileName());
                if (!Files.exists(packageDir, new LinkOption[0])) {
                    WfFeaturePackBuildMojo.mkdirs(packageDir);
                }
                IoUtils.copy((Path)configPackage, (Path)packageDir);
                Path packageXml = configPackage.resolve("package.xml");
                if (!Files.exists(packageXml, new LinkOption[0])) continue;
                try (BufferedReader reader = Files.newBufferedReader(packageXml);){
                    try {
                        pkgSpec = PackageXmlParser.getInstance().parse((Reader)reader);
                    }
                    catch (XMLStreamException e) {
                        throw new MojoExecutionException("Failed to parse " + packageXml, (Exception)e);
                    }
                }
                IoUtils.copy((Path)packageXml, (Path)packageDir.resolve("package.xml"));
                fpBuilder.addPackage(pkgSpec);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process config packages", (Exception)e);
        }
    }

    private void processFeaturePackDependencies(FeaturePackSpec.Builder fpBuilder) throws Exception {
        if (this.wfFpConfig.getDependencies().isEmpty()) {
            return;
        }
        this.fpDependencies = new LinkedHashMap<String, FeaturePackLayout>(this.wfFpConfig.getDependencies().size());
        for (FeaturePackDependencySpec depSpec : this.wfFpConfig.getDependencies()) {
            FeaturePackConfig depConfig = depSpec.getTarget();
            String depStr = depConfig.getGav().toString();
            String gavStr = this.artifactVersions.getVersion(depStr);
            if (gavStr == null) {
                throw new MojoExecutionException("Failed resolve artifact version for " + depStr);
            }
            ArtifactCoords.Gav depGav = ArtifactCoords.newGav((String)gavStr);
            FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder((ArtifactCoords.Gav)depGav);
            depBuilder.setInheritPackages(depConfig.isInheritPackages());
            if (depConfig.hasExcludedPackages()) {
                try {
                    depBuilder.excludeAllPackages((Collection)depConfig.getExcludedPackages()).build();
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to process dependencies", (Exception)((Object)e));
                }
            }
            if (depConfig.hasIncludedPackages()) {
                try {
                    depBuilder.includeAllPackages(depConfig.getIncludedPackages()).build();
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to process dependencies", (Exception)((Object)e));
                }
            }
            depBuilder.setInheritConfigs(depConfig.isInheritConfigs());
            if (depConfig.hasDefinedConfigs()) {
                for (ConfigModel configModel : depConfig.getDefinedConfigs()) {
                    depBuilder.addConfig(configModel);
                }
            }
            if (depConfig.hasExcludedConfigs()) {
                for (ConfigId configId : depConfig.getExcludedConfigs()) {
                    depBuilder.excludeDefaultConfig(configId);
                }
            }
            if (depConfig.hasFullModelsExcluded()) {
                for (Map.Entry entry : depConfig.getFullModelsExcluded().entrySet()) {
                    depBuilder.excludeConfigModel((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                }
            }
            if (depConfig.hasFullModelsIncluded()) {
                for (String string : depConfig.getFullModelsIncluded()) {
                    depBuilder.includeConfigModel(string);
                }
            }
            if (depConfig.hasIncludedConfigs()) {
                for (ConfigId configId : depConfig.getIncludedConfigs()) {
                    depBuilder.includeDefaultConfig(configId);
                }
            }
            if (depConfig.hasDefinedConfigs()) {
                for (ConfigModel configModel : depConfig.getDefinedConfigs()) {
                    depBuilder.addConfig(configModel);
                }
            }
            fpBuilder.addFeaturePackDep(depSpec.getName(), depBuilder.build());
            Path depZip = this.resolveArtifact(depGav.toArtifactCoords());
            this.fpDependencies.put(depSpec.getName(), FeaturePackLayoutDescriber.describeFeaturePackZip((Path)depZip));
        }
    }

    private void packageContent(FeaturePackLayout.Builder fpBuilder, Path contentDir, Path packagesDir) throws IOException, MojoExecutionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(contentDir);){
            for (Path p : stream) {
                String pkgName = p.getFileName().toString();
                if (pkgName.equals("docs")) {
                    DirectoryStream<Path> docsStream = Files.newDirectoryStream(p);
                    Throwable throwable = null;
                    try {
                        for (Path docPath : docsStream) {
                            String docName = docPath.getFileName().toString();
                            String docPkgName = "docs." + docName;
                            Path pkgDir = packagesDir.resolve(docPkgName);
                            PackageSpec.Builder pkgBuilder = PackageSpec.builder((String)docPkgName);
                            Path pkgContentDir = pkgDir;
                            if (docPath.getFileName().toString().equals("licenses")) {
                                this.docsLicensesBuilder = pkgBuilder;
                            } else {
                                PackageSpec docSpec = pkgBuilder.build();
                                fpBuilder.addPackage(docSpec);
                                WfFeaturePackBuildMojo.writeXml(docSpec, pkgDir);
                            }
                            IoUtils.copy((Path)docPath, (Path)pkgContentDir.resolve("content").resolve("docs").resolve(docName));
                            this.getDocsBuilder().addPackageDep(docPkgName, true);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (docsStream == null) continue;
                        if (throwable != null) {
                            try {
                                docsStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        docsStream.close();
                        continue;
                    }
                }
                if (pkgName.equals("bin")) {
                    PackageSpec.Builder binBuilder = PackageSpec.builder((String)pkgName);
                    Path binPkgDir = packagesDir.resolve(pkgName).resolve("content").resolve(pkgName);
                    PackageSpec.Builder standaloneBinBuilder = PackageSpec.builder((String)"bin.standalone");
                    Path binStandalonePkgDir = packagesDir.resolve("bin.standalone").resolve("content").resolve(pkgName);
                    PackageSpec.Builder domainBinBuilder = PackageSpec.builder((String)"bin.domain");
                    Path binDomainPkgDir = packagesDir.resolve("bin.domain").resolve("content").resolve(pkgName);
                    try (DirectoryStream<Path> binStream = Files.newDirectoryStream(p);){
                        for (Path binPath : binStream) {
                            String fileName = binPath.getFileName().toString();
                            if (fileName.startsWith("standalone")) {
                                IoUtils.copy((Path)binPath, (Path)binStandalonePkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("domain")) {
                                IoUtils.copy((Path)binPath, (Path)binDomainPkgDir.resolve(fileName));
                                continue;
                            }
                            IoUtils.copy((Path)binPath, (Path)binPkgDir.resolve(fileName));
                        }
                    }
                    PackageSpec binSpec = binBuilder.build();
                    fpBuilder.addPackage(binSpec);
                    WfFeaturePackBuildMojo.writeXml(binSpec, packagesDir.resolve(pkgName));
                    binSpec = ((PackageSpec.Builder)standaloneBinBuilder.addPackageDep(pkgName)).build();
                    fpBuilder.addPackage(binSpec);
                    WfFeaturePackBuildMojo.writeXml(binSpec, packagesDir.resolve(binSpec.getName()));
                    binSpec = ((PackageSpec.Builder)domainBinBuilder.addPackageDep(pkgName)).build();
                    fpBuilder.addPackage(binSpec);
                    WfFeaturePackBuildMojo.writeXml(binSpec, packagesDir.resolve(binSpec.getName()));
                    continue;
                }
                Path pkgDir = packagesDir.resolve(pkgName);
                IoUtils.copy((Path)p, (Path)pkgDir.resolve("content").resolve(pkgName));
                PackageSpec pkgSpec = PackageSpec.builder((String)pkgName).build();
                WfFeaturePackBuildMojo.writeXml(pkgSpec, pkgDir);
                fpBuilder.addPackage(pkgSpec);
            }
        }
    }

    private Map<String, Path> findModules(final Path modulesDir) throws IOException {
        final HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path moduleXml = dir.resolve("module.xml");
                if (Files.exists(moduleXml, new LinkOption[0])) {
                    String packageName = modulesDir.relativize(moduleXml.getParent()).toString().replace(File.separatorChar, '.');
                    moduleXmlByPkgName.put(packageName, moduleXml);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return moduleXmlByPkgName;
    }

    private void packageModules(FeaturePackLayout.Builder fpBuilder, Path resourcesDir, Map<String, Path> moduleXmlByPkgName, Path packagesDir, PackageSpec.Builder modulesAll) throws IOException, MojoExecutionException {
        for (Map.Entry<String, Path> module : moduleXmlByPkgName.entrySet()) {
            String packageName = module.getKey();
            Path moduleXml = module.getValue();
            Path packageDir = packagesDir.resolve(packageName);
            Path targetXml = packageDir.resolve("pm").resolve("wildfly").resolve("module").resolve(resourcesDir.relativize(moduleXml));
            WfFeaturePackBuildMojo.mkdirs(targetXml.getParent());
            IoUtils.copy((Path)moduleXml.getParent(), (Path)targetXml.getParent());
            PackageSpec.Builder pkgSpecBuilder = PackageSpec.builder((String)packageName);
            try {
                ModuleParseResult parsedModule = ModuleXmlParser.parse(targetXml, "UTF-8");
                if (!parsedModule.dependencies.isEmpty()) {
                    for (ModuleParseResult.ModuleDependency moduleDep : parsedModule.dependencies) {
                        StringBuilder buf = new StringBuilder();
                        buf.append(moduleDep.getModuleId().getName()).append('.').append(moduleDep.getModuleId().getSlot());
                        String depName = buf.toString();
                        if (moduleXmlByPkgName.containsKey(depName)) {
                            pkgSpecBuilder.addPackageDep(depName, moduleDep.isOptional());
                            continue;
                        }
                        Map.Entry<String, FeaturePackLayout> depSrc = null;
                        if (!this.fpDependencies.isEmpty()) {
                            Set alternativeSrc = Collections.emptySet();
                            for (Map.Entry<String, FeaturePackLayout> depEntry : this.fpDependencies.entrySet()) {
                                if (!depEntry.getValue().hasPackage(depName)) continue;
                                if (depSrc != null) {
                                    alternativeSrc = CollectionUtils.add(alternativeSrc, (Object)depSrc.getKey());
                                }
                                depSrc = depEntry;
                            }
                            if (!alternativeSrc.isEmpty()) {
                                StringBuilder warn = new StringBuilder();
                                warn.append("Package ").append(depName).append(" from ").append(depSrc.getKey()).append(" picked as dependency of ").append(packageName).append(" although ").append(depName).append(" also exists in ");
                                StringUtils.append((StringBuilder)warn, (Iterable)alternativeSrc);
                                this.getLog().warn((CharSequence)warn);
                            }
                        }
                        if (depSrc != null) {
                            pkgSpecBuilder.addPackageDep((String)depSrc.getKey(), depName, moduleDep.isOptional());
                            continue;
                        }
                        if (moduleDep.isOptional() || WfFeaturePackBuildMojo.isProvided(depName)) continue;
                        throw new MojoExecutionException("Package " + packageName + " has unsatisifed external dependency on package " + depName);
                    }
                }
            }
            catch (ParsingException e) {
                throw new IOException(Errors.parseXml((Path)targetXml), e);
            }
            PackageSpec pkgSpec = pkgSpecBuilder.build();
            try {
                PackageXmlWriter.getInstance().write((Object)pkgSpec, packageDir.resolve("package.xml"));
            }
            catch (XMLStreamException e) {
                throw new IOException(Errors.writeFile((Path)packageDir.resolve("package.xml")), e);
            }
            modulesAll.addPackageDep(packageName, true);
            fpBuilder.addPackage(pkgSpec);
            if (OS_WINDOWS) continue;
            Files.setPosixFilePermissions(targetXml, Files.getPosixFilePermissions(moduleXml, new LinkOption[0]));
        }
    }

    private Properties getFPConfigProperties() {
        Properties properties = new Properties();
        properties.put("project.version", this.project.getVersion());
        properties.put("product.release.name", this.releaseName);
        return properties;
    }

    private Path getFPConfigFile() throws ProvisioningException {
        Path path = Paths.get(this.configDir.getAbsolutePath(), this.configFile);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)path));
        }
        return path;
    }

    private static void writeXml(PackageSpec pkgSpec, Path dir) throws MojoExecutionException {
        try {
            WfFeaturePackBuildMojo.mkdirs(dir);
            PackageXmlWriter.getInstance().write((Object)pkgSpec, dir.resolve("package.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)dir.resolve("package.xml")), e);
        }
    }

    private Path resolveArtifact(ArtifactCoords coords) throws ProvisioningException {
        ArtifactResult result;
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, this.getArtifactRequest(coords));
        }
        catch (ArtifactResolutionException e) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((ArtifactCoords)coords), (Throwable)e);
        }
        if (!result.isResolved()) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((ArtifactCoords)coords));
        }
        if (result.isMissing()) {
            throw new ProvisioningException(FpMavenErrors.artifactMissing((ArtifactCoords)coords));
        }
        return Paths.get(result.getArtifact().getFile().toURI());
    }

    private ArtifactRequest getArtifactRequest(ArtifactCoords coords) {
        ArtifactRequest req = new ArtifactRequest();
        req.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion()));
        req.setRepositories(this.remoteRepos);
        return req;
    }
}

