/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.FeaturePackBuildModelParser;
import org.wildfly.galleon.maven.ModuleParseResult;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

class Util {
    Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static WildFlyFeaturePackBuild loadFeaturePackBuildConfig(Path configFile) throws ProvisioningException {
        try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
            WildFlyFeaturePackBuild wildFlyFeaturePackBuild = new FeaturePackBuildModelParser().parse(configStream);
            return wildFlyFeaturePackBuild;
        }
        catch (XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml((Path)configFile), (Throwable)e);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.openFile((Path)configFile), (Throwable)e);
        }
    }

    static void processModuleArtifacts(ModuleParseResult parsedModule, ArtifactProcessor ap) throws IOException {
        for (ModuleParseResult.ArtifactName artName : parsedModule.artifacts) {
            ap.process(ArtifactCoordsUtil.fromJBossModules(artName.getArtifactCoords(), "jar"));
        }
    }

    static interface ArtifactProcessor {
        public void process(ArtifactCoords var1) throws IOException;
    }
}

