/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScannerMain {
    public static void main(String[] args) throws Exception {
        System.out.println("Starting Scanner in forked process");
        Path cpFile = Paths.get(args[0], new String[0]);
        String cp = Files.readString(cpFile);
        String[] cpArray = cp.split(",");
        Path urlsFile = Paths.get(args[1], new String[0]);
        String urls = Files.readString(urlsFile);
        String[] urlsArray = urls.split(",");
        String[] cls = args[2].split(",");
        ArrayList<String> classes = new ArrayList<String>();
        classes.addAll(Arrays.asList(cls));
        Path outputFolder = Paths.get(args[3], new String[0]);
        boolean verbose = Boolean.parseBoolean(args[4]);
        URLClassLoader cpLoader = ScannerMain.buildClassLoader(cpArray, Thread.currentThread().getContextClassLoader());
        URLClassLoader testLoader = ScannerMain.buildClassLoader(urlsArray, cpLoader);
        Class<?> exporterClass = Class.forName("org.wildfly.glow.plugin.arquillian.GlowArquillianDeploymentExporter", true, cpLoader);
        Constructor<?> ctr = exporterClass.getConstructor(List.class, ClassLoader.class, Path.class, Boolean.TYPE);
        Object obj = ctr.newInstance(classes, testLoader, outputFolder, verbose);
        Method scan = exporterClass.getMethod("scanAndExport", new Class[0]);
        scan.invoke(obj, new Object[0]);
        System.exit(0);
    }

    private static URLClassLoader buildClassLoader(String[] cpUrls, ClassLoader parent) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : cpUrls) {
            urls.add(new File(s).toURI().toURL());
        }
        URL[] cp = urls.toArray(new URL[0]);
        return new URLClassLoader(cp, parent);
    }
}

