/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.glow.plugin.arquillian.ChannelConfiguration;

public class ConfiguredChannels {
    private final ChannelSession channelSession;

    public ConfiguredChannels(List<ChannelConfiguration> channels, RepositorySystem system, RepositorySystemSession contextSession, List<RemoteRepository> repositories, Log log, boolean offline) throws MalformedURLException, UnresolvedMavenArtifactException, MojoExecutionException {
        if (channels.isEmpty()) {
            throw new MojoExecutionException("No channel specified.");
        }
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(contextSession.getLocalRepositoryManager());
        session.setOffline(offline);
        HashMap<String, RemoteRepository> mapping = new HashMap<String, RemoteRepository>();
        for (RemoteRepository remoteRepository : repositories) {
            mapping.put(remoteRepository.getId(), remoteRepository);
        }
        ArrayList<Channel> channelDefinitions = new ArrayList<Channel>();
        for (ChannelConfiguration channelConfiguration : channels) {
            channelDefinitions.add(channelConfiguration.toChannel(repositories));
        }
        Function<Repository, RemoteRepository> function = r -> {
            RemoteRepository rep = (RemoteRepository)mapping.get(r.getId());
            if (rep == null) {
                rep = (RemoteRepository)VersionResolverFactory.DEFAULT_REPOSITORY_MAPPER.apply(r);
            }
            return rep;
        };
        VersionResolverFactory factory = new VersionResolverFactory(system, (RepositorySystemSession)session, function);
        this.channelSession = new ChannelSession(channelDefinitions, (MavenVersionsResolver.Factory)factory);
    }

    ChannelSession getChannelSession() {
        return this.channelSession;
    }
}

