/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wildfly.glow.plugin.arquillian.apache.surefire.testset.TestListResolver;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.DefaultScanResult;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.DependencyScanner;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.DirectoryScanner;

class CopiedFromSureFirePlugin {
    private final PluginExecution execution;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/Test*.java", "**/*Test.java", "**/*Tests.java", "**/*TestCase.java"};
    private final Path testClassesDirectory;
    private final List<String> dependenciesToScan;
    private final List<Artifact> projectTestArtifacts;

    public CopiedFromSureFirePlugin(Path testClassesDirectory, List<String> dependenciesToScan, List<Artifact> projectTestArtifacts, PluginExecution execution) {
        this.testClassesDirectory = testClassesDirectory;
        this.dependenciesToScan = dependenciesToScan;
        this.projectTestArtifacts = projectTestArtifacts;
        this.execution = execution;
    }

    DefaultScanResult scanForTestClasses() throws MojoFailureException {
        DefaultScanResult scan = this.scanDirectories();
        DefaultScanResult scanDeps = this.scanDependencies();
        return scan.append(scanDeps);
    }

    private DefaultScanResult scanDirectories() throws MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner(this.testClassesDirectory.toFile(), this.getIncludedAndExcludedTests());
        return scanner.scan();
    }

    private TestListResolver getIncludedAndExcludedTests() {
        Xpp3Dom config;
        List<Object> includes = Collections.emptyList();
        List<String> excludes = Collections.emptyList();
        if (this.execution != null && (config = (Xpp3Dom)this.execution.getConfiguration()) != null) {
            Xpp3Dom excludesDom;
            Xpp3Dom includesDom = config.getChild("includes");
            if (includesDom != null) {
                includes = Arrays.stream(includesDom.getChildren("include")).map(c -> c.getValue()).collect(Collectors.toList());
            }
            if ((excludesDom = config.getChild("excludes")) != null) {
                excludes = Arrays.stream(excludesDom.getChildren("exclude")).map(c -> c.getValue()).collect(Collectors.toList());
            }
        }
        if (includes.isEmpty()) {
            includes = Arrays.asList(DEFAULT_INCLUDES);
        }
        return new TestListResolver(includes, excludes);
    }

    DefaultScanResult scanDependencies() throws MojoFailureException {
        if (this.getDependenciesToScan() == null) {
            return null;
        }
        try {
            DefaultScanResult result = null;
            List<Artifact> dependenciesToScan = DependencyScanner.filter(this.projectTestArtifacts, this.getDependenciesToScan());
            for (Artifact artifact : dependenciesToScan) {
                Object scanner;
                String type = artifact.getType();
                File out = artifact.getFile();
                if (out == null || !out.exists() || !"jar".equals(type) && !out.isDirectory() && !out.getName().endsWith(".jar")) continue;
                if (out.isFile()) {
                    scanner = new DependencyScanner(Collections.singletonList(out), this.getIncludedAndExcludedTests());
                    result = result == null ? ((DependencyScanner)scanner).scan() : result.append(((DependencyScanner)scanner).scan());
                    continue;
                }
                if (!out.isDirectory()) continue;
                scanner = new DirectoryScanner(out, this.getIncludedAndExcludedTests());
                result = result == null ? ((DirectoryScanner)scanner).scan() : result.append(((DirectoryScanner)scanner).scan());
            }
            return result;
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<String> getDependenciesToScan() {
        return this.dependenciesToScan;
    }
}

