/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class GlowArquillianDeploymentExporter {
    private static final Class<Deployment> DEPLOYMENT_ANNOTATION = Deployment.class;
    public static final String ARCHIVE_LIST_FILENAME = "glow-archive-list.txt";
    public static final String TEST_PATHS = "glow-test-path-list.txt";
    public static final String TEST_CLASSPATH = "glow-test-cp-list.txt";
    private final List<String> testClasses;
    private final Path outputFolder;
    private final ClassLoader loader;
    private final List<String> fileNames = new ArrayList<String>();
    private int counter = 0;
    private final boolean verbose;

    public GlowArquillianDeploymentExporter(List<String> testClasses, ClassLoader loader, Path outputFolder, boolean verbose) {
        this.testClasses = testClasses;
        this.outputFolder = outputFolder.normalize();
        this.loader = loader;
        this.verbose = verbose;
    }

    public List<String> scanAndExport() throws Exception {
        for (String className : this.testClasses) {
            this.inspectClassFile(className);
        }
        Path outputPath = this.outputFolder.resolve(ARCHIVE_LIST_FILENAME);
        Files.write(outputPath, this.fileNames, new OpenOption[0]);
        return this.fileNames;
    }

    private void inspectClassFile(String className) throws IOException {
        Class<?> clazz;
        try {
            if (this.verbose) {
                System.out.println("Inspect " + className);
            }
            clazz = Class.forName(className, false, this.loader);
        }
        catch (Throwable e) {
            if (this.verbose) {
                System.err.println("Exception scanning test class " + className + ": " + e);
                e.printStackTrace();
            }
            return;
        }
        List<Method> deploymentMethods = this.findDeploymentAnnotatedMethod(clazz);
        if (deploymentMethods.isEmpty()) {
            return;
        }
        for (Method m : deploymentMethods) {
            this.invokeDeploymentMethodAndExportArchive(m);
        }
    }

    private List<Method> findDeploymentAnnotatedMethod(Class<?> clazz) {
        ArrayList<Method> methods;
        block4: {
            methods = new ArrayList<Method>();
            try {
                for (Method m : clazz.getDeclaredMethods()) {
                    m.setAccessible(true);
                    if (!Modifier.isStatic(m.getModifiers()) || m.getParameterCount() > 0 || m.getAnnotation(DEPLOYMENT_ANNOTATION) == null) continue;
                    methods.add(m);
                }
                Class<?> superClass = clazz.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    methods.addAll(this.findDeploymentAnnotatedMethod(superClass));
                }
            }
            catch (Throwable ex) {
                if (!this.verbose) break block4;
                System.err.println("Exception scanning test class " + clazz + " methods: " + ex);
                ex.printStackTrace();
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDeploymentMethodAndExportArchive(Method m) {
        Archive archive;
        try {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            try {
                archive = (Archive)m.invoke(null, new Object[0]);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (this.verbose) {
                System.err.println("Exception invoking deployment method " + m + ": " + e);
                e.printStackTrace();
            }
            return;
        }
        if (archive.getContent().size() == 0) {
            return;
        }
        String archiveName = archive.getName();
        int index = archiveName.lastIndexOf(46);
        String archiveSuffix = archiveName.substring(index);
        String outputName = m.getDeclaringClass().getSimpleName() + ++this.counter;
        outputName = outputName + archiveSuffix;
        Path outputPath = this.outputFolder.resolve(outputName).toAbsolutePath();
        if (this.verbose) {
            System.out.println("---->" + outputName);
        }
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        exporter.exportTo(outputPath.toFile(), true);
        this.fileNames.add(outputPath.toString());
    }
}

