/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.glow.plugin.arquillian.ChannelConfiguration;

public class ConfiguredChannels {
    private final ChannelSession channelSession;

    public ConfiguredChannels(List<ChannelConfiguration> channels, RepositorySystem system, RepositorySystemSession contextSession, List<RemoteRepository> repositories, Log log, boolean offline) throws MalformedURLException, UnresolvedMavenArtifactException, MojoExecutionException {
        if (channels.isEmpty()) {
            throw new MojoExecutionException("No channel specified.");
        }
        ArrayList<Channel> channelDefinitions = new ArrayList<Channel>();
        for (ChannelConfiguration channelConfiguration : channels) {
            channelDefinitions.add(channelConfiguration.toChannel(repositories));
        }
        this.channelSession = ConfiguredChannels.buildChannelSession(system, contextSession, repositories, channelDefinitions);
    }

    ChannelSession getChannelSession() {
        return this.channelSession;
    }

    public static ChannelSession buildChannelSession(RepositorySystem system, RepositorySystemSession contextSession, List<RemoteRepository> repositories, List<Channel> channels) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(contextSession.getLocalRepositoryManager());
        HashMap<String, RemoteRepository> mapping = new HashMap<String, RemoteRepository>();
        for (RemoteRepository r2 : repositories) {
            mapping.put(r2.getId(), r2);
        }
        Function<Repository, RemoteRepository> mapper = r -> {
            RemoteRepository rep = (RemoteRepository)mapping.get(r.getId());
            if (rep == null) {
                rep = (RemoteRepository)VersionResolverFactory.DEFAULT_REPOSITORY_MAPPER.apply(r);
            }
            return rep;
        };
        VersionResolverFactory factory = new VersionResolverFactory(system, (RepositorySystemSession)session, mapper);
        return new ChannelSession(channels, (MavenVersionsResolver.Factory)factory);
    }
}

