/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.Channel;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.HiddenPropertiesAccessor;
import org.wildfly.glow.Layer;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.plugin.arquillian.ChannelConfiguration;
import org.wildfly.glow.plugin.arquillian.ChannelMavenArtifactRepositoryManager;
import org.wildfly.glow.plugin.arquillian.CopiedFromSureFirePlugin;

@Mojo(name="scan", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.TEST)
public class ScanMojo
extends AbstractMojo {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(alias="add-ons", required=false, property="org.wildfly.glow.add-ons")
    Set<String> addOns = Collections.emptySet();
    @Parameter(alias="config-name", required=false, property="org.wildfly.glow.config-name", defaultValue="standalone.xml")
    String configName;
    @Parameter(required=false, alias="feature-packs")
    List<GalleonFeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="dependencies-to-scan", property="org.wildfly.glow.dependencies-to-scan")
    private List<String> dependenciesToScan = Collections.emptyList();
    @Parameter(alias="profile", required=false, property="org.wildfly.glow.profile")
    private String profile;
    @Parameter(alias="skip-scanning", property="org.wildfly.glow.skip-scanning")
    boolean skipScanning;
    @Parameter(alias="add-layers-for-jndi", property="org.wildfly.glow.layers-for-jndi")
    Set<String> layersForJndi = Collections.emptySet();
    @Parameter(alias="aggregate", property="org.wildfly.glow.aggregate")
    String aggregate;
    @Parameter(alias="surefire-execution-for-included-classes")
    String surefireExecutionForIncludedClasses;
    @Parameter(alias="expected-discovery", property="org.wildfly.glow.expected-discovery")
    String expectedDiscovery;
    @Parameter
    private Map<String, String> systemPropertyVariables = Collections.emptyMap();
    @Parameter(alias="expected-errors", property="org.wildfly.glow.expected-errors")
    private List<String> expectedErrors = Collections.emptyList();
    @Parameter(property="org.wildfly.glow.verbose")
    private boolean verbose = false;
    @Parameter(alias="channels", property="org.wildfly.glow.channels")
    List<ChannelConfiguration> channels;
    @Parameter(alias="server-version", property="org.wildfly.glow.server-version")
    private String serverVersion;
    @Parameter(alias="preview-server", property="org.wildfly.glow.preview-server")
    private boolean previewServer;
    @Parameter(alias="context", property="org.wildfly.glow.context")
    private String context;
    @Parameter(alias="check-errors", property="org.wildfly.glow.check-errors")
    private boolean checkErrors = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block58: {
            if (!this.featurePacks.isEmpty()) {
                if (this.serverVersion != null) {
                    throw new MojoExecutionException("server-version can't be set when feature-packs have been set.");
                }
                if (this.context != null) {
                    throw new MojoExecutionException("context can't be set when feature-packs have been set.");
                }
                if (this.previewServer) {
                    throw new MojoExecutionException("preview-server can't be set when feature-packs have been set.");
                }
            }
            HiddenPropertiesAccessor.setOverrides(this.systemPropertyVariables);
            try {
                Object artifactResolver;
                MavenMessageWriter writer = new MavenMessageWriter();
                Path classesRootFolder = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
                if (!Files.exists(classesRootFolder, new LinkOption[0])) {
                    throw new IllegalStateException(classesRootFolder + " does not exist");
                }
                Path outputFolder = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("glow-scan");
                if (this.aggregate != null) {
                    outputFolder = outputFolder.resolve(this.aggregate);
                } else if (this.surefireExecutionForIncludedClasses != null) {
                    outputFolder = outputFolder.resolve(this.surefireExecutionForIncludedClasses);
                }
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (String s : this.project.getTestClasspathElements()) {
                    paths.add(new File(s).getAbsolutePath());
                }
                Object cr = null;
                if (this.channels != null && !this.channels.isEmpty()) {
                    this.getLog().debug((CharSequence)"WildFly channel enabled.");
                    ArrayList<Channel> lst = new ArrayList<Channel>();
                    for (ChannelConfiguration conf : this.channels) {
                        lst.add(conf.toChannel(this.repositories));
                    }
                    artifactResolver = new ChannelMavenArtifactRepositoryManager(lst, this.repoSystem, this.repoSession, this.repositories);
                } else {
                    artifactResolver = new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
                }
                HashSet<String> profiles = new HashSet<String>();
                if (this.profile != null) {
                    profiles.add(this.profile);
                }
                ScanArguments.Builder argumentsBuilder = Arguments.scanBuilder().setExecutionProfiles(profiles).setBinaries(this.retrieveDeployments(paths, classesRootFolder, outputFolder)).setUserEnabledAddOns(this.addOns).setConfigName(this.configName).setSuggest(this.verbose || this.getLog().isDebugEnabled()).setJndiLayers(this.layersForJndi).setVerbose(this.verbose || this.getLog().isDebugEnabled()).setOutput(OutputFormat.PROVISIONING_XML).setTechPreview(this.previewServer).setExecutionContext(this.context).setVersion(this.serverVersion);
                if (!this.featurePacks.isEmpty()) {
                    argumentsBuilder.setProvisoningXML(this.buildInputConfig(outputFolder, (MavenRepoManager)artifactResolver));
                }
                Arguments arguments = argumentsBuilder.build();
                try (ScanResults results = GlowSession.scan((MavenRepoManager)artifactResolver, (ScanArguments)arguments, (GlowMessageWriter)writer);){
                    Object builder;
                    boolean skipTests;
                    boolean bl = skipTests = Boolean.getBoolean("maven.test.skip") || Boolean.getBoolean("skipTests");
                    if (skipTests) {
                        this.getLog().warn((CharSequence)"Tests are disabled, not checking for expected discovered layers.");
                    } else {
                        String compact;
                        if (this.expectedDiscovery != null && !this.expectedDiscovery.equals(compact = results.getCompactInformation())) {
                            throw new MojoExecutionException("Error in glow discovery.\n-Expected: " + this.expectedDiscovery + "\n-Found   : " + compact);
                        }
                        if (results.getErrorSession().hasErrors()) {
                            boolean errorsFound = false;
                            if (this.expectedErrors.isEmpty()) {
                                results.outputInformation((GlowMessageWriter)writer);
                                errorsFound = true;
                                String msg = "An error has been reported and expected-errors has not been set.";
                                if (this.checkErrors) {
                                    throw new MojoExecutionException(msg);
                                }
                                this.getLog().warn((CharSequence)msg);
                                return;
                            }
                            ArrayList<IdentifiedError> errors = new ArrayList<IdentifiedError>();
                            for (Object err : results.getErrorSession().getErrors()) {
                                if (err.isFixed()) continue;
                                errors.add((IdentifiedError)err);
                            }
                            if (this.expectedErrors.size() != errors.size()) {
                                ArrayList<String> descriptions = new ArrayList<String>();
                                for (IdentifiedError err : errors) {
                                    descriptions.add(err.getDescription());
                                }
                                String msg = "Number of expected errors mismatch. Expected " + this.expectedErrors.size() + " reported " + errors.size() + ".\nReported Errors " + descriptions + "\nExpected Errors " + this.expectedErrors;
                                errorsFound = true;
                                if (this.checkErrors) {
                                    throw new MojoExecutionException(msg);
                                }
                                this.getLog().warn((CharSequence)msg);
                            }
                            Iterator it = errors.iterator();
                            while (it.hasNext()) {
                                Object err;
                                err = (IdentifiedError)it.next();
                                if (!this.expectedErrors.contains(err.getDescription())) continue;
                                it.remove();
                            }
                            it = errors.iterator();
                            if (it.hasNext()) {
                                builder = new StringBuilder();
                                while (it.hasNext()) {
                                    IdentifiedError err;
                                    err = (IdentifiedError)it.next();
                                    ((StringBuilder)builder).append(err.getDescription()).append("\n");
                                }
                                errorsFound = true;
                                String msg = "The following errors are unexpected:\n" + ((StringBuilder)builder).toString();
                                if (this.checkErrors) {
                                    throw new MojoExecutionException(msg);
                                }
                                this.getLog().warn((CharSequence)msg);
                            }
                            if (!errorsFound) {
                                this.getLog().info((CharSequence)"Expected errors found in glow scanning results.  The test execution should fix them (eg: add missing datasources)");
                            }
                        } else if (!this.expectedErrors.isEmpty()) {
                            throw new MojoExecutionException("expected-errors contains errors but no error reported.");
                        }
                    }
                    if (this.verbose || this.getLog().isDebugEnabled()) {
                        results.outputInformation((GlowMessageWriter)writer);
                    } else {
                        results.outputCompactInformation((GlowMessageWriter)writer);
                    }
                    Path provisioningFile = outputFolder.resolve("provisioning.xml");
                    if (this.aggregate != null && Files.exists(provisioningFile, new LinkOption[0])) {
                        try (Provisioning provisioning = ((GalleonBuilder)new GalleonBuilder().addArtifactResolver((RepositoryArtifactResolver)artifactResolver)).newProvisioningBuilder(provisioningFile).build();){
                            GalleonProvisioningConfig parsed = provisioning.loadProvisioningConfig(provisioningFile);
                            builder = GalleonProvisioningConfig.builder((GalleonProvisioningConfig)parsed);
                            GalleonConfigurationWithLayersBuilder config = GalleonConfigurationWithLayersBuilder.builder((String)"standalone", (String)this.configName);
                            config.includeLayer(results.getBaseLayer().getName());
                            for (Layer l : results.getDecorators()) {
                                config.includeLayer(l.getName());
                            }
                            for (Layer l : results.getExcludedLayers()) {
                                config.excludeLayer(l.getName());
                            }
                            builder.addConfig(config.build());
                            for (GalleonConfigurationWithLayers c : parsed.getDefinedConfigs()) {
                                builder.addConfig(c);
                            }
                            provisioning.storeProvisioningConfig(builder.build(), provisioningFile);
                            break block58;
                        }
                    }
                    results.outputConfig(outputFolder, null);
                }
            }
            catch (Exception ex) {
                if (ex instanceof MojoExecutionException) {
                    throw (MojoExecutionException)ex;
                }
                throw new MojoExecutionException(ex.getMessage(), ex);
            }
            finally {
                HiddenPropertiesAccessor.clearOverrides();
            }
        }
    }

    private String getJavaCommand() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        Path java = IS_WINDOWS ? javaHome.resolve("bin").resolve("java.exe") : javaHome.resolve("bin").resolve("java");
        if (Files.exists(java, new LinkOption[0])) {
            return java.toString();
        }
        return "java";
    }

    private Process startScanner(Path outputFolder, List<String> classes, List<String> testArtifacts) throws IOException, MojoExecutionException {
        StringBuilder classesLst = new StringBuilder();
        for (String string : classes) {
            classesLst.append(string).append(",");
        }
        StringBuilder pathList = new StringBuilder();
        for (String path : testArtifacts) {
            pathList.append(path).append(",");
        }
        Path path = outputFolder.resolve("glow-test-path-list.txt");
        Files.write(path, pathList.toString().getBytes(), new OpenOption[0]);
        if (this.verbose) {
            this.getLog().info((CharSequence)("SCANNER: Test elements: " + pathList));
            this.getLog().info((CharSequence)("SCANNER: Classes: " + classesLst));
        }
        StringBuilder cp = new StringBuilder();
        StringBuilder reducedCp = new StringBuilder();
        ScanMojo.collectCpPaths(System.getProperty("java.home"), Thread.currentThread().getContextClassLoader(), cp, this.verbose, reducedCp, this.getLog());
        if (this.verbose) {
            this.getLog().info((CharSequence)("SCANNER: classpath: " + cp));
            this.getLog().info((CharSequence)("SCANNER: bootstrap classpath: " + reducedCp));
        }
        Path cpFile = outputFolder.resolve("glow-test-cp-list.txt");
        Files.write(cpFile, cp.toString().getBytes(), new OpenOption[0]);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaCommand());
        cmd.add("-Dorg.wildfly.glow.scan");
        for (String sysPropName : this.systemPropertyVariables.keySet()) {
            cmd.add("-D" + sysPropName + "=" + this.systemPropertyVariables.get(sysPropName));
        }
        cmd.add("-cp");
        cmd.add(reducedCp.toString());
        cmd.add("org.wildfly.glow.plugin.arquillian.ScannerMain");
        cmd.add(cpFile.toAbsolutePath().toString());
        cmd.add(path.toAbsolutePath().toString());
        cmd.add(classesLst.toString());
        cmd.add(outputFolder.toAbsolutePath().toString());
        cmd.add(this.verbose || this.getLog().isDebugEnabled() ? "true" : "false");
        ProcessBuilder builder = new ProcessBuilder(cmd).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        return builder.start();
    }

    private static void collectCpPaths(String javaHome, ClassLoader cl, StringBuilder buf, boolean enableVerboseOutput, StringBuilder reducedCp, Log log) throws MojoExecutionException {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ScanMojo.collectCpPaths(javaHome, cl.getParent(), buf, enableVerboseOutput, reducedCp, log);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String filePath;
                File file;
                try {
                    file = new File(url.toURI());
                    filePath = file.getAbsolutePath();
                }
                catch (URISyntaxException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                }
                if (filePath.startsWith(javaHome)) continue;
                if (file.getName().contains("wildfly-glow-arquillian-plugin-scanner")) {
                    if (reducedCp.length() > 0) {
                        reducedCp.append(File.pathSeparator);
                    }
                    reducedCp.append(filePath);
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(filePath);
            }
        }
    }

    private Path buildInputConfig(Path outputFolder, MavenRepoManager artifactResolver) throws ProvisioningException, IOException, XMLStreamException {
        GalleonProvisioningConfig.Builder inBuilder = GalleonProvisioningConfig.builder();
        for (GalleonFeaturePack fp : this.featurePacks) {
            GalleonFeaturePackConfig.Builder builder = GalleonFeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)(fp.getLocation() == null ? fp.getMavenCoords() : fp.getLocation())));
            builder.includeAllPackages((Collection)fp.getIncludedPackages());
            GalleonFeaturePackConfig cfg = builder.build();
            inBuilder.addFeaturePackDep(cfg);
        }
        GalleonProvisioningConfig conf = inBuilder.build();
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver((RepositoryArtifactResolver)artifactResolver);
        try (Provisioning provisioning = provider.newProvisioningBuilder(conf).build();){
            Path p = outputFolder.resolve("glow-in-provisioning.xml");
            provisioning.storeProvisioningConfig(conf, p);
            Path path = p;
            return path;
        }
    }

    private List<Path> retrieveDeployments(List<String> testArtifacts, Path classesRootFolder, Path outputFolder) throws Exception {
        if (this.skipScanning) {
            return Collections.emptyList();
        }
        CopiedFromSureFirePlugin copiedFromSureFire = new CopiedFromSureFirePlugin(classesRootFolder, this.dependenciesToScan, this.project.getTestArtifacts(), this.selectPluginExecutionForDependencies());
        ArrayList<String> actualClasses = new ArrayList<String>();
        List<String> scannedClasses = copiedFromSureFire.scanForTestClasses().getClasses();
        for (String name : scannedClasses) {
            if (name.contains("$")) continue;
            actualClasses.add(name);
        }
        Process p = this.startScanner(outputFolder, actualClasses, testArtifacts);
        p.waitFor();
        ArrayList<Path> deployments = new ArrayList<Path>();
        List<String> lst = Files.readAllLines(outputFolder.resolve("glow-archive-list.txt"));
        for (String l : lst) {
            deployments.add(Paths.get(l, new String[0]));
        }
        return deployments;
    }

    private PluginExecution selectPluginExecutionForDependencies() {
        if (this.surefireExecutionForIncludedClasses == null) {
            return null;
        }
        Plugin plugin = this.project.getPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        Map surefireExecutions = plugin.getExecutionsAsMap();
        PluginExecution execution = (PluginExecution)surefireExecutions.get(this.surefireExecutionForIncludedClasses);
        if (execution == null) {
            throw new IllegalStateException("No maven-surefire-plugin execution called: " + this.surefireExecutionForIncludedClasses);
        }
        return execution;
    }

    private class MavenMessageWriter
    implements GlowMessageWriter {
        private MavenMessageWriter() {
        }

        public void info(Object s) {
            ScanMojo.this.getLog().info((CharSequence)s.toString());
        }

        public void warn(Object s) {
            ScanMojo.this.getLog().warn((CharSequence)s.toString());
        }

        public void error(Object s) {
            ScanMojo.this.getLog().error((CharSequence)s.toString());
        }

        public void trace(Object s) {
            ScanMojo.this.getLog().debug((CharSequence)s.toString());
        }
    }
}

