/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.maven;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.jboss.galleon.api.MavenStreamResolver;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.VersionResult;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.ChannelResolvable;
import org.wildfly.channel.spi.MavenVersionsResolver;

public class ChannelMavenArtifactRepositoryManager
implements MavenRepoManager,
ChannelResolvable,
MavenStreamResolver {
    private final ChannelSession channelSession;
    private final RepositorySystem system;
    private final DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
    private final List<RemoteRepository> repositories;

    public ChannelMavenArtifactRepositoryManager(List<Channel> channels, RepositorySystem system, RepositorySystemSession contextSession, List<RemoteRepository> repositories) throws Exception {
        this.repositories = repositories;
        this.session.setLocalRepositoryManager(contextSession.getLocalRepositoryManager());
        HashMap<String, RemoteRepository> mapping = new HashMap<String, RemoteRepository>();
        for (RemoteRepository r2 : repositories) {
            mapping.put(r2.getId(), r2);
        }
        Function<Repository, RemoteRepository> mapper = r -> {
            RemoteRepository rep = (RemoteRepository)mapping.get(r.getId());
            if (rep == null) {
                rep = (RemoteRepository)VersionResolverFactory.DEFAULT_REPOSITORY_MAPPER.apply(r);
            }
            return rep;
        };
        VersionResolverFactory factory = new VersionResolverFactory(system, (RepositorySystemSession)this.session, mapper);
        this.channelSession = new ChannelSession(channels, (MavenVersionsResolver.Factory)factory);
        this.system = system;
    }

    public ChannelSession getChannelSession() {
        return this.channelSession;
    }

    public void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        try {
            this.resolveFromChannels(artifact);
        }
        catch (ArtifactTransferException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (NoStreamFoundException ex) {
            if (artifact.getVersion() == null || artifact.getVersion().isEmpty()) {
                throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
            }
            try {
                MavenArtifact mavenArtifact = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
                artifact.setPath(mavenArtifact.getFile().toPath());
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void resolveFromChannels(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws UnresolvedMavenArtifactException {
        MavenArtifact result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
        artifact.setVersion(result.getVersion());
        artifact.setPath(result.getFile().toPath());
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, null, false);
    }

    public boolean isResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public boolean isLatestVersionResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, null, false);
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        artifact.setVersion(this.getLatestVersion(artifact));
        this.resolve(artifact);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        return this.getLatestVersion(artifact, null, null, null);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.getLatestVersion(artifact, lowestQualifier, null, null);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        try {
            return this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null).getVersion();
        }
        catch (UnresolvedMavenArtifactException e) {
            VersionRangeResult res = this.getVersionRange((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getVersionRange()));
            return res.getHighestVersion().toString();
        }
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public void install(org.jboss.galleon.universe.maven.MavenArtifact artifact, Path path) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public String getLatestVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) {
        VersionResult res = this.channelSession.findLatestMavenArtifactVersion(groupId, artifactId, extension, classifier, baseVersion);
        return res.getVersion();
    }

    private VersionRangeResult getVersionRange(Artifact artifact) throws MavenUniverseException {
        VersionRangeResult rangeResult;
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.repositories);
        try {
            rangeResult = this.system.resolveVersionRange((RepositorySystemSession)this.session, rangeRequest);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        return rangeResult;
    }
}

