/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.api;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftConfiguration;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class OpenShiftSupport {
    private static void createAppDeployment(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Map<String, String> env, boolean ha) throws Exception {
        writer.info((Object)"Deploying application image on OpenShift");
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("deployment", name);
        ContainerPort port = new ContainerPort();
        port.setContainerPort(Integer.valueOf(8080));
        port.setName("http");
        port.setProtocol("TCP");
        ContainerPort portAdmin = new ContainerPort();
        portAdmin.setContainerPort(Integer.valueOf(9990));
        portAdmin.setName("admin");
        portAdmin.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ports.add(portAdmin);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        if (ha) {
            writer.info((Object)"\n HA enabled, 2 replicas will be started.");
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("JGROUPS_PING_PROTOCOL")).withValue("DNS_PING")).build());
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("OPENSHIFT_DNS_PING_SERVICE_PORT")).withValue("8888")).build());
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("OPENSHIFT_DNS_PING_SERVICE_NAME")).withValue(name + "-ping")).build());
            IntOrString v = new IntOrString();
            v.setValue((Object)8888);
            Service pingService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name + "-ping")).endMetadata()).withNewSpec().withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(Integer.valueOf(8888))).withName("ping")).withTargetPort(v)).build()})).withClusterIP("None")).withPublishNotReadyAddresses()).withIpFamilies(new String[]{"IPv4"})).withInternalTrafficPolicy("Cluster")).withClusterIPs(new String[]{"None"})).withType("ClusterIP")).withIpFamilyPolicy("SingleStack")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
            ((ServiceResource)osClient.services().resource((Object)pingService)).createOr(Updatable::update);
            Utils.persistResource(target, pingService, name + "-ping-service.yaml");
        }
        Container container = new Container();
        container.setName(name);
        container.setImage(name + ":latest");
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Probe readinessProbe = new Probe();
        HTTPGetAction getAction = new HTTPGetAction();
        getAction.setPath("/health/ready");
        IntOrString pp = new IntOrString((Object)"admin");
        getAction.setPort(pp);
        getAction.setScheme("HTTP");
        readinessProbe.setHttpGet(getAction);
        readinessProbe.setTimeoutSeconds(Integer.valueOf(1));
        readinessProbe.setPeriodSeconds(Integer.valueOf(10));
        readinessProbe.setSuccessThreshold(Integer.valueOf(1));
        readinessProbe.setFailureThreshold(Integer.valueOf(3));
        container.setReadinessProbe(readinessProbe);
        container.setTerminationMessagePath("/dev/termination-log");
        Probe livenessProbe = new Probe();
        HTTPGetAction getAction2 = new HTTPGetAction();
        getAction2.setPath("/health/live");
        IntOrString pp2 = new IntOrString((Object)"admin");
        getAction2.setPort(pp2);
        getAction2.setScheme("HTTP");
        livenessProbe.setHttpGet(getAction);
        livenessProbe.setTimeoutSeconds(Integer.valueOf(1));
        livenessProbe.setPeriodSeconds(Integer.valueOf(10));
        livenessProbe.setSuccessThreshold(Integer.valueOf(1));
        livenessProbe.setFailureThreshold(Integer.valueOf(3));
        container.setLivenessProbe(livenessProbe);
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(ha ? 2 : 1))).withNewSelector().withMatchLabels(labels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(new Container[]{container})).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
        ((Resource)osClient.resources(Deployment.class).resource((Object)deployment)).createOr(Updatable::update);
        Utils.persistResource(target, deployment, name + "-deployment.yaml");
        IntOrString v = new IntOrString();
        v.setValue((Object)8080);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(Integer.valueOf(8080))).withTargetPort(v)).build()})).withType("ClusterIP")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
        ((ServiceResource)osClient.services().resource((Object)service)).createOr(Updatable::update);
        Utils.persistResource(target, service, name + "-service.yaml");
        writer.info((Object)"Waiting until the application is ready ...");
        ((Resource)osClient.resources(Deployment.class).resource((Object)deployment)).waitUntilReady(5L, TimeUnit.MINUTES);
    }

    public static void deploy(GlowMessageWriter writer, Path target, String appName, Map<String, String> env, Set<Layer> layers, Set<AddOn> addOns, boolean ha, Map<String, String> extraEnv, Set<String> disabledDeployers, Path initScript, Path cliScript, OpenShiftConfiguration config) throws Exception {
        TreeMap<String, String> actualEnv = new TreeMap<String, String>();
        OpenShiftClient osClient = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);
        writer.info((Object)"\nConnected to OpenShift cluster");
        Route route = ((RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(appName)).endMetadata()).withNewSpec().withTo(new RouteTargetReference("Service", appName, Integer.valueOf(100)))).withTls(((TLSConfigBuilder)((TLSConfigBuilder)new TLSConfig().toBuilder().withTermination("edge")).withInsecureEdgeTerminationPolicy("Redirect")).build())).endSpec()).build();
        ((Resource)osClient.routes().resource((Object)route)).createOr(Updatable::update);
        Utils.persistResource(target, route, appName + "-route.yaml");
        String host = ((Route)((Resource)osClient.routes().resource((Object)route)).get()).getSpec().getHost();
        HashMap<String, Deployer> existingDeployers = new HashMap<String, Deployer>();
        for (Deployer deployer : ServiceLoader.load(Deployer.class)) {
            existingDeployers.put(deployer.getName(), deployer);
        }
        for (String string : disabledDeployers) {
            if ("ALL".equals(string) || existingDeployers.containsKey(string)) continue;
            throw new Exception("Invalid deployer to disable: " + string);
        }
        block2: for (Deployer deployer : existingDeployers.values()) {
            boolean deployed = false;
            boolean isDisabled = OpenShiftSupport.isDisabled(deployer.getName(), disabledDeployers);
            for (Layer l : layers) {
                if (!deployer.getSupportedLayers().contains(l.getName())) continue;
                deployed = true;
                if (!isDisabled) {
                    writer.info((Object)("Found deployer " + deployer.getName() + " for " + l.getName()));
                } else {
                    writer.warn((Object)("The deployer " + deployer.getName() + " has been disabled"));
                }
                actualEnv.putAll(isDisabled ? Collections.emptyMap() : deployer.deploy(writer, target, osClient, env, host, appName, l.getName(), extraEnv));
                break;
            }
            if (deployed) continue;
            for (AddOn ao : addOns) {
                if (!ao.getFamily().equals(deployer.getSupportedAddOnFamily()) || !deployer.getSupportedAddOns().contains(ao.getName())) continue;
                if (!isDisabled) {
                    writer.info((Object)("Found deployer " + deployer.getName() + " for " + ao.getName()));
                } else {
                    writer.warn((Object)("The deployer " + deployer.getName() + " has been disabled"));
                }
                actualEnv.putAll(isDisabled ? Collections.emptyMap() : deployer.deploy(writer, target, osClient, env, host, appName, ao.getName(), extraEnv));
                continue block2;
            }
        }
        OpenShiftSupport.createBuild(writer, target, osClient, appName, initScript, cliScript, config);
        actualEnv.put("APPLICATION_ROUTE_HOST", host);
        actualEnv.putAll(extraEnv);
        if (!actualEnv.isEmpty()) {
            if (!disabledDeployers.isEmpty()) {
                writer.warn((Object)("\nThe following environment variables have been set in the " + appName + " deployment. Make sure that the required env variables for the disabled deployer(s) have been set:\n"));
            } else {
                writer.warn((Object)("\nThe following environment variables have been set in the " + appName + " deployment:\n"));
            }
            for (Map.Entry entry : actualEnv.entrySet()) {
                writer.warn((Object)((String)entry.getKey() + "=" + (String)entry.getValue()));
            }
            writer.warn((Object)"\n");
        }
        OpenShiftSupport.createAppDeployment(writer, target, osClient, appName, actualEnv, ha);
        writer.info((Object)("\nApplication route: https://" + host + (String)("ROOT.war".equals(appName) ? "" : "/" + appName)));
    }

    private static void createBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Path initScript, Path cliScript, OpenShiftConfiguration config) throws Exception {
        String serverImageName = OpenShiftSupport.doServerImageBuild(writer, target, osClient, config);
        OpenShiftSupport.doAppImageBuild(serverImageName, writer, target, osClient, name, initScript, cliScript, config);
    }

    private static boolean packageInitScript(Path initScript, Path cliScript, Path target) throws Exception {
        if (initScript != null || cliScript != null) {
            Path extensions = target.resolve("extensions");
            Files.createDirectories(extensions, new FileAttribute[0]);
            StringBuilder initExecution = new StringBuilder();
            initExecution.append("#!/bin/bash").append("\n");
            if (initScript != null) {
                initExecution.append("echo \"Calling initialization script\"").append("\n");
                Path init = extensions.resolve("init-script.sh");
                Files.copy(initScript, init, new CopyOption[0]);
                initExecution.append("sh $JBOSS_HOME/extensions/init-script.sh").append("\n");
            }
            if (cliScript != null) {
                initExecution.append("echo \"Calling CLI script\"").append("\n");
                Path cli = extensions.resolve("cli-script.cli");
                Files.copy(cliScript, cli, new CopyOption[0]);
                initExecution.append("cat $JBOSS_HOME/extensions/cli-script.cli >> \"${CLI_SCRIPT_FILE}\"");
            }
            Path postconfigure = extensions.resolve("postconfigure.sh");
            Files.write(postconfigure, initExecution.toString().getBytes(), new OpenOption[0]);
            return true;
        }
        return false;
    }

    private static boolean isDisabled(String name, Set<String> disabledDeployers) {
        return disabledDeployers.contains("ALL") || disabledDeployers.contains(name);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static Map<String, String> createLabels(Path target, Path provisioning, OpenShiftConfiguration osConfig) throws Exception {
        GalleonBuilder provider = new GalleonBuilder();
        Path dir = target.resolve("tmp").resolve("tmpHome");
        Files.createDirectory(dir, new FileAttribute[0]);
        StringBuilder fps = new StringBuilder();
        HashMap<String, String> labels = new HashMap<String, String>();
        try (Provisioning p = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build();){
            GalleonProvisioningConfig config = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build().loadProvisioningConfig(provisioning);
            GalleonConfigurationWithLayers cl = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
            for (String s : cl.getIncludedLayers()) {
                labels.put(osConfig.getLabelRadical() + ".layer." + s, "");
            }
            for (String s : cl.getExcludedLayers()) {
                labels.put(osConfig.getLabelRadical() + ".excluded.layer." + s, "");
            }
            for (GalleonFeaturePackConfig gfpc : config.getFeaturePackDeps()) {
                if (fps.length() != 0) {
                    fps.append("_");
                }
                String producerName = gfpc.getLocation().getProducerName();
                int i = (producerName = producerName.replaceAll("::zip", "")).indexOf(":");
                if (i > 0) {
                    producerName = producerName.substring(i + 1);
                }
                producerName = producerName.replaceAll(":", "-");
                labels.put(osConfig.getLabelRadical() + ".feature-pack." + producerName, "");
            }
        }
        return labels;
    }

    private static String doServerImageBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, OpenShiftConfiguration config) throws Exception {
        Path provisioning = target.resolve("galleon").resolve("provisioning.xml");
        byte[] content = Files.readAllBytes(provisioning);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] encodedhash = digest.digest(content);
        String key = OpenShiftSupport.bytesToHex(encodedhash);
        String serverImageName = config.getServerImageNameRadical() + key;
        ImageStream stream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(serverImageName)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        ImageStream existingStream = (ImageStream)((Resource)osClient.imageStreams().resource((Object)stream)).get();
        if (existingStream == null) {
            writer.info((Object)"\nBuilding server image (this can take up to few minutes)...");
            Path file = target.resolve("tmp").resolve("openshiftServer.zip");
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
            Path stepOne = target.resolve("tmp").resolve("step-one");
            Files.createDirectories(stepOne, new FileAttribute[0]);
            IoUtils.copy((Path)target.resolve("galleon"), (Path)stepOne.resolve("galleon"));
            ZipUtils.zip((Path)stepOne, (Path)file);
            stream = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)stream.toBuilder().editOrNewMetadata().withLabels(OpenShiftSupport.createLabels(target, provisioning, config))).endMetadata()).build();
            ((Resource)osClient.imageStreams().resource((Object)stream)).createOr(Updatable::update);
            Utils.persistResource(target, stream, serverImageName + "-image-stream.yaml");
            BuildConfigBuilder builder = new BuildConfigBuilder();
            ObjectReference ref = new ObjectReference();
            ref.setKind("ImageStreamTag");
            ref.setName(serverImageName + ":latest");
            BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withName(serverImageName + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(serverImageName + ":latest")).endTo()).endOutput()).withNewStrategy().withNewSourceStrategy().withNewFrom().withKind("DockerImage")).withName(config.getBuilderImage())).endFrom()).withIncremental(Boolean.valueOf(true))).withEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("GALLEON_USE_LOCAL_FILE")).withValue("true")).build()})).endSourceStrategy()).endStrategy()).withNewSource().withType("Binary")).endSource()).endSpec()).build();
            ((BuildConfigResource)osClient.buildConfigs().resource((Object)buildConfig)).createOr(Updatable::update);
            Utils.persistResource(target, buildConfig, serverImageName + "-build-config.yaml");
            Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(serverImageName + "-build")).instantiateBinary().fromFile(file.toFile());
            CountDownLatch latch = new CountDownLatch(1);
            try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(OpenShiftSupport.getBuildWatcher(writer, latch));){
                latch.await();
            }
        }
        return serverImageName;
    }

    private static void doAppImageBuild(String serverImageName, GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Path initScript, Path cliScript, OpenShiftConfiguration config) throws Exception {
        Path stepTwo = target.resolve("tmp").resolve("step-two");
        IoUtils.copy((Path)target.resolve("deployments"), (Path)stepTwo.resolve("deployments"));
        StringBuilder dockerFileBuilder = new StringBuilder();
        dockerFileBuilder.append("FROM " + config.getRuntimeImage() + "\n");
        dockerFileBuilder.append("COPY --chown=jboss:root /server $JBOSS_HOME\n");
        dockerFileBuilder.append("COPY --chown=jboss:root deployments/* $JBOSS_HOME/standalone/deployments\n");
        if (OpenShiftSupport.packageInitScript(initScript, cliScript, stepTwo)) {
            dockerFileBuilder.append("COPY --chown=jboss:root extensions $JBOSS_HOME/extensions\n");
            dockerFileBuilder.append("RUN chmod ug+rwx $JBOSS_HOME/extensions/postconfigure.sh\n");
        }
        dockerFileBuilder.append("RUN chmod -R ug+rwX $JBOSS_HOME\n");
        Path dockerFile = stepTwo.resolve("Dockerfile");
        Files.write(dockerFile, dockerFileBuilder.toString().getBytes(), new OpenOption[0]);
        Path file2 = target.resolve("tmp").resolve("openshiftApp.zip");
        if (Files.exists(file2, new LinkOption[0])) {
            Files.delete(file2);
        }
        ZipUtils.zip((Path)stepTwo, (Path)file2);
        writer.info((Object)"\nBuilding application image...");
        ImageStream appStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        ((Resource)osClient.imageStreams().resource((Object)appStream)).createOr(Updatable::update);
        BuildConfigBuilder builder = new BuildConfigBuilder();
        ObjectReference ref = new ObjectReference();
        ref.setKind("ImageStreamTag");
        ref.setName(serverImageName + ":latest");
        ImageSourcePath srcPath = ((ImageSourcePathBuilder)((ImageSourcePathBuilder)new ImageSourcePathBuilder().withSourcePath("/opt/server")).withDestinationDir(".")).build();
        ImageSource imageSource = ((ImageSourceBuilder)((ImageSourceBuilder)new ImageSourceBuilder().withFrom(ref)).withPaths(new ImageSourcePath[]{srcPath})).build();
        BuildConfig buildConfig2 = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withName(name + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(name + ":latest")).endTo()).endOutput()).withNewSource().withType("Binary")).withImages(new ImageSource[]{imageSource})).endSource()).withNewStrategy().withNewDockerStrategy().withNewFrom().withKind("DockerImage")).withName("quay.io/wildfly/wildfly-runtime:latest")).endFrom()).withDockerfilePath("./Dockerfile")).endDockerStrategy()).endStrategy()).endSpec()).build();
        ((BuildConfigResource)osClient.buildConfigs().resource((Object)buildConfig2)).createOr(Updatable::update);
        Utils.persistResource(target, buildConfig2, name + "-build-config.yaml");
        Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(name + "-build")).instantiateBinary().fromFile(file2.toFile());
        CountDownLatch latch = new CountDownLatch(1);
        try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(OpenShiftSupport.getBuildWatcher(writer, latch));){
            latch.await();
        }
    }

    private static Watcher<Build> getBuildWatcher(final GlowMessageWriter writer, final CountDownLatch latch) {
        return new Watcher<Build>(){

            public void eventReceived(Watcher.Action action, Build build) {
                String phase = build.getStatus().getPhase();
                if ("Running".equals(phase)) {
                    writer.info((Object)"Build is running...");
                }
                if ("Complete".equals(phase)) {
                    writer.info((Object)"Build is complete.");
                    latch.countDown();
                }
            }

            public void onClose(WatcherException cause) {
            }
        };
    }
}

