/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.api;

public class OpenShiftConfiguration {
    private final String labelRadical;
    private final String serverImageNameRadical;
    private final String builderImage;
    private final String runtimeImage;

    private OpenShiftConfiguration(String labelRadical, String serverImageNameRadical, String builderImage, String runtimeImage) {
        this.labelRadical = labelRadical;
        this.serverImageNameRadical = serverImageNameRadical;
        this.builderImage = builderImage;
        this.runtimeImage = runtimeImage;
    }

    public String getLabelRadical() {
        return this.labelRadical;
    }

    public String getServerImageNameRadical() {
        return this.serverImageNameRadical;
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public String getRuntimeImage() {
        return this.runtimeImage;
    }

    public static class Builder {
        private String labelRadical = "org.wildfly.glow";
        private String serverImageNameRadical = "wildfly-server-";
        private String builderImage = "quay.io/wildfly/wildfly-s2i:latest";
        private String runtimeImage = "quay.io/wildfly/wildfly-runtime:latest";

        public Builder setLabelRadical(String radical) {
            this.labelRadical = radical;
            return this;
        }

        public Builder setServerImageNameRadical(String radical) {
            this.serverImageNameRadical = radical;
            return this;
        }

        public Builder setBuilderImage(String img) {
            this.builderImage = img;
            return this;
        }

        public Builder setRuntimeImage(String img) {
            this.runtimeImage = img;
            return this;
        }

        public OpenShiftConfiguration build() {
            return new OpenShiftConfiguration(this.labelRadical, this.serverImageNameRadical, this.builderImage, this.runtimeImage);
        }
    }
}

