/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.keycloak;

import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class KeycloakDeployer
implements Deployer {
    private static final String KEYCLOAK_TEMPLATE_URL = "https://raw.githubusercontent.com/keycloak/keycloak-quickstarts/23.0.7/openshift/keycloak.yaml";
    private static final String KEYCLOAK_NAME = "keycloak";
    private static final String WILDFLY_REALM_PATH = "/realms/WildFly";
    private static final String KEYCLOAK_ADMIN = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_DEMO = "demo";
    private static final String KEYCLOAK_DEMO_PASSWORD = "demo";
    private static final String KEYCLOAK_ADMIN_ENV = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_ADMIN_PASSWORD_ENV = "KEYCLOAK_ADMIN_PASSWORD";
    private static final String OIDC_PROVIDER_URL_ENV = "OIDC_PROVIDER_URL";
    private static final String OIDC_PROVIDER_NAME_ENV = "OIDC_PROVIDER_NAME";
    private static final String OIDC_SECURE_DEPLOYMENT_SECRET_ENV = "OIDC_SECURE_DEPLOYMENT_SECRET";
    private static final String OIDC_USER_NAME_ENV = "OIDC_USER_NAME";
    private static final String OIDC_USER_PASSWORD_ENV = "OIDC_USER_PASSWORD";
    private static final String OIDC_HOSTNAME_HTTPS_ENV = "OIDC_HOSTNAME_HTTPS";
    private static final String MYSECRET = "mysecret";
    private static final String NAMESPACE_ENV = "NAMESPACE";
    private static final Set<String> RESOLVED_ENVS = new HashSet<String>();

    public Map<String, String> disabledDeploy(String appHost, String appName, String matching, Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(OIDC_HOSTNAME_HTTPS_ENV, appHost);
        ret.putAll(this.getExistingEnv(env));
        return ret;
    }

    private Map<String, String> getExistingEnv(Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().startsWith("OIDC_")) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public Map<String, String> deploy(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> env, String appHost, String appName, String matching, Map<String, String> extraEnv) throws Exception {
        writer.info((Object)"Deploying Keycloak server");
        HashMap<String, String> parameters = new HashMap<String, String>();
        String adminVal = extraEnv.get(KEYCLOAK_ADMIN_ENV);
        parameters.put(KEYCLOAK_ADMIN_ENV, adminVal == null ? "admin" : adminVal);
        String adminPassword = extraEnv.get(KEYCLOAK_ADMIN_PASSWORD_ENV);
        parameters.put(KEYCLOAK_ADMIN_PASSWORD_ENV, adminPassword == null ? "admin" : adminPassword);
        parameters.put(NAMESPACE_ENV, osClient.getNamespace());
        Template t = (Template)((TemplateResource)osClient.templates().load(new URL(KEYCLOAK_TEMPLATE_URL))).createOr(Updatable::update);
        KubernetesList processedTemplateWithCustomParameters = ((TemplateResource)osClient.templates().withName(KEYCLOAK_NAME)).process(parameters);
        osClient.resourceList((KubernetesResourceList)processedTemplateWithCustomParameters).createOrReplace();
        Utils.persistResource((Path)target, (Object)processedTemplateWithCustomParameters, (String)"keycloak-resources.yaml");
        writer.info((Object)"Waiting until keycloak is ready ...");
        DeploymentConfig dc = ((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(KEYCLOAK_NAME)).endMetadata()).build();
        ((Resource)osClient.resources(DeploymentConfig.class).resource((Object)dc)).waitUntilReady(5L, TimeUnit.MINUTES);
        Route route = ((RouteBuilder)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(KEYCLOAK_NAME)).endMetadata()).build();
        String host = ((Route)((Resource)osClient.routes().resource((Object)route)).get()).getSpec().getHost();
        String url = "https://" + host;
        writer.info((Object)("Keycloak route: " + url));
        HashMap<String, String> retEnv = new HashMap<String, String>();
        String realmUrl = url + WILDFLY_REALM_PATH;
        writer.warn((Object)"NOTE: Some actions must be taken from the keycloack console.");
        writer.warn((Object)("1- Use admin/admin to log to the console " + url));
        writer.warn((Object)"2- Create a realm named WildFly");
        writer.warn((Object)"3- Create a user named demo, password demo");
        writer.warn((Object)"4- Create a role needed by your application and assign it to the demo user");
        if (env.containsKey(OIDC_PROVIDER_URL_ENV)) {
            writer.warn((Object)"5- Assign the role 'realm-management create-client' to the demo user");
            writer.warn((Object)"NOTE: In case your application is deployed prior you completed the keycloak admin tasks, make sure to re-deploy your application.");
        } else {
            writer.warn((Object)("5 - Create an OIDC Client named the way your OIDC configuration expects it. Set its Root URL to  'https://" + appHost + (String)("ROOT.war".equals(appName) ? "" : "/" + appName) + "'"));
        }
        retEnv.put(OIDC_PROVIDER_URL_ENV, realmUrl);
        if (env.containsKey(OIDC_PROVIDER_URL_ENV)) {
            retEnv.put(OIDC_PROVIDER_NAME_ENV, KEYCLOAK_NAME);
            retEnv.put(OIDC_SECURE_DEPLOYMENT_SECRET_ENV, MYSECRET);
            retEnv.put(OIDC_USER_NAME_ENV, "demo");
            retEnv.put(OIDC_USER_PASSWORD_ENV, "demo");
            retEnv.put(OIDC_HOSTNAME_HTTPS_ENV, appHost);
        }
        writer.info((Object)"Keycloak server has been deployed");
        return retEnv;
    }

    public Set<Env> getResolvedEnvs(Set<Env> input) {
        HashSet<Env> envs = new HashSet<Env>();
        for (Env env : input) {
            if (!RESOLVED_ENVS.contains(env.getName())) continue;
            envs.add(env);
        }
        return envs;
    }

    public Set<String> getSupportedLayers() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("elytron-oidc-client");
        return ret;
    }

    public String getName() {
        return KEYCLOAK_NAME;
    }

    static {
        RESOLVED_ENVS.add(OIDC_PROVIDER_URL_ENV);
        RESOLVED_ENVS.add(OIDC_SECURE_DEPLOYMENT_SECRET_ENV);
        RESOLVED_ENVS.add(OIDC_USER_NAME_ENV);
        RESOLVED_ENVS.add(OIDC_USER_PASSWORD_ENV);
        RESOLVED_ENVS.add(OIDC_PROVIDER_NAME_ENV);
        RESOLVED_ENVS.add(OIDC_HOSTNAME_HTTPS_ENV);
    }
}

