/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.core.model.bridge.impl.LegacyControllerKernelServicesProxy;
import org.jboss.as.core.model.test.AbstractKernelServicesImpl;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelHandler;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;

public class MainKernelServicesImpl
extends AbstractKernelServicesImpl {
    private final ExtensionRegistry extensionRegistry;
    private static TransformationTarget.IgnoredTransformationRegistry MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY = new TransformationTarget.IgnoredTransformationRegistry(){

        public boolean isResourceTransformationIgnored(PathAddress address) {
            return false;
        }

        public boolean isOperationTransformationIgnored(PathAddress address) {
            return false;
        }

        public String getHostName() {
            return null;
        }
    };

    public MainKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, ExtensionRegistry extensionRegistry) {
        super(container, controllerService, persister, rootRegistration, operationValidator, legacyModelVersion, successfulBoot, bootError, extensionRegistry);
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        this.checkIsMainController();
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        TransformerRegistry transformerRegistry = this.extensionRegistry.getTransformerRegistry();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Map subsystemVersions = Collections.emptyMap();
        OperationTransformerRegistry registry = transformerRegistry.resolveHost(modelVersion, subsystemVersions);
        TransformationTargetImpl target = TransformationTargetImpl.create((TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)modelVersion, subsystemVersions, (TransformationTarget.IgnoredTransformationRegistry)MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.DOMAIN, null);
        TransformationContext transformationContext = this.createTransformationContext((TransformationTarget)target);
        OperationTransformer operationTransformer = registry.resolveOperationTransformer(address, operation.get("operation").asString(), null).getTransformer();
        if (operationTransformer != null) {
            return operationTransformer.transformOperation(transformationContext, address, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public ModelNode readTransformedModel(ModelVersion modelVersion) {
        this.checkIsMainController();
        ModelNode domainModel = new ModelNode();
        for (ModelNode entry : this.callReadMasterDomainModelHandler(modelVersion).asList()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)entry.require("domain-resource-address"));
            ModelNode toSet = domainModel;
            for (PathElement pathElement : address) {
                toSet = toSet.get(new String[]{pathElement.getKey(), pathElement.getValue()});
            }
            toSet.set(entry.require("domain-resource-model"));
        }
        return domainModel;
    }

    @Override
    public ModelNode callReadMasterDomainModelHandler(ModelVersion modelVersion) {
        this.checkIsMainController();
        TransformationTargetImpl target = TransformationTargetImpl.create((TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)modelVersion, Collections.emptyMap(), (TransformationTarget.IgnoredTransformationRegistry)MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.DOMAIN, null);
        Transformers transformers = Transformers.Factory.create((TransformationTarget)target);
        DomainControllerRuntimeIgnoreTransformationRegistry registry = new DomainControllerRuntimeIgnoreTransformationRegistry();
        registry.initializeHost("host");
        ModelNode fakeOP = new ModelNode();
        fakeOP.get("operation").set("fake");
        ModelNode result = this.internalExecute(fakeOP, (OperationStepHandler)new ReadMasterDomainModelHandler("host", transformers, registry));
        if ("failed".equals(result.get("outcome").asString())) {
            throw new RuntimeException(result.get("failure-description").asString());
        }
        return result.get("result");
    }

    @Override
    public void applyMasterDomainModel(ModelVersion modelVersion, List<IgnoreDomainResourceTypeResource> ignoredResources) {
        this.checkIsMainController();
        LegacyControllerKernelServicesProxy legacyServices = (LegacyControllerKernelServicesProxy)this.getLegacyServices(modelVersion);
        ModelNode masterResources = this.callReadMasterDomainModelHandler(modelVersion);
        legacyServices.applyMasterDomainModel(masterResources, ignoredResources);
    }

    @Override
    public ModelNode executeOperation(ModelVersion modelVersion, final OperationTransformer.TransformedOperation op) {
        OperationResultTransformer resultTransformer;
        KernelServices legacy = (KernelServices)this.getLegacyServices(modelVersion);
        ModelNode result = new ModelNode();
        if (op.getTransformedOperation() != null) {
            result = legacy.executeOperation(op.getTransformedOperation(), new ModelController.OperationTransactionControl(){

                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    if (op.rejectOperation(result)) {
                        transaction.rollback();
                    } else {
                        transaction.commit();
                    }
                }
            });
        }
        if ((resultTransformer = op.getResultTransformer()) != null) {
            result = resultTransformer.transformResult(result);
        }
        return result;
    }
}

