/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerEntry;
import org.jboss.as.controller.transform.TransformersLogger;
import org.jboss.dmr.ModelNode;

class ResourceTransformationContextImpl
implements ResourceTransformationContext {
    private final Resource root;
    private final PathAddress current;
    private final PathAddress read;
    private final OriginalModel originalModel;
    private final TransformersLogger logger;
    private final boolean skipRuntimeIgnoreCheck;

    static ResourceTransformationContext create(OperationContext context, TransformationTarget target, boolean skipRuntimeIgnoreCheck) {
        return ResourceTransformationContextImpl.create(context, target, PathAddress.EMPTY_ADDRESS, PathAddress.EMPTY_ADDRESS, skipRuntimeIgnoreCheck);
    }

    static ResourceTransformationContext create(OperationContext context, TransformationTarget target, PathAddress current, PathAddress read, boolean skipRuntimeIgnoreCheck) {
        Resource root = Resource.Factory.create();
        Resource original = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
        ImmutableManagementResourceRegistration registration = context.getRootResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS);
        OriginalModel originalModel = new OriginalModel(original, context.getRunningMode(), context.getProcessType(), target, registration);
        return new ResourceTransformationContextImpl(root, current, read, originalModel, skipRuntimeIgnoreCheck);
    }

    static ResourceTransformationContext create(TransformationTarget target, Resource model, ImmutableManagementResourceRegistration registration, RunningMode runningMode, ProcessType type, boolean skipRuntimeIgnoreCheck) {
        Resource root = Resource.Factory.create();
        OriginalModel originalModel = new OriginalModel(model, runningMode, type, target, registration);
        return new ResourceTransformationContextImpl(root, PathAddress.EMPTY_ADDRESS, originalModel, skipRuntimeIgnoreCheck);
    }

    private ResourceTransformationContextImpl(Resource root, PathAddress address, OriginalModel originalModel, boolean skipRuntimeIgnoreCheck) {
        this(root, address, address, originalModel, skipRuntimeIgnoreCheck);
    }

    private ResourceTransformationContextImpl(Resource root, PathAddress address, PathAddress read, OriginalModel originalModel, boolean skipRuntimeIgnoreCheck) {
        this.root = root;
        this.current = address;
        this.read = read;
        this.originalModel = originalModel;
        this.logger = TransformersLogger.getLogger(originalModel.target);
        this.skipRuntimeIgnoreCheck = skipRuntimeIgnoreCheck;
    }

    private ResourceTransformationContextImpl(ResourceTransformationContextImpl context, OriginalModel originalModel) {
        this.root = context.root.clone();
        this.current = context.current;
        this.read = context.read;
        this.logger = context.getLogger();
        this.skipRuntimeIgnoreCheck = context.skipRuntimeIgnoreCheck;
        this.originalModel = originalModel;
    }

    ResourceTransformationContextImpl copy(OperationTransformerRegistry.PlaceholderResolver placeholderResolver) {
        assert (this.originalModel.target instanceof TransformationTargetImpl) : "Wrong target";
        TransformationTargetImpl tgt = (TransformationTargetImpl)this.originalModel.target;
        TransformationTargetImpl targetCopy = tgt.copyWithplaceholderResolver(placeholderResolver);
        OriginalModel originalModelCopy = new OriginalModel(this.originalModel.original, this.originalModel.mode, this.originalModel.type, targetCopy, this.originalModel.registration);
        return new ResourceTransformationContextImpl(this, originalModelCopy);
    }

    public ResourceTransformationContext copyAndReplaceOriginalModel(OperationTransformerRegistry.PlaceholderResolver placeholderResolver) {
        assert (this.originalModel.target instanceof TransformationTargetImpl) : "Wrong target";
        TransformationTargetImpl tgt = (TransformationTargetImpl)this.originalModel.target;
        TransformationTargetImpl targetCopy = tgt.copyWithplaceholderResolver(placeholderResolver);
        OriginalModel originalModelCopy = new OriginalModel(this.root, this.originalModel.mode, this.originalModel.type, targetCopy, this.originalModel.registration);
        ResourceTransformationContextImpl copy = new ResourceTransformationContextImpl(this, originalModelCopy);
        Resource root = copy.getTransformedRoot();
        if (this.current.size() > 0) {
            PathElement last = this.current.getLastElement();
            Resource parent = root;
            for (PathElement element : this.current) {
                if (element.equals(last)) {
                    parent.removeChild(element);
                    continue;
                }
                if ((parent = parent.getChild(element)) != null) continue;
                break;
            }
        }
        return copy;
    }

    public Resource createResource(PathAddress element) {
        PathAddress absoluteAddress = this.current.append(element);
        PathAddress readAddress = this.read.append(element);
        Resource resource = Resource.Factory.create();
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, readAddress, resource);
        return resource;
    }

    public Resource createResource(PathAddress element, Resource copy) {
        PathAddress absoluteAddress = this.current.append(element);
        PathAddress readAddress = this.read.append(element);
        Resource resource = Resource.Factory.create();
        resource.writeModel(copy.getModel());
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, readAddress, resource);
        return resource;
    }

    @Override
    public ResourceTransformationContext addTransformedResource(PathAddress address, Resource toAdd) {
        PathAddress absoluteAddress = this.current.append(address);
        PathAddress read = this.read.append(address);
        return this.addTransformedResourceFromRoot(absoluteAddress, read, toAdd);
    }

    @Override
    public ResourceTransformationContext addTransformedResourceFromRoot(PathAddress absoluteAddress, Resource toAdd) {
        return this.addTransformedResourceFromRoot(absoluteAddress, absoluteAddress, toAdd);
    }

    public ResourceTransformationContext addTransformedResourceFromRoot(PathAddress absoluteAddress, PathAddress read, Resource toAdd) {
        Resource copy = Resource.Factory.create();
        if (toAdd != null) {
            copy.writeModel(toAdd.getModel());
        }
        return this.addTransformedRecursiveResourceFromRoot(absoluteAddress, read, copy);
    }

    @Override
    public void addTransformedRecursiveResource(PathAddress relativeAddress, Resource resource) {
        PathAddress absoluteAddress = this.current.append(relativeAddress);
        PathAddress readAddress = this.read.append(relativeAddress);
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, readAddress, resource);
    }

    private ResourceTransformationContext addTransformedRecursiveResourceFromRoot(PathAddress absoluteAddress, PathAddress read, Resource toAdd) {
        Resource model = this.root;
        if (absoluteAddress.size() > 0) {
            Iterator i = absoluteAddress.iterator();
            while (i.hasNext()) {
                PathElement element = (PathElement)i.next();
                if (element.isMultiTarget()) {
                    throw ControllerLogger.ROOT_LOGGER.cannotWriteTo("*");
                }
                if (!i.hasNext()) {
                    if (model.hasChild(element)) {
                        throw ControllerLogger.ROOT_LOGGER.duplicateResourceAddress(absoluteAddress);
                    }
                    model.registerChild(element, toAdd);
                    model = toAdd;
                    continue;
                }
                if ((model = model.getChild(element)) != null) continue;
                PathAddress ancestor = PathAddress.EMPTY_ADDRESS;
                for (PathElement pe : absoluteAddress) {
                    ancestor = ancestor.append(pe);
                    if (!element.equals(pe)) continue;
                    break;
                }
                throw ControllerLogger.ROOT_LOGGER.resourceNotFound(ancestor, absoluteAddress);
            }
        } else {
            model.writeModel(toAdd.getModel());
        }
        return new ResourceTransformationContextImpl(this.root, absoluteAddress, read, this.originalModel, this.skipRuntimeIgnoreCheck);
    }

    @Override
    public Resource readTransformedResource(PathAddress relativeAddress) {
        PathAddress address = this.current.append(relativeAddress);
        return Resource.Tools.navigate(this.root, address);
    }

    public TransformerEntry resolveTransformerEntry(PathAddress address) {
        TransformerEntry entry = this.originalModel.target.getTransformerEntry(this, address);
        if (entry == null) {
            return TransformerEntry.ALL_DEFAULTS;
        }
        return entry;
    }

    protected ResourceTransformer resolveTransformer(TransformerEntry entry, PathAddress address) {
        ResourceTransformer transformer = entry.getResourceTransformer();
        if (transformer == null) {
            ImmutableManagementResourceRegistration childReg = this.originalModel.getRegistration(address);
            if (childReg == null) {
                return ResourceTransformer.DISCARD;
            }
            if (childReg.isRemote() || childReg.isRuntimeOnly()) {
                return ResourceTransformer.DISCARD;
            }
            return ResourceTransformer.DEFAULT;
        }
        return transformer;
    }

    @Override
    public void processChildren(Resource resource) throws OperationFailedException {
        Set<String> types = resource.getChildTypes();
        for (String type : types) {
            for (Resource.ResourceEntry child : resource.getChildren(type)) {
                this.processChild(child.getPathElement(), child);
            }
        }
    }

    @Override
    public void processChild(final PathElement element, Resource child) throws OperationFailedException {
        final PathAddress childAddress = this.read.append(element);
        TransformerEntry entry = this.resolveTransformerEntry(childAddress);
        PathAddressTransformer path = entry.getPathTransformation();
        PathAddress currentAddress = path.transform(element, new PathAddressTransformer.Builder(){

            @Override
            public PathAddress getOriginal() {
                return childAddress;
            }

            @Override
            public PathAddress getCurrent() {
                return ResourceTransformationContextImpl.this.current;
            }

            @Override
            public PathAddress getRemaining() {
                return PathAddress.EMPTY_ADDRESS.append(element);
            }

            @Override
            public PathAddress next(PathElement ... elements) {
                return ResourceTransformationContextImpl.this.current.append(elements);
            }
        });
        ResourceTransformer transformer = this.resolveTransformer(entry, childAddress);
        ResourceTransformationContextImpl childContext = new ResourceTransformationContextImpl(this.root, currentAddress, childAddress, this.originalModel, this.skipRuntimeIgnoreCheck);
        transformer.transformResource(childContext, currentAddress, child);
    }

    @Override
    public TransformationTarget getTarget() {
        return this.originalModel.target;
    }

    @Override
    public ProcessType getProcessType() {
        return this.originalModel.type;
    }

    @Override
    public RunningMode getRunningMode() {
        return this.originalModel.mode;
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration(PathAddress address) {
        PathAddress a = this.read.append(address);
        return this.originalModel.getRegistration(a);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistrationFromRoot(PathAddress address) {
        return this.originalModel.getRegistration(address);
    }

    @Override
    public Resource readResource(PathAddress address) {
        PathAddress a = this.read.append(address);
        return this.originalModel.get(a);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.originalModel.get(address);
    }

    @Override
    public Resource getTransformedRoot() {
        return this.root;
    }

    @Deprecated
    static ResourceTransformationContext createAliasContext(PathAddress address, ResourceTransformationContext context) {
        if (context instanceof ResourceTransformationContextImpl) {
            ResourceTransformationContextImpl impl = (ResourceTransformationContextImpl)context;
            return new ResourceTransformationContextImpl(impl.root, address, impl.read, impl.originalModel, context.isSkipRuntimeIgnoreCheck());
        }
        throw new IllegalArgumentException("wrong context type");
    }

    @Deprecated
    static TransformationContext wrapForOperation(TransformationContext context, ModelNode operation) {
        if (context instanceof ResourceTransformationContextImpl) {
            ResourceTransformationContextImpl impl = (ResourceTransformationContextImpl)context;
            return new ResourceTransformationContextImpl(impl.root, PathAddress.pathAddress(operation.get("address")), impl.originalModel, context.isSkipRuntimeIgnoreCheck());
        }
        return context;
    }

    @Override
    public TransformersLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isSkipRuntimeIgnoreCheck() {
        return this.skipRuntimeIgnoreCheck;
    }

    static class OriginalModel {
        private final Resource original;
        private final RunningMode mode;
        private final ProcessType type;
        private final TransformationTarget target;
        private final ImmutableManagementResourceRegistration registration;

        OriginalModel(Resource original, RunningMode mode, ProcessType type, TransformationTarget target, ImmutableManagementResourceRegistration registration) {
            this.original = original;
            this.mode = mode;
            this.type = type;
            this.target = target;
            this.registration = registration;
        }

        Resource get(PathAddress address) {
            return this.original.navigate(address);
        }

        ImmutableManagementResourceRegistration getRegistration(PathAddress address) {
            return this.registration.getSubModel(address);
        }
    }
}

