/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.bridge.impl;

import java.util.List;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.model.test.AbstractKernelServicesImpl;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.core.model.test.LegacyModelInitializerEntry;
import org.jboss.as.core.model.test.ModelInitializer;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.core.model.test.TestParser;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLMapper;

public class ChildFirstClassLoaderKernelServicesFactory {
    public static KernelServices create(List<ModelNode> bootOperations, ModelTestOperationValidatorFilter validateOpsFilter, ModelVersion legacyModelVersion, List<LegacyModelInitializerEntry> modelInitializerEntries) throws Exception {
        TestModelType type = TestModelType.DOMAIN;
        XMLMapper xmlMapper = XMLMapper.Factory.create();
        TestParser testParser = TestParser.create(null, xmlMapper, type);
        LegacyModelInitializer modelInitializer = null;
        if (modelInitializerEntries != null && modelInitializerEntries.size() > 0) {
            modelInitializer = new LegacyModelInitializer(modelInitializerEntries);
        }
        HostRunningModeControl runningModeControl = new HostRunningModeControl(RunningMode.ADMIN_ONLY, RestartMode.HC_ONLY);
        ExtensionRegistry extensionRegistry = new ExtensionRegistry(ProcessType.HOST_CONTROLLER, (RunningModeControl)runningModeControl);
        return AbstractKernelServicesImpl.create(ProcessType.HOST_CONTROLLER, (RunningModeControl)runningModeControl, validateOpsFilter, bootOperations, testParser, legacyModelVersion, type, modelInitializer, extensionRegistry, null);
    }

    private static class LegacyModelInitializer
    implements ModelInitializer {
        private final List<LegacyModelInitializerEntry> entries;

        LegacyModelInitializer(List<LegacyModelInitializerEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void populateModel(Resource rootResource) {
            for (LegacyModelInitializerEntry entry : this.entries) {
                Resource parent = rootResource;
                if (entry.getParentAddress() != null && entry.getParentAddress().size() > 0) {
                    for (PathElement element : entry.getParentAddress()) {
                        parent = rootResource.getChild(element);
                        if (parent != null) continue;
                        throw new IllegalStateException("No parent at " + element);
                    }
                }
                Resource resource = Resource.Factory.create();
                if (entry.getModel() != null) {
                    resource.getModel().set(entry.getModel());
                }
                parent.registerChild(entry.getRelativeResourceAddress(), resource);
            }
        }
    }
}

