/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    NONE(null),
    XML_SCHEMA_INSTANCE("http://www.w3.org/2001/XMLSchema-instance"),
    DOMAIN_1_0(1, "urn:jboss:domain:1.0"),
    DOMAIN_1_1(1, "urn:jboss:domain:1.1"),
    DOMAIN_1_2(1, "urn:jboss:domain:1.2"),
    DOMAIN_1_3(1, "urn:jboss:domain:1.3"),
    DOMAIN_1_4(1, "urn:jboss:domain:1.4"),
    DOMAIN_1_5(1, "urn:jboss:domain:1.5"),
    DOMAIN_1_6(1, "urn:jboss:domain:1.6"),
    DOMAIN_2_0(2, "urn:jboss:domain:2.0"),
    DOMAIN_2_1(2, "urn:jboss:domain:2.1"),
    DOMAIN_2_2(2, "urn:jboss:domain:2.2"),
    DOMAIN_3_0(3, "urn:jboss:domain:3.0");

    public static final Namespace CURRENT;
    public static final Namespace[] ALL_NAMESPACES;
    private final int majorVersion;
    private final String name;
    public static final EnumSet<Namespace> STANDARD_NAMESPACES;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this(-1, name);
    }

    private Namespace(int majorVersion, String name) {
        this.majorVersion = majorVersion;
        this.name = name;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        if (uri == null || "".equals(uri)) {
            return NONE;
        }
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    public static Namespace[] domainValues() {
        Namespace[] temp = Namespace.values();
        Namespace[] response = new Namespace[temp.length - 3];
        int nextPos = 0;
        for (Namespace current : temp) {
            if (current == UNKNOWN || current == NONE || current == XML_SCHEMA_INSTANCE) continue;
            response[nextPos++] = current;
        }
        return response;
    }

    static {
        CURRENT = DOMAIN_3_0;
        ALL_NAMESPACES = new Namespace[]{DOMAIN_1_0, DOMAIN_1_1, DOMAIN_1_2, DOMAIN_1_3, DOMAIN_1_4, DOMAIN_1_5, DOMAIN_1_6, DOMAIN_2_0, DOMAIN_2_1, DOMAIN_2_2, DOMAIN_3_0};
        STANDARD_NAMESPACES = EnumSet.complementOf(EnumSet.of(UNKNOWN, XML_SCHEMA_INSTANCE));
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

