/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.VirtualFile;

public class ReadContentHandler
implements OperationStepHandler {
    protected final ContentRepository contentRepository;

    public ReadContentHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Resource resource = context.getOriginalRootResource();
        for (PathElement element : address) {
            resource = resource.getChild(element);
        }
        byte[] content = resource.getModel().get("content").asBytes();
        VirtualFile file = this.contentRepository.getContent(content);
        try {
            context.getResult().set(ReadContentHandler.readFile(file));
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.failedToLoadFile(file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(VirtualFile file) throws IOException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.openStream());
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

