/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.bridge.local;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.core.model.bridge.impl.ChildFirstClassLoaderKernelServicesFactory;
import org.jboss.as.core.model.bridge.impl.ClassLoaderObjectConverterImpl;
import org.jboss.as.core.model.bridge.impl.LegacyControllerKernelServicesProxy;
import org.jboss.as.core.model.bridge.local.ClassLoaderObjectConverter;
import org.jboss.as.core.model.test.LegacyModelInitializerEntry;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;

public class ScopedKernelServicesBootstrap {
    Stability stability;
    ClassLoader legacyChildFirstClassLoader;
    ClassLoaderObjectConverter objectConverter;

    public ScopedKernelServicesBootstrap(ClassLoader legacyChildFirstClassLoader, Stability stability) {
        this.legacyChildFirstClassLoader = legacyChildFirstClassLoader;
        this.objectConverter = new ClassLoaderObjectConverterImpl(this.getClass().getClassLoader(), legacyChildFirstClassLoader);
        this.stability = stability;
    }

    public LegacyControllerKernelServicesProxy createKernelServices(List<ModelNode> bootOperations, ModelTestOperationValidatorFilter validateOpsFilter, ModelVersion legacyModelVersion, List<LegacyModelInitializerEntry> modelInitializerEntries) throws Exception {
        Object childClassLoaderKernelServices = this.createChildClassLoaderKernelServices(bootOperations, validateOpsFilter, legacyModelVersion, modelInitializerEntries);
        return new LegacyControllerKernelServicesProxy(this.legacyChildFirstClassLoader, childClassLoaderKernelServices, this.objectConverter);
    }

    private Object createChildClassLoaderKernelServices(List<ModelNode> bootOperations, ModelTestOperationValidatorFilter validateOpsFilter, ModelVersion legacyModelVersion, List<LegacyModelInitializerEntry> modelInitializerEntries) {
        try {
            Class<?> clazz = this.legacyChildFirstClassLoader.loadClass(ChildFirstClassLoaderKernelServicesFactory.class.getName());
            List<Object> convertedBootOps = this.getConvertedBootOps(bootOperations);
            List<Object> convertedModelInitializerEntries = this.convertModelInitializer(modelInitializerEntries);
            Object convertedValidationFilter = this.objectConverter.convertValidateOperationsFilterToChildCl(validateOpsFilter);
            Object convertedLegacyModelVersion = this.objectConverter.convertModelVersionToChildCl(legacyModelVersion);
            if (!Stability.DEFAULT.equals((Object)this.stability)) {
                Method m = clazz.getMethod("create", List.class, this.legacyChildFirstClassLoader.loadClass(ModelTestOperationValidatorFilter.class.getName()), this.legacyChildFirstClassLoader.loadClass(ModelVersion.class.getName()), List.class, String.class);
                return m.invoke(null, convertedBootOps, convertedValidationFilter, convertedLegacyModelVersion, convertedModelInitializerEntries, this.stability.toString());
            }
            Method m = clazz.getMethod("create", List.class, this.legacyChildFirstClassLoader.loadClass(ModelTestOperationValidatorFilter.class.getName()), this.legacyChildFirstClassLoader.loadClass(ModelVersion.class.getName()), List.class);
            return m.invoke(null, convertedBootOps, convertedValidationFilter, convertedLegacyModelVersion, convertedModelInitializerEntries);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> convertModelInitializer(List<LegacyModelInitializerEntry> modelInitializerEntries) {
        ArrayList<Object> converted = null;
        if (modelInitializerEntries != null) {
            converted = new ArrayList<Object>();
            for (LegacyModelInitializerEntry entry : modelInitializerEntries) {
                converted.add(this.objectConverter.convertLegacyModelInitializerEntryToChildCl(entry));
            }
        }
        return converted;
    }

    private List<Object> getConvertedBootOps(List<ModelNode> bootOperations) {
        ArrayList<Object> converted = new ArrayList<Object>();
        for (ModelNode node : bootOperations) {
            if (node == null) continue;
            converted.add(this.objectConverter.convertModelNodeToChildCl(node));
        }
        return converted;
    }
}

