/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.core.model.test.LegacyKernelServicesImpl;
import org.jboss.as.core.model.test.MainKernelServicesImpl;
import org.jboss.as.core.model.test.ModelInitializer;
import org.jboss.as.core.model.test.TestModelControllerService;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestKernelServicesImpl;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.EnhancedQueueExecutor;
import org.wildfly.legacy.test.spi.core.TestModelControllerFactory;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

public abstract class AbstractKernelServicesImpl
extends ModelTestKernelServicesImpl<KernelServices>
implements KernelServices {
    static final AtomicInteger counter = new AtomicInteger();

    protected AbstractKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, ExtensionRegistry extensionRegistry) {
        super(container, controllerService, persister, rootRegistration, operationValidator, legacyModelVersion, successfulBoot, bootError);
    }

    public static AbstractKernelServicesImpl create(ProcessType processType, RunningModeControl runningModeControl, ModelTestOperationValidatorFilter validateOpsFilter, List<ModelNode> bootOperations, ModelTestParser testParser, ModelVersion legacyModelVersion, TestModelType type, ModelInitializer modelInitializer, ExtensionRegistry extensionRegistry, List<String> contentRepositoryHashes) throws Exception {
        ServiceLoader<TestModelControllerFactory> factoryLoader;
        Iterator<TestModelControllerFactory> iterator;
        ServiceContainer container = ServiceContainer.Factory.create((String)("core-test" + counter.incrementAndGet()));
        ServiceTarget target = container.subTarget();
        File repositoryFile = new File("target/deployment-repository");
        if (contentRepositoryHashes != null) {
            AbstractKernelServicesImpl.deleteFile(repositoryFile);
            repositoryFile.mkdir();
            for (String hash : contentRepositoryHashes) {
                File file = new File(repositoryFile, hash.substring(0, 2));
                file.mkdir();
                file = new File(file, hash.substring(2, hash.length()));
                file.mkdir();
                file = new File(file, "content");
                file.createNewFile();
            }
        }
        ContentRepository.Factory.addService((ServiceTarget)target, (File)repositoryFile);
        StringConfigurationPersister persister = new StringConfigurationPersister(bootOperations, (XMLElementWriter)testParser, true);
        TestModelControllerFactory testModelControllerFactory = StandardTestModelControllerServiceFactory.INSTANCE;
        if (legacyModelVersion != null && (iterator = (factoryLoader = ServiceLoader.load(TestModelControllerFactory.class, AbstractKernelServicesImpl.class.getClassLoader())).iterator()).hasNext()) {
            TestModelControllerFactory factory;
            testModelControllerFactory = factory = iterator.next();
        }
        ModelTestModelControllerService svc = testModelControllerFactory.create(processType, runningModeControl, persister, validateOpsFilter, type, modelInitializer, extensionRegistry);
        ServiceBuilder builder = target.addService(Services.JBOSS_SERVER_CONTROLLER, (org.jboss.msc.service.Service)svc);
        builder.addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, (Injector)testModelControllerFactory.getContentRepositoryInjector(svc));
        builder.install();
        if (legacyModelVersion == null) {
            EnhancedQueueExecutor mgmtExecutor = new EnhancedQueueExecutor.Builder().setCorePoolSize(1).setMaximumPoolSize(256).setKeepAliveTime(20L, TimeUnit.SECONDS).build();
            ServiceName sn = ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)Capabilities.MANAGEMENT_EXECUTOR);
            ServiceBuilder sb = target.addService(sn);
            Consumer c = sb.provides(new ServiceName[]{sn});
            sb.setInstance(Service.newInstance((Consumer)c, (Object)mgmtExecutor));
            sb.install();
        }
        svc.waitForSetup();
        AbstractKernelServicesImpl kernelServices = legacyModelVersion == null ? new MainKernelServicesImpl(container, svc, persister, svc.getRootRegistration(), new OperationValidator((ImmutableManagementResourceRegistration)svc.getRootRegistration()), legacyModelVersion, svc.isSuccessfulBoot(), svc.getBootError(), extensionRegistry) : new LegacyKernelServicesImpl(container, svc, persister, svc.getRootRegistration(), new OperationValidator((ImmutableManagementResourceRegistration)svc.getRootRegistration()), legacyModelVersion, svc.isSuccessfulBoot(), svc.getBootError(), extensionRegistry, ContentRepository.Factory.create((File)repositoryFile));
        return kernelServices;
    }

    private static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractKernelServicesImpl.deleteFile(child);
            }
        }
        file.delete();
    }

    public abstract OperationTransformer.TransformedOperation transformOperation(ModelVersion var1, ModelNode var2) throws OperationFailedException;

    public abstract ModelNode readTransformedModel(ModelVersion var1);

    public abstract ModelNode callReadMasterDomainModelHandler(ModelVersion var1);

    public abstract ModelNode executeOperation(ModelVersion var1, OperationTransformer.TransformedOperation var2);

    protected void addLegacyKernelService(ModelVersion modelVersion, KernelServices legacyServices) {
        super.addLegacyKernelService(modelVersion, (ModelTestKernelServices)legacyServices);
    }

    private static class StandardTestModelControllerServiceFactory
    implements TestModelControllerFactory {
        static final TestModelControllerFactory INSTANCE = new StandardTestModelControllerServiceFactory();

        private StandardTestModelControllerServiceFactory() {
        }

        public ModelTestModelControllerService create(ProcessType processType, RunningModeControl runningModeControl, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, TestModelType type, ModelInitializer modelInitializer, ExtensionRegistry extensionRegistry) {
            CapabilityRegistry cr = new CapabilityRegistry(processType.isServer());
            return TestModelControllerService.create(processType, runningModeControl, persister, validateOpsFilter, type, modelInitializer, extensionRegistry, cr);
        }

        public InjectedValue<ContentRepository> getContentRepositoryInjector(ModelTestModelControllerService service) {
            return ((TestModelControllerService)service).getContentRepositoryInjector();
        }
    }
}

