/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.model.test.ModelTestModelDescriptionValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class KnownIssuesValidationConfiguration
extends ModelTestModelDescriptionValidator.ValidationConfiguration {
    public static ModelTestModelDescriptionValidator.ValidationConfiguration createAndFixupModel(TestModelType type, ModelNode description) {
        switch (type) {
            case STANDALONE: {
                KnownIssuesValidationConfiguration.trimSubDeploymentDescription(description);
                return KnownIssuesValidationConfiguration.createForStandalone();
            }
            case DOMAIN: {
                return KnownIssuesValidationConfiguration.createForDomain();
            }
            case HOST: {
                KnownIssuesValidationConfiguration.replaceLocalDomainControllerType(description);
                return KnownIssuesValidationConfiguration.createForHost();
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    private static ModelTestModelDescriptionValidator.ValidationConfiguration createForStandalone() {
        ModelTestModelDescriptionValidator.ValidationConfiguration config = KnownIssuesValidationConfiguration.createWithGlobalOperations();
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createInterfaceMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createInterfaceMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createPathMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createPathMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("compilation"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("threading"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("operating-system"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("memory-pool"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("runtime"), "read-resource");
        ModelNode MEMORY_POOL_CHILDREN_ADDR = KnownIssuesValidationConfiguration.createStandlonePlatformMBeanAddress("memory-pool");
        MEMORY_POOL_CHILDREN_ADDR.add("name", "*");
        config.allowNullValueTypeForOperationReplyProperties(MEMORY_POOL_CHILDREN_ADDR, "read-resource");
        return config;
    }

    private static ModelTestModelDescriptionValidator.ValidationConfiguration createForHost() {
        ModelTestModelDescriptionValidator.ValidationConfiguration config = KnownIssuesValidationConfiguration.createWithGlobalOperations();
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createInterfaceMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createInterfaceMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createPathMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createPathMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createServerConfigInterfaceMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createServerConfigPathMBeanAddress(), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createServerConfigInterfaceMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createServerConfigPathMBeanAddress(), "read-attribute");
        config.allowNullValueTypeForAttribute(new ModelNode(), "domain-controller");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("compilation"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("threading"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("operating-system"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("memory-pool"), "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("runtime"), "read-resource");
        ModelNode MEMORY_POOL_CHILDREN_ADDR = KnownIssuesValidationConfiguration.createHostPlatformMBeanAddress("memory-pool");
        MEMORY_POOL_CHILDREN_ADDR.add("name", "*");
        config.allowNullValueTypeForOperationReplyProperties(MEMORY_POOL_CHILDREN_ADDR, "read-resource");
        config.allowNullValueTypeForOperationParameter(new ModelNode().add("host", "primary"), "validate-address", "value");
        return config;
    }

    private static ModelTestModelDescriptionValidator.ValidationConfiguration createForDomain() {
        ModelTestModelDescriptionValidator.ValidationConfiguration config = KnownIssuesValidationConfiguration.createWithGlobalOperations();
        ModelNode rolloutPlan = new ModelNode().add("management-client-content", "rollout-plans").add("rollout-plan", "*");
        config.allowNullValueTypeForAttribute(rolloutPlan, "content");
        config.allowNullValueTypeForOperationParameter(rolloutPlan, "store", "content");
        config.allowNullValueTypeForOperationParameter(rolloutPlan, "add", "content");
        return config;
    }

    private static ModelTestModelDescriptionValidator.ValidationConfiguration createWithGlobalOperations() {
        ModelTestModelDescriptionValidator.ValidationConfiguration config = new ModelTestModelDescriptionValidator.ValidationConfiguration();
        ModelNode ROOT_ADDR = new ModelNode().setEmptyList();
        config.allowNullValueTypeForOperationParameter(ROOT_ADDR, "validate-operation", "value");
        config.allowNullValueTypeForOperationParameter(ROOT_ADDR, "validate-address", "value");
        config.allowNullValueTypeForOperationReplyProperties(ROOT_ADDR, "read-operation-description");
        config.allowNullValueTypeForOperationReplyProperties(ROOT_ADDR, "read-resource-description");
        config.allowNullValueTypeForOperationReplyProperties(ROOT_ADDR, "read-resource");
        config.allowNullValueTypeForOperationReplyProperties(ROOT_ADDR, "read-attribute");
        return config;
    }

    private static ModelNode createStandlonePlatformMBeanAddress(String type) {
        ModelNode addr = new ModelNode();
        addr.add("core-service", "platform-mbean");
        addr.add("type", type);
        return addr;
    }

    private static ModelNode createHostPlatformMBeanAddress(String type) {
        ModelNode addr = new ModelNode();
        addr.add("core-service", "platform-mbean");
        addr.add("type", type);
        return addr;
    }

    private static ModelNode createInterfaceMBeanAddress() {
        ModelNode addr = new ModelNode();
        addr.add("interface", "*");
        return addr;
    }

    private static ModelNode createPathMBeanAddress() {
        ModelNode addr = new ModelNode();
        addr.add("path", "*");
        return addr;
    }

    private static ModelNode createServerConfigInterfaceMBeanAddress() {
        ModelNode addr = new ModelNode();
        addr.add("server-config", "*");
        addr.add("interface", "*");
        return addr;
    }

    private static ModelNode createServerConfigPathMBeanAddress() {
        ModelNode addr = new ModelNode();
        addr.add("server-config", "*");
        addr.add("path", "*");
        return addr;
    }

    public static void trimSubDeploymentDescription(ModelNode description) {
        KnownIssuesValidationConfiguration.remove(description, "subsystem", "children", "deployment", "model-description", "*", "children", "subdeployment", "model-description", "*", "children");
    }

    public static void replaceLocalDomainControllerType(ModelNode description) {
        ModelNode node = KnownIssuesValidationConfiguration.find(description, "attributes", "domain-controller", "value-type", "local", "type");
        if (node != null) {
            if (node.getType() != ModelType.TYPE && node.asType() != ModelType.OBJECT) {
                throw new IllegalStateException("Bad local domain controller " + node);
            }
            node.set(ModelType.STRING);
        }
    }

    private static void remove(ModelNode description, String remove, String ... parentKeys) {
        ModelNode node = KnownIssuesValidationConfiguration.find(description, parentKeys);
        if (node != null) {
            node.remove(remove);
        }
    }

    private static ModelNode find(ModelNode description, String ... parentKeys) {
        ModelNode current = description;
        for (String s : parentKeys) {
            if (!current.hasDefined(s)) {
                return null;
            }
            current = current.get(s);
        }
        return current;
    }
}

