/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.ManagementXmlSchema;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.core.model.test.ModelWriteSanitizer;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.host.controller.parsing.DomainXmlSchemas;
import org.jboss.as.host.controller.parsing.HostXmlSchemas;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.server.parsing.StandaloneXmlSchemas;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class TestParser
implements ModelTestParser {
    private final TestModelType type;
    private final XMLElementReader<List<ModelNode>> reader;
    private final XMLElementWriter<ModelMarshallingContext> writer;
    private volatile List<ModelWriteSanitizer> writeSanitizers;

    public TestParser(TestModelType type, XMLElementReader<List<ModelNode>> reader, XMLElementWriter<ModelMarshallingContext> writer) {
        this.type = type;
        this.reader = reader;
        this.writer = writer;
    }

    private static int getModelMajorVersion() {
        try {
            Class<?> versionClass = Class.forName("org.jboss.as.version.Version");
            Field majorVersionField = versionClass.getDeclaredField("MANAGEMENT_MAJOR_VERSION");
            return majorVersionField.getInt(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to obtain the major version of the model.", e);
        }
    }

    private static TestParser createLegacy(ExtensionRegistry registry, XMLMapper xmlMapper, TestModelType type) throws Exception {
        String root;
        Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
        Class<ExecutorService> executorServiceClass = ExecutorService.class;
        Class<?> extensionRegistryClass = Class.forName("org.jboss.as.controller.extension.ExtensionRegistry");
        Object xmlParser = null;
        if (type == TestModelType.STANDALONE) {
            Class<?> standaloneXmlClass = Class.forName("org.jboss.as.server.parsing.StandaloneXml");
            Constructor<?> standaloneXmlConstructor = standaloneXmlClass.getConstructor(moduleLoaderClass, executorServiceClass, extensionRegistryClass);
            xmlParser = standaloneXmlConstructor.newInstance(null, Executors.newCachedThreadPool(), registry);
            root = "server";
        } else if (type == TestModelType.DOMAIN) {
            Class<?> domainXmlClass = Class.forName("org.jboss.as.host.controller.parsing.DomainXml");
            Constructor<?> domainXmlConstructor = domainXmlClass.getConstructor(moduleLoaderClass, executorServiceClass, extensionRegistryClass);
            xmlParser = domainXmlConstructor.newInstance(null, Executors.newCachedThreadPool(), registry);
            root = "domain";
        } else if (type == TestModelType.HOST) {
            Class<?> hostXmlClass = Class.forName("org.jboss.as.host.controller.parsing.HostXml");
            Class<?> runningModeClass = Class.forName("org.jboss.as.controller.RunningMode");
            Constructor<?> hostXmlConstructor = hostXmlClass.getConstructor(String.class, runningModeClass, Boolean.TYPE, moduleLoaderClass, executorServiceClass, extensionRegistryClass);
            xmlParser = hostXmlConstructor.newInstance("primary", RunningMode.NORMAL, false, null, Executors.newCachedThreadPool(), registry);
            root = "host";
        } else {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        TestParser testParser = new TestParser(type, (XMLElementReader<List<ModelNode>>)((XMLElementReader)xmlParser), (XMLElementWriter<ModelMarshallingContext>)((XMLElementWriter)xmlParser));
        Class<?> namespaceClass = Class.forName("org.jboss.as.controller.parsing.Namespace");
        Field allNamespacesField = namespaceClass.getDeclaredField("ALL_NAMESPACES");
        Object[] allNamespaces = (Object[])allNamespacesField.get(null);
        Method getUriStringMethod = namespaceClass.getMethod("getUriString", new Class[0]);
        for (Object ns : allNamespaces) {
            xmlMapper.registerRootElement(new QName(getUriStringMethod.invoke(ns, new Object[0]).toString(), root), (XMLElementReader)testParser);
        }
        return testParser;
    }

    private static TestParser createFrom27(Stability stability, ExtensionRegistry registry, XMLMapper xmlMapper, TestModelType type) {
        StandaloneXmlSchemas schemas;
        if (type == TestModelType.STANDALONE) {
            schemas = new StandaloneXmlSchemas(stability, null, Executors.newCachedThreadPool(), registry);
        } else if (type == TestModelType.DOMAIN) {
            schemas = new DomainXmlSchemas(stability, null, Executors.newCachedThreadPool(), registry);
        } else if (type == TestModelType.HOST) {
            schemas = new HostXmlSchemas(stability, "primary", RunningMode.NORMAL, false, null, Executors.newCachedThreadPool(), registry);
        } else {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        ManagementXmlSchema schema = schemas.getCurrent();
        TestParser testParser = new TestParser(type, (XMLElementReader<List<ModelNode>>)schema, (XMLElementWriter<ModelMarshallingContext>)schema);
        xmlMapper.registerRootElement(schema.getQualifiedName(), (XMLElementReader)testParser);
        for (ManagementXmlSchema additional : schemas.getAdditional()) {
            xmlMapper.registerRootElement(additional.getQualifiedName(), (XMLElementReader)testParser);
        }
        return testParser;
    }

    public static TestParser create(ExtensionRegistry registry, XMLMapper xmlMapper, TestModelType type) {
        return TestParser.create(Stability.DEFAULT, registry, xmlMapper, type);
    }

    public static TestParser create(Stability stability, ExtensionRegistry registry, XMLMapper xmlMapper, TestModelType type) {
        if (TestParser.getModelMajorVersion() < 27) {
            try {
                return TestParser.createLegacy(registry, xmlMapper, type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create the parser", e);
            }
        }
        return TestParser.createFrom27(stability, registry, xmlMapper, type);
    }

    void addModelWriteSanitizer(ModelWriteSanitizer writeSanitizer) {
        if (writeSanitizer == null) {
            return;
        }
        if (this.writeSanitizers == null) {
            this.writeSanitizers = new ArrayList<ModelWriteSanitizer>();
        }
        this.writeSanitizers.add(writeSanitizer);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> value) throws XMLStreamException {
        this.reader.readElement(reader, value);
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, ModelMarshallingContext context) throws XMLStreamException {
        this.writer.writeContent(streamWriter, (Object)this.sanitizeContext(this.wrapPossibleHost(context)));
    }

    private ModelMarshallingContext wrapPossibleHost(final ModelMarshallingContext context) {
        if (this.type == TestModelType.HOST) {
            return new ModelMarshallingContext(){

                public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String subsystemName) {
                    return context.getSubsystemWriter(subsystemName);
                }

                public ModelNode getModelNode() {
                    return context.getModelNode().get(new String[]{"host", "primary"});
                }
            };
        }
        return context;
    }

    private ModelMarshallingContext sanitizeContext(final ModelMarshallingContext context) {
        if (this.writeSanitizers == null) {
            return context;
        }
        ModelNode model = context.getModelNode();
        for (ModelWriteSanitizer sanitizer : this.writeSanitizers) {
            model = sanitizer.sanitize(model);
        }
        final ModelNode theModel = model;
        return new ModelMarshallingContext(){

            public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String subsystemName) {
                return context.getSubsystemWriter(subsystemName);
            }

            public ModelNode getModelNode() {
                return theModel;
            }
        };
    }
}

