/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SubsystemDescriptionDump
implements OperationStepHandler {
    private final ExtensionRegistry extensionRegistry;
    protected static final SimpleAttributeDefinition PATH = new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).build();
    public static final String OPERATION_NAME = "subsystem-description-dump";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("subsystem-description-dump", (ResourceDescriptionResolver)new NonResolvingResourceDescriptionResolver()).setPrivateEntry().setReadOnly().setParameters(new AttributeDefinition[]{PATH}).build();

    public SubsystemDescriptionDump(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String path = PATH.resolveModelAttribute(context, operation).asString();
        PathAddress profileAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile")});
        ImmutableManagementResourceRegistration profileRegistration = context.getResourceRegistration().getSubModel(profileAddress);
        SubsystemDescriptionDump.dumpManagementResourceRegistration(profileRegistration, this.extensionRegistry, path);
    }

    public static void dumpManagementResourceRegistration(ImmutableManagementResourceRegistration profileRegistration, ExtensionRegistry registry, String path) throws OperationFailedException {
        try {
            for (PathElement pe : profileRegistration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                ImmutableManagementResourceRegistration registration = profileRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
                String subsystem = pe.getValue();
                SubsystemInformation info = registry.getSubsystemInfo(subsystem);
                ModelNode desc = SubsystemDescriptionDump.readFullModelDescription(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}), registration);
                String name = subsystem + "-" + info.getManagementInterfaceMajorVersion() + "." + info.getManagementInterfaceMinorVersion() + "." + info.getManagementInterfaceMicroVersion() + ".dmr";
                PrintWriter pw = new PrintWriter(Files.newBufferedWriter(Paths.get(path, name), StandardCharsets.UTF_8, new OpenOption[0]));
                desc.writeString(pw, false);
                pw.close();
            }
        }
        catch (IOException e) {
            throw new OperationFailedException("could not save,", (Throwable)e);
        }
    }

    public static ModelNode readFullModelDescription(PathAddress address, ImmutableManagementResourceRegistration reg) {
        ModelNode node = new ModelNode();
        node.get("model-description").set(reg.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(Locale.getDefault()));
        node.get("address").set(address.toModelNode());
        for (PathElement pe : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ModelNode children = node.get("children");
            ImmutableManagementResourceRegistration sub = reg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
            children.add(SubsystemDescriptionDump.readFullModelDescription(address.append(new PathElement[]{pe}), sub));
        }
        return node;
    }
}

