/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.LegacyResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesInternal;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.junit.Assert;

class TransformationUtils {
    private TransformationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModelNode getSubsystemDefinitionForVersion(Class<?> classForDmrPackage, String subsystemName, ModelVersion version) {
        block16: {
            ModelNode modelNode;
            StringBuilder key = new StringBuilder(subsystemName).append("-").append(version.getMajor()).append(".").append(version.getMinor());
            key.append('.').append(version.getMicro()).append(".dmr");
            InputStream is = null;
            try {
                is = classForDmrPackage.getResourceAsStream(key.toString());
                if (is == null) {
                    ModelNode modelNode2 = null;
                    return modelNode2;
                }
                modelNode = ModelNode.fromStream((InputStream)is);
            }
            catch (IOException e) {
                ControllerLogger.ROOT_LOGGER.cannotReadTargetDefinition((Throwable)e);
                break block16;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return modelNode;
        }
        return null;
    }

    private static ResourceDefinition loadSubsystemDefinitionFromFile(Class<?> classForDmrPackage, String subsystemName, ModelVersion version) {
        ModelNode desc = TransformationUtils.getSubsystemDefinitionForVersion(classForDmrPackage, subsystemName, version);
        if (desc == null) {
            return null;
        }
        return new LegacyResourceDefinition(desc);
    }

    private static Resource modelToResource(PathAddress startAddress, ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined) {
        return TransformationUtils.modelToResource(startAddress, reg, model, includeUndefined, PathAddress.EMPTY_ADDRESS);
    }

    private static Resource modelToResource(PathAddress startAddress, ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined, PathAddress fullPath) {
        Resource res = Resource.Factory.create();
        ModelNode value = new ModelNode();
        HashSet allFields = new HashSet(model.keys());
        for (String name : reg.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeAccess aa = reg.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
            if (aa.getStorageType() == AttributeAccess.Storage.RUNTIME) {
                allFields.remove(name);
                continue;
            }
            if (includeUndefined) {
                value.get(name).set(model.get(name));
            } else if (model.hasDefined(name)) {
                value.get(name).set(model.get(name));
            }
            allFields.remove(name);
        }
        for (String childType : reg.getChildNames(PathAddress.EMPTY_ADDRESS)) {
            if (model.hasDefined(childType)) {
                for (Property property : model.get(childType).asPropertyList()) {
                    PathElement childPath = PathElement.pathElement((String)childType, (String)property.getName());
                    ImmutableManagementResourceRegistration subRegistration = reg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{childPath}));
                    Resource child = TransformationUtils.modelToResource(startAddress, subRegistration, property.getValue(), includeUndefined, fullPath.append(new PathElement[]{childPath}));
                    res.registerChild(childPath, child);
                }
            }
            allFields.remove(childType);
        }
        if (!value.isDefined() && model.isDefined() && (reg.getChildAddresses(PathAddress.EMPTY_ADDRESS).isEmpty() || res.getChildTypes().isEmpty())) {
            value.setEmptyObject();
        }
        res.writeModel(value);
        if (!allFields.isEmpty()) {
            throw ControllerLogger.ROOT_LOGGER.modelFieldsNotKnown(allFields, startAddress.append(fullPath));
        }
        return res;
    }

    static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined) {
        return TransformationUtils.modelToResource(PathAddress.EMPTY_ADDRESS, reg, model, includeUndefined);
    }

    private static void generateLegacySubsystemResourceRegistrationDmr(KernelServices kernelServices, ModelVersion modelVersion, String mainSubsystemName, Path dmrFile) throws IOException {
        KernelServices legacy = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)mainSubsystemName)});
        ModelNode desc = ((KernelServicesInternal)((Object)legacy)).readFullModelDescription(pathAddress.toModelNode());
        try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(dmrFile, StandardCharsets.UTF_8, new OpenOption[0]));){
            desc.writeString(pw, false);
        }
    }

    static ResourceDefinition getResourceDefinition(KernelServices kernelServices, ModelVersion modelVersion, String mainSubsystemName) throws IOException {
        ResourceDefinition rd = TransformationUtils.loadSubsystemDefinitionFromFile(TransformationUtils.class.getClass(), mainSubsystemName, modelVersion);
        if (rd == null) {
            File file = TransformationUtils.getDmrFile(kernelServices, modelVersion, mainSubsystemName);
            if (!file.exists()) {
                TransformationUtils.generateLegacySubsystemResourceRegistrationDmr(kernelServices, modelVersion, mainSubsystemName, file.toPath());
            }
            rd = TransformationUtils.loadSubsystemDefinitionFromFile(kernelServices.getTestClass(), mainSubsystemName, modelVersion);
        }
        return rd;
    }

    private static File getDmrFile(KernelServices kernelServices, ModelVersion modelVersion, String mainSubsystemName) {
        File file = TransformationUtils.determineTestClassesDirectory();
        for (String part : kernelServices.getTestClass().getPackage().getName().split("\\.")) {
            if ((file = new File(file, part)).exists()) continue;
            file.mkdir();
        }
        return new File(file, mainSubsystemName + "-" + modelVersion.getMajor() + "." + modelVersion.getMinor() + "." + modelVersion.getMicro() + ".dmr");
    }

    private static File determineTestClassesDirectory() {
        File file = new File("target/test-classes").getAbsoluteFile();
        if (!file.exists()) {
            StackTraceElement[] elements;
            File stackTraceFile = null;
            for (StackTraceElement element : elements = new Exception().getStackTrace()) {
                if (element.getClassName().startsWith("org.jboss.as.subsystem.test.")) continue;
                try {
                    Class<?> clazz = TransformationUtils.class.getClassLoader().loadClass(element.getClassName());
                    stackTraceFile = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assert.assertNotNull((String)"Could not determine test-classes directory", stackTraceFile);
            file = stackTraceFile.getAbsoluteFile();
        }
        Assert.assertTrue((String)("Could not determine test-classes directory" + file), (boolean)file.exists());
        return file;
    }
}

