/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.core.model.test.ModelInitializer;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.core.model.test.TestVaultReader;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.resources.DomainRootDefinition;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostPathManagerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationEntry;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.operations.LocalDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.ServerPathManagerService;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.controller.resources.VersionModelInitializer;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class TestModelControllerService
extends ModelTestModelControllerService {
    private final InjectedValue<ContentRepository> injectedContentRepository = new InjectedValue();
    private final TestModelType type;
    private final RunningModeControl runningModeControl;
    private final PathManagerService pathManagerService;
    private final ModelInitializer modelInitializer;
    private final TestDelegatingResourceDefinition rootResourceDefinition;
    private final ControlledProcessState processState;
    private final ExtensionRegistry extensionRegistry;
    private final AbstractVaultReader vaultReader;
    private volatile Initializer initializer;

    TestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, TestModelType type, ModelInitializer modelInitializer, TestDelegatingResourceDefinition rootResourceDefinition, ControlledProcessState processState, ExtensionRegistry extensionRegistry, AbstractVaultReader vaultReader) {
        super(processType, runningModeControl, null, persister, validateOpsFilter, (ModelTestModelControllerService.DelegatingResourceDefinition)rootResourceDefinition, processState, (ExpressionResolver)new RuntimeExpressionResolver((VaultReader)vaultReader), ModelTestModelControllerService.Controller80x.INSTANCE);
        this.type = type;
        this.runningModeControl = runningModeControl;
        this.pathManagerService = type == TestModelType.STANDALONE ? new ServerPathManagerService() : new HostPathManagerService();
        this.modelInitializer = modelInitializer;
        this.rootResourceDefinition = rootResourceDefinition;
        this.processState = processState;
        this.extensionRegistry = extensionRegistry;
        this.vaultReader = vaultReader;
        if (type == TestModelType.STANDALONE) {
            this.initializer = new ServerInitializer();
        } else if (type == TestModelType.HOST) {
            TestModelControllerService.addWriteLocalDomainControllerBootOpIfNeeded(persister);
            this.initializer = new HostInitializer();
        } else if (type == TestModelType.DOMAIN) {
            this.initializer = new DomainInitializer();
        }
    }

    static TestModelControllerService create(ProcessType processType, RunningModeControl runningModeControl, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, TestModelType type, ModelInitializer modelInitializer, ExtensionRegistry extensionRegistry) {
        return new TestModelControllerService(processType, runningModeControl, persister, validateOpsFilter, type, modelInitializer, new TestDelegatingResourceDefinition(type), new ControlledProcessState(true), extensionRegistry, new TestVaultReader());
    }

    InjectedValue<ContentRepository> getContentRepositoryInjector() {
        return this.injectedContentRepository;
    }

    public void start(StartContext context) throws StartException {
        if (this.initializer != null) {
            this.initializer.setRootResourceDefinitionDelegate();
        }
        super.start(context);
    }

    protected void initCoreModel(Resource rootResource, ManagementResourceRegistration rootRegistration, Resource modelControllerResource) {
        System.setProperty("jboss.as.test.disable.runtime", "1");
        if (this.type == TestModelType.STANDALONE) {
            this.initializer.initCoreModel(rootResource, rootRegistration, modelControllerResource);
        } else if (this.type == TestModelType.HOST) {
            this.initializer.initCoreModel(rootResource, rootRegistration, modelControllerResource);
        } else if (this.type == TestModelType.DOMAIN) {
            this.initializer.initCoreModel(rootResource, rootRegistration, modelControllerResource);
        }
        if (this.modelInitializer != null) {
            this.modelInitializer.populateModel(rootResource);
        }
    }

    public void stop(StopContext context) {
        super.stop(context);
        System.clearProperty("jboss.as.test.disable.runtime");
    }

    private ServerEnvironment createStandaloneServerEnvironment() {
        Properties props = new Properties();
        File home = new File("target/jbossas");
        this.delete(home);
        home.mkdir();
        this.delay(10);
        props.put("jboss.home.dir", home.getAbsolutePath());
        File standalone = new File(home, "standalone");
        standalone.mkdir();
        props.put("jboss.server.base.dir", standalone.getAbsolutePath());
        File configuration = new File(standalone, "configuration");
        configuration.mkdir();
        props.put("jboss.server.config.dir", configuration.getAbsolutePath());
        File xml = new File(configuration, "standalone.xml");
        try {
            xml.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        props.put("jboss.server.default.config", "standalone.xml");
        return new ServerEnvironment(null, props, new HashMap(), "standalone.xml", null, ServerEnvironment.LaunchType.STANDALONE, this.runningModeControl.getRunningMode(), null);
    }

    private HostControllerEnvironment createHostControllerEnvironment() {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            File home = new File("target/jbossas");
            this.delete(home);
            home.mkdir();
            int sleep = 10;
            this.delay(sleep);
            props.put("jboss.home.dir", home.getAbsolutePath());
            File domain = new File(home, "domain");
            domain.mkdir();
            this.delay(sleep);
            props.put("jboss.domain.base.dir", domain.getAbsolutePath());
            File configuration = new File(domain, "configuration");
            configuration.mkdir();
            this.delay(sleep);
            props.put("jboss.domain.config.dir", configuration.getAbsolutePath());
            boolean isRestart = false;
            String modulePath = "";
            InetAddress processControllerAddress = InetAddress.getLocalHost();
            Integer processControllerPort = 9999;
            InetAddress hostControllerAddress = InetAddress.getLocalHost();
            Integer hostControllerPort = 1234;
            String defaultJVM = null;
            String domainConfig = null;
            String initialDomainConfig = null;
            String hostConfig = null;
            String initialHostConfig = null;
            RunningMode initialRunningMode = this.runningModeControl.getRunningMode();
            boolean backupDomainFiles = false;
            boolean useCachedDc = false;
            ProductConfig productConfig = new ProductConfig(null, "", props);
            return new HostControllerEnvironment(props, isRestart, modulePath, processControllerAddress, processControllerPort, hostControllerAddress, hostControllerPort, defaultJVM, domainConfig, initialDomainConfig, hostConfig, initialHostConfig, initialRunningMode, backupDomainFiles, useCachedDc, productConfig);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private void delay(int sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addWriteLocalDomainControllerBootOpIfNeeded(StringConfigurationPersister persister) {
        boolean missingDomainController = true;
        for (ModelNode op : persister.getBootOperations()) {
            String opName = op.get("operation").asString();
            if (opName.equals("write-local-domain-controller")) {
                missingDomainController = false;
                break;
            }
            if (!opName.equals("write-remote-domain-controller")) continue;
            missingDomainController = false;
            break;
        }
        if (persister.getBootOperations().size() == 0) {
            return;
        }
        ModelNode registerHostModel = (ModelNode)persister.getBootOperations().get(0);
        if (!registerHostModel.require("operation").asString().equals("register-host-model")) {
            return;
        }
        PathAddress hostAddr = PathAddress.pathAddress((String)"host", (String)registerHostModel.get("name").asString());
        if (missingDomainController) {
            ModelNode local = new ModelNode();
            local.get("local").setEmptyObject();
            ModelNode writeLocalDomainController = Util.createOperation((OperationDefinition)LocalDomainControllerAddHandler.DEFINITION, (PathAddress)hostAddr);
            persister.getBootOperations().add(1, writeLocalDomainController);
        }
        persister.getBootOperations().add(1, Util.createEmptyOperation((String)"add-missing-namespaces-attribute-for-validation-handler", (PathAddress)hostAddr));
        persister.getBootOperations().add(1, Util.createEmptyOperation((String)"add-missing-schema-locations-attribute-for-validation-handler", (PathAddress)hostAddr));
    }

    private LocalHostControllerInfoImpl createLocalHostControllerInfo(HostControllerEnvironment env) {
        return new LocalHostControllerInfoImpl(null, env);
    }

    private HostFileRepository createHostFileRepository() {
        return new HostFileRepository(){

            public File getDeploymentRoot(ContentReference reference) {
                return null;
            }

            public File[] getDeploymentFiles(ContentReference reference) {
                return null;
            }

            public void deleteDeployment(ContentReference reference) {
            }

            public File getFile(String relativePath) {
                return null;
            }

            public File getConfigurationFile(String relativePath) {
                return null;
            }
        };
    }

    private DomainController createDomainController(HostControllerEnvironment env, final LocalHostControllerInfoImpl info) {
        return new DomainController(){

            public void unregisterRunningServer(String serverName) {
            }

            public void unregisterRemoteHost(String id, Long remoteConnectionId, boolean cleanShutdown) {
            }

            public void stopLocalHost(int exitCode) {
            }

            public void stopLocalHost() {
            }

            public void registerRunningServer(ProxyController serverControllerClient) {
            }

            public void registerRemoteHost(String hostName, ManagementChannelHandler handler, Transformers transformers, Long remoteConnectionId, DomainControllerRuntimeIgnoreTransformationEntry runtimeIgnoreTransformation, boolean registerProxyController) throws SlaveRegistrationException {
            }

            public void pingRemoteHost(String hostName) {
            }

            public boolean isHostRegistered(String id) {
                return false;
            }

            public HostFileRepository getRemoteFileRepository() {
                return null;
            }

            public ModelNode getProfileOperations(String profileName) {
                return null;
            }

            public LocalHostControllerInfo getLocalHostInfo() {
                return info;
            }

            public HostFileRepository getLocalFileRepository() {
                return null;
            }

            public ExtensionRegistry getExtensionRegistry() {
                return null;
            }

            public RunningMode getCurrentRunningMode() {
                return null;
            }

            public ExpressionResolver getExpressionResolver() {
                return null;
            }

            public void initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
            }

            public void initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
            }
        };
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    static /* synthetic */ ServerEnvironment access$300(TestModelControllerService x0) {
        return x0.createStandaloneServerEnvironment();
    }

    static /* synthetic */ DomainController access$1800(TestModelControllerService x0, HostControllerEnvironment x1, LocalHostControllerInfoImpl x2) {
        return x0.createDomainController(x1, x2);
    }

    private static class AddMissingHostNamespacesAttributeForValidationHandler
    implements OperationStepHandler {
        static final OperationStepHandler INSTANCE = new AddMissingHostNamespacesAttributeForValidationHandler();
        static final String NAME = "add-missing-namespaces-attribute-for-validation-handler";
        static final OperationDefinition DEF = new SimpleOperationDefinitionBuilder("add-missing-namespaces-attribute-for-validation-handler", (ResourceDescriptionResolver)new NonResolvingResourceDescriptionResolver()).build();

        private AddMissingHostNamespacesAttributeForValidationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("namespaces").setEmptyList();
        }
    }

    private static class AddMissingHostSchemaLocationsAttributeForValidationHandler
    implements OperationStepHandler {
        static final OperationStepHandler INSTANCE = new AddMissingHostSchemaLocationsAttributeForValidationHandler();
        static final String NAME = "add-missing-schema-locations-attribute-for-validation-handler";
        static final OperationDefinition DEF = new SimpleOperationDefinitionBuilder("add-missing-schema-locations-attribute-for-validation-handler", (ResourceDescriptionResolver)new NonResolvingResourceDescriptionResolver()).build();

        private AddMissingHostSchemaLocationsAttributeForValidationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("schema-locations").setEmptyList();
        }
    }

    private static class MockDomainController
    implements DomainController {
        private MockDomainController() {
        }

        public RunningMode getCurrentRunningMode() {
            return null;
        }

        public LocalHostControllerInfo getLocalHostInfo() {
            return null;
        }

        public void registerRemoteHost(String hostName, ManagementChannelHandler handler, Transformers transformers, Long remoteConnectionId, DomainControllerRuntimeIgnoreTransformationEntry runtimeIgnoreTransformation, boolean registerProxyController) throws SlaveRegistrationException {
        }

        public boolean isHostRegistered(String id) {
            return false;
        }

        public void unregisterRemoteHost(String id, Long remoteConnectionId, boolean cleanShutdown) {
        }

        public void pingRemoteHost(String hostName) {
        }

        public void registerRunningServer(ProxyController serverControllerClient) {
        }

        public void unregisterRunningServer(String serverName) {
        }

        public ModelNode getProfileOperations(String profileName) {
            return null;
        }

        public HostFileRepository getLocalFileRepository() {
            return null;
        }

        public HostFileRepository getRemoteFileRepository() {
            return null;
        }

        public void stopLocalHost() {
        }

        public void stopLocalHost(int exitCode) {
        }

        public ExtensionRegistry getExtensionRegistry() {
            return null;
        }

        public ExpressionResolver getExpressionResolver() {
            return null;
        }

        public void initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        }

        public void initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        }
    }

    private static class TestDelegatingResourceDefinition
    extends ModelTestModelControllerService.DelegatingResourceDefinition {
        private final TestModelType type;

        public TestDelegatingResourceDefinition(TestModelType type) {
            this.type = type;
        }

        public void setDelegate(ResourceDefinition delegate) {
            super.setDelegate(delegate);
        }

        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
            if (this.type == TestModelType.DOMAIN) {
                return;
            }
            super.registerOperations(resourceRegistration);
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            if (this.type == TestModelType.DOMAIN) {
                return;
            }
            super.registerChildren(resourceRegistration);
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            if (this.type == TestModelType.DOMAIN) {
                return;
            }
            super.registerAttributes(resourceRegistration);
        }

        public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
            if (this.type == TestModelType.DOMAIN) {
                return;
            }
            super.registerNotifications(resourceRegistration);
        }

        public boolean isRuntime() {
            return false;
        }
    }

    private class DomainInitializer
    implements Initializer {
        private DomainInitializer() {
        }

        @Override
        public void setRootResourceDefinitionDelegate() {
        }

        @Override
        public void initCoreModel(Resource rootResource, ManagementResourceRegistration rootRegistration, Resource modelControllerResource) {
            VersionModelInitializer.registerRootResource((Resource)rootResource, null);
            HostControllerEnvironment env = TestModelControllerService.this.createHostControllerEnvironment();
            LocalHostControllerInfoImpl info = TestModelControllerService.this.createLocalHostControllerInfo(env);
            IgnoredDomainResourceRegistry ignoredRegistry = new IgnoredDomainResourceRegistry((LocalHostControllerInfo)info);
            NullConfigurationPersister persister = new NullConfigurationPersister();
            HostFileRepository hostFileRepository = TestModelControllerService.this.createHostFileRepository();
            MockDomainController domainController = new MockDomainController();
            DomainRootDefinition domainDefinition = null;
            Constructor<?>[] constructors = DomainRootDefinition.class.getConstructors();
            if (constructors.length == 1 && constructors[0].getParameterTypes().length == 10) {
                try {
                    domainDefinition = (DomainRootDefinition)constructors[0].newInstance(domainController, env, persister, TestModelControllerService.this.injectedContentRepository.getValue(), hostFileRepository, true, info, TestModelControllerService.this.extensionRegistry, null, TestModelControllerService.this.pathManagerService);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                domainDefinition = new DomainRootDefinition((DomainController)domainController, env, (ExtensibleConfigurationPersister)persister, (ContentRepository)TestModelControllerService.this.injectedContentRepository.getValue(), hostFileRepository, true, (LocalHostControllerInfo)info, TestModelControllerService.this.extensionRegistry, null, TestModelControllerService.this.pathManagerService, null, TestModelControllerService.this.authorizer, null, TestModelControllerService.this.getMutableRootResourceRegistrationProvider());
            }
            domainDefinition.initialize(rootRegistration);
            TestModelControllerService.this.rootResourceDefinition.setDelegate((ResourceDefinition)domainDefinition);
            HostModelUtil.createRootRegistry((ManagementResourceRegistration)rootRegistration, (HostControllerEnvironment)env, (IgnoredDomainResourceRegistry)ignoredRegistry, (HostModelUtil.HostModelRegistrar)new HostModelUtil.HostModelRegistrar(){

                public void registerHostModel(String hostName, ManagementResourceRegistration root) {
                }
            }, (ProcessType)TestModelControllerService.this.processType, (DelegatingConfigurableAuthorizer)TestModelControllerService.this.authorizer, (Resource)modelControllerResource);
            CoreManagementResourceDefinition.registerDomainResource((Resource)rootResource, null);
        }
    }

    private class HostInitializer
    implements Initializer {
        final String hostName = "master";
        final HostControllerEnvironment env = TestModelControllerService.access$1500(TestModelControllerService.this);
        final LocalHostControllerInfoImpl info = TestModelControllerService.access$1600(TestModelControllerService.this, this.env);
        final IgnoredDomainResourceRegistry ignoredRegistry = new IgnoredDomainResourceRegistry((LocalHostControllerInfo)this.info);
        final ExtensionRegistry hostExtensionRegistry = TestModelControllerService.access$800(TestModelControllerService.this);
        final HostControllerConfigurationPersister persister = new HostControllerConfigurationPersister(this.env, (LocalHostControllerInfo)this.info, Executors.newCachedThreadPool(), this.hostExtensionRegistry, TestModelControllerService.access$800(TestModelControllerService.this));
        final HostFileRepository hostFileRepository = TestModelControllerService.access$1700(TestModelControllerService.this);
        final DomainController domainController = TestModelControllerService.access$1800(TestModelControllerService.this, this.env, this.info);

        private HostInitializer() {
        }

        @Override
        public void setRootResourceDefinitionDelegate() {
            TestModelControllerService.this.rootResourceDefinition.setDelegate((ResourceDefinition)new HostResourceDefinition("master", this.persister, this.env, (HostRunningModeControl)TestModelControllerService.this.runningModeControl, this.hostFileRepository, this.info, null, null, (ContentRepository)TestModelControllerService.this.injectedContentRepository.getValue(), this.domainController, TestModelControllerService.this.extensionRegistry, TestModelControllerService.this.vaultReader, this.ignoredRegistry, TestModelControllerService.this.processState, TestModelControllerService.this.pathManagerService, TestModelControllerService.this.authorizer, AuditLogger.NO_OP_LOGGER, TestModelControllerService.this.getBootErrorCollector()));
        }

        @Override
        public void initCoreModel(Resource rootResource, ManagementResourceRegistration rootRegistration, Resource modelControllerResource) {
            HostModelUtil.createRootRegistry((ManagementResourceRegistration)rootRegistration, (HostControllerEnvironment)this.env, (IgnoredDomainResourceRegistry)this.ignoredRegistry, (HostModelUtil.HostModelRegistrar)new HostModelUtil.HostModelRegistrar(){

                public void registerHostModel(String hostName, ManagementResourceRegistration rootRegistration) {
                }
            }, (ProcessType)ProcessType.HOST_CONTROLLER, (DelegatingConfigurableAuthorizer)TestModelControllerService.this.authorizer, (Resource)modelControllerResource);
            ManagementResourceRegistration hostReg = HostModelUtil.createHostRegistry((String)"master", (ManagementResourceRegistration)rootRegistration, (HostControllerConfigurationPersister)this.persister, (HostControllerEnvironment)this.env, (HostRunningModeControl)((HostRunningModeControl)TestModelControllerService.this.runningModeControl), (HostFileRepository)this.hostFileRepository, (LocalHostControllerInfoImpl)this.info, null, null, (ContentRepository)((ContentRepository)TestModelControllerService.this.injectedContentRepository.getValue()), (DomainController)this.domainController, (ExtensionRegistry)TestModelControllerService.this.extensionRegistry, (ExtensionRegistry)TestModelControllerService.this.extensionRegistry, null, (IgnoredDomainResourceRegistry)this.ignoredRegistry, (ControlledProcessState)TestModelControllerService.this.processState, (PathManagerService)TestModelControllerService.this.pathManagerService, (DelegatingConfigurableAuthorizer)TestModelControllerService.this.authorizer, (ManagedAuditLogger)AuditLogger.NO_OP_LOGGER, (BootErrorCollector)TestModelControllerService.this.getBootErrorCollector());
            hostReg.unregisterOperationHandler("write-local-domain-controller");
            hostReg.registerOperationHandler(LocalDomainControllerAddHandler.DEFINITION, (OperationStepHandler)LocalDomainControllerAddHandler.getTestInstance());
            hostReg.registerOperationHandler(AddMissingHostNamespacesAttributeForValidationHandler.DEF, AddMissingHostNamespacesAttributeForValidationHandler.INSTANCE);
            hostReg.registerOperationHandler(AddMissingHostSchemaLocationsAttributeForValidationHandler.DEF, AddMissingHostSchemaLocationsAttributeForValidationHandler.INSTANCE);
        }
    }

    private class ServerInitializer
    implements Initializer {
        final ExtensibleConfigurationPersister persister = new NullConfigurationPersister();
        final ServerEnvironment environment = TestModelControllerService.access$300(TestModelControllerService.this);
        final boolean parallelBoot = false;

        private ServerInitializer() {
        }

        @Override
        public void setRootResourceDefinitionDelegate() {
            TestModelControllerService.this.rootResourceDefinition.setDelegate((ResourceDefinition)new ServerRootResourceDefinition((ContentRepository)TestModelControllerService.this.injectedContentRepository.getValue(), this.persister, this.environment, TestModelControllerService.this.processState, TestModelControllerService.this.runningModeControl, TestModelControllerService.this.vaultReader, TestModelControllerService.this.extensionRegistry, false, TestModelControllerService.this.pathManagerService, null, TestModelControllerService.this.authorizer, AuditLogger.NO_OP_LOGGER, TestModelControllerService.this.getMutableRootResourceRegistrationProvider(), TestModelControllerService.this.getBootErrorCollector()));
        }

        @Override
        public void initCoreModel(Resource rootResource, ManagementResourceRegistration rootRegistration, Resource modelControllerResource) {
            VersionModelInitializer.registerRootResource((Resource)rootResource, null);
            Resource managementResource = Resource.Factory.create();
            rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"management"), managementResource);
            rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"service-container"), Resource.Factory.create());
            managementResource.registerChild(PathElement.pathElement((String)"access", (String)"authorization"), AccessAuthorizationResourceDefinition.createResource((AccessConstraintUtilizationRegistry)TestModelControllerService.this.authorizer.getWritableAuthorizerConfiguration()));
            rootResource.registerChild(ServerEnvironmentResourceDescription.RESOURCE_PATH, Resource.Factory.create());
            TestModelControllerService.this.pathManagerService.addPathManagerResources(rootResource);
        }
    }

    private static interface Initializer {
        public void setRootResourceDefinitionDelegate();

        public void initCoreModel(Resource var1, ManagementResourceRegistration var2, Resource var3);
    }
}

