/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;

public class TestVaultReader
extends AbstractVaultReader {
    private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");
    private volatile String fqn;
    private final Map<String, Object> options = new HashMap<String, Object>();

    protected void createVault(String fqn, Map<String, Object> options) throws VaultReaderException {
        assert (this.fqn == null) : "vault already initialized";
        String string = this.fqn = fqn == null ? "default" : fqn;
        if (options != null) {
            this.options.putAll(options);
        }
    }

    protected void createVault(String fqn, String module, Map<String, Object> options) throws VaultReaderException {
        this.createVault(fqn, options);
    }

    protected void destroyVault() {
        this.fqn = null;
        this.options.clear();
    }

    public boolean isVaultFormat(String encrypted) {
        return encrypted != null && VAULT_PATTERN.matcher(encrypted).matches();
    }

    public String retrieveFromVault(String encrypted) {
        if (this.isVaultFormat(encrypted)) {
            if (this.fqn == null) {
                throw new SecurityException("Vault not initialized");
            }
            String[] split = encrypted.split("::");
            if (split[1].equals(this.fqn)) {
                Object value = this.options.get(split[2]);
                if (value == null) {
                    value = split[3];
                }
                return value.toString();
            }
            throw new SecurityException("Unknown vault " + split[1]);
        }
        return encrypted;
    }
}

