/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.core.model.test.AbstractCoreModelTest;
import org.jboss.as.core.model.test.ClassloaderParameter;
import org.jboss.as.core.model.test.CoreModelTestDelegate;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class TransformersTestParameterized
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();

    public TransformersTestParameterized(Class<?> klass) throws Throwable {
        super(klass, NO_RUNNERS);
        TransformersParameter parameters = (TransformersParameter)this.getParametersMethod().getAnnotation(TransformersParameter.class);
        this.createRunnersForParameters(this.allParameters(), parameters.name());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Iterable<ClassloaderParameter> allParameters() throws Throwable {
        Object parameters = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(TransformersParameter.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private void createRunnersForParameters(Iterable<ClassloaderParameter> allParameters, String namePattern) throws Exception {
        try {
            int i = 0;
            for (ClassloaderParameter parametersOfSingleTest : allParameters) {
                String name = this.nameFor(namePattern, i, parametersOfSingleTest);
                TestClassRunnerForParameters runner = new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
                this.runners.add((Runner)runner);
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private String nameFor(String namePattern, int index, ClassloaderParameter parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final ClassloaderParameter fParameters;
        private final String fName;

        TestClassRunnerForParameters(Class<?> type, ClassloaderParameter parameters, String name) throws InitializationError {
            super(type);
            this.fParameters = parameters;
            this.fName = name;
        }

        public Object createTest() throws Exception {
            Object o = this.createTestUsingConstructorInjection();
            if (o instanceof AbstractCoreModelTest) {
                CoreModelTestDelegate delegate = ((AbstractCoreModelTest)o).getDelegate();
                delegate.setCurrentTransformerClassloaderParameter(this.fParameters);
            }
            return o;
        }

        private Object createTestUsingConstructorInjection() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TransformersParameter {
        public String name() default "{index}";
    }
}

