/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.HashMap;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;

class ReadTransformedResourceOperation
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-transformed-resource", null).setPrivateEntry().build();
    private final TransformerRegistry transformerRegistry;
    private final ModelVersion coreModelVersion;
    private final ModelVersion subsystemModelVersion;

    ReadTransformedResourceOperation(TransformerRegistry transformerRegistry, ModelVersion coreModelVersion, ModelVersion subsystemModelVersion) {
        this.transformerRegistry = transformerRegistry;
        this.coreModelVersion = coreModelVersion;
        this.subsystemModelVersion = subsystemModelVersion;
    }

    private ModelNode transformReadResourceResult(OperationContext context, ModelNode original, String subsystem) throws OperationFailedException {
        ModelNode rootData = original.get("result");
        HashMap<PathAddress, ModelVersion> subsystemVersions = new HashMap<PathAddress, ModelVersion>();
        subsystemVersions.put(PathAddress.EMPTY_ADDRESS.append("subsystem", subsystem), this.subsystemModelVersion);
        TransformationTargetImpl target = TransformationTargetImpl.create((TransformerRegistry)this.transformerRegistry, (ModelVersion)this.coreModelVersion, subsystemVersions, null, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER, null);
        Transformers transformers = Transformers.Factory.create((TransformationTarget)target);
        ImmutableManagementResourceRegistration rr = context.getRootResourceRegistration();
        Resource root = TransformerRegistry.modelToResource((ImmutableManagementResourceRegistration)rr, (ModelNode)rootData, (boolean)true);
        Resource transformed = transformers.transformRootResource(context, root);
        return Resource.Tools.readModel((Resource)transformed);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String subsystem = operation.get("subsystem").asString();
        boolean includeDefaults = operation.get("include-defaults").asBoolean(true);
        final ModelNode readResourceResult = new ModelNode();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode transformed = ReadTransformedResourceOperation.this.transformReadResourceResult(context, readResourceResult, subsystem);
                context.getResult().set(transformed);
            }
        }, OperationContext.Stage.MODEL, true);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        op.get("include-defaults").set(includeDefaults);
        context.addStep(readResourceResult, op, ReadResourceHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }
}

