/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.metadata.property.PropertiesPropertyResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.SimpleExpressionResolver;
import org.jboss.util.xml.JBossEntityResolver;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    private static ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Assert.fail((String)("warning: " + exception.getMessage()));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Assert.fail((String)("error: " + exception.getMessage()));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Assert.fail((String)("fatal error: " + exception.getMessage()));
        }
    };

    static void validateXML(String xmlContent, String elementRoot, String xsdPath, Properties resolvedProperties) throws Exception {
        InputSource inputSource = new InputSource(new StringReader(xmlContent));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
        NodeList nodes = document.getElementsByTagName(elementRoot);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            SchemaValidator.validateXML(writer.toString(), xsdPath, resolvedProperties);
        }
    }

    static void validateXML(String xmlContent, String xsdPath, Properties resolvedProperties) throws Exception {
        String resolvedXml = SchemaValidator.resolveAllExpressions(xmlContent, resolvedProperties);
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsdPath);
        StreamSource source = new StreamSource(stream);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(ERROR_HANDLER);
        schemaFactory.setResourceResolver((LSResourceResolver)new JBossEntityResolver());
        Schema schema = schemaFactory.newSchema(source);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(ERROR_HANDLER);
        validator.setFeature("http://apache.org/xml/features/validation/schema", true);
        validator.validate(new StreamSource(new StringReader(resolvedXml)));
    }

    private static String resolveAllExpressions(String xmlContent, Properties resolvedProperties) throws IOException {
        PropertyReplacer replacer = PropertyReplacers.resolvingExpressionReplacer((SimpleExpressionResolver)new PropertiesPropertyResolver(resolvedProperties));
        StringBuilder out = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(xmlContent));){
            String line;
            while ((line = reader.readLine()) != null) {
                out.append(replacer.replaceProperties(line));
                out.append('\n');
            }
        }
        return out.toString();
    }
}

