/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.operations.global.GlobalNotifications;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.ServerDeploymentResourceDefinition;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.VirtualFile;

class TestModelControllerService
extends ModelTestModelControllerService
implements ControllerInitializer.TestControllerAccessor {
    private final Extension mainExtension;
    private final AdditionalInitialization additionalInit;
    private final ControllerInitializer controllerInitializer;
    private final ExtensionRegistry extensionRegistry;
    private final RunningModeControl runningModeControl;
    private final ContentRepository contentRepository = new MockContentRepository();
    private final boolean registerTransformers;

    protected TestModelControllerService(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalInit, RunningModeControl runningModeControl, ExtensionRegistry extensionRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, boolean registerTransformers) {
        super(additionalInit.getProcessType(), runningModeControl, extensionRegistry.getTransformerRegistry(), persister, validateOpsFilter, (ResourceDefinition)new SimpleResourceDefinition(null, (ResourceDescriptionResolver)NonResolvingResourceDescriptionResolver.INSTANCE), new ControlledProcessState(true), ModelTestModelControllerService.Controller90x.INSTANCE);
        this.mainExtension = mainExtension;
        this.additionalInit = additionalInit;
        this.controllerInitializer = controllerInitializer;
        this.extensionRegistry = extensionRegistry;
        this.runningModeControl = runningModeControl;
        this.registerTransformers = registerTransformers;
    }

    static TestModelControllerService create(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalInit, ExtensionRegistry extensionRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, boolean registerTransformers) {
        return new TestModelControllerService(mainExtension, controllerInitializer, additionalInit, new RunningModeControl(additionalInit.getRunningMode()), extensionRegistry, persister, validateOpsFilter, registerTransformers);
    }

    protected AbstractControllerService.ModelControllerServiceInitializationParams getModelControllerServiceInitializationParams() {
        if (this.additionalInit.getProcessType().isServer()) {
            ServiceLoader<ModelControllerServiceInitialization> sl = ServiceLoader.load(ModelControllerServiceInitialization.class);
            return new AbstractControllerService.ModelControllerServiceInitializationParams(sl){

                public String getHostName() {
                    return null;
                }
            };
        }
        return null;
    }

    protected void initExtraModel(ManagementModel managementModel) {
        Resource rootResource = managementModel.getRootResource();
        ManagementResourceRegistration rootRegistration = managementModel.getRootResourceRegistration();
        this.initExtraModelInternal(rootResource, rootRegistration);
        this.additionalInit.initializeExtraSubystemsAndModel(this.extensionRegistry, rootResource, rootRegistration, managementModel.getCapabilityRegistry());
    }

    protected void initExtraModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        this.initExtraModelInternal(rootResource, rootRegistration);
        this.additionalInit.initializeExtraSubystemsAndModel(this.extensionRegistry, rootResource, rootRegistration);
    }

    private void initExtraModelInternal(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        rootResource.getModel().get("subsystem");
        rootRegistration.registerSubModel((ResourceDefinition)ServerDeploymentResourceDefinition.create((ContentRepository)this.contentRepository, null));
        GlobalNotifications.registerGlobalNotifications((ManagementResourceRegistration)rootRegistration, (ProcessType)this.processType);
        this.controllerInitializer.setTestModelControllerAccessor(this);
        this.controllerInitializer.initializeModel(rootResource, rootRegistration);
    }

    protected void preBoot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) {
        this.mainExtension.initialize(this.extensionRegistry.getExtensionContext("Test", this.getRootRegistration(), this.registerTransformers ? ExtensionRegistryType.MASTER : ExtensionRegistryType.SLAVE));
    }

    protected void postBoot() {
        DeployerChainAddHandler.INSTANCE.clearDeployerMap();
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    @Override
    public ServerEnvironment getServerEnvironment() {
        Properties props = new Properties();
        File home = new File("target/jbossas");
        this.delete(home);
        home.mkdir();
        props.put("jboss.home.dir", home.getAbsolutePath());
        File standalone = new File(home, "standalone");
        standalone.mkdir();
        props.put("jboss.server.base.dir", standalone.getAbsolutePath());
        File configuration = new File(standalone, "configuration");
        configuration.mkdir();
        props.put("jboss.server.config.dir", configuration.getAbsolutePath());
        File xml = new File(configuration, "standalone.xml");
        try {
            xml.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        props.put("jboss.server.default.config", "standalone.xml");
        return new ServerEnvironment(null, props, new HashMap(), "standalone.xml", null, ServerEnvironment.LaunchType.STANDALONE, this.runningModeControl.getRunningMode(), null);
    }

    private static class MockContentRepository
    implements ContentRepository {
        private MockContentRepository() {
        }

        public byte[] addContent(InputStream stream) throws IOException {
            return null;
        }

        public VirtualFile getContent(byte[] hash) {
            return null;
        }

        public boolean hasContent(byte[] hash) {
            return false;
        }

        public boolean syncContent(ContentReference reference) {
            return false;
        }

        public void removeContent(ContentReference reference) {
        }

        public void addContentReference(ContentReference reference) {
        }

        public Map<String, Set<String>> cleanObsoleteContent() {
            return null;
        }
    }
}

