/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.io.IOException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.core.model.test.CoreModelTestDelegate;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.core.model.test.KernelServicesBuilder;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.dmr.ModelNode;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractCoreModelTest {
    private final CoreModelTestDelegate delegate = new CoreModelTestDelegate(this.getClass());

    protected AbstractCoreModelTest() {
    }

    @Before
    public void initializeParser() throws Exception {
        this.delegate.initializeParser();
    }

    @After
    public void cleanup() throws Exception {
        this.delegate.cleanup();
        this.delegate.setCurrentTransformerClassloaderParameter(null);
    }

    CoreModelTestDelegate getDelegate() {
        return this.delegate;
    }

    protected KernelServicesBuilder createKernelServicesBuilder(TestModelType type) {
        return this.delegate.createKernelServicesBuilder(type);
    }

    protected ModelNode checkCoreModelTransformation(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        return this.checkCoreModelTransformation(kernelServices, modelVersion, new RbacModelFixer(modelVersion), null);
    }

    protected ModelNode checkCoreModelTransformation(KernelServices kernelServices, ModelVersion modelVersion, ModelFixer legacyModelFixer, ModelFixer transformedModelFixer) throws IOException {
        return this.delegate.checkCoreModelTransformation(kernelServices, modelVersion, legacyModelFixer, transformedModelFixer);
    }

    protected static ModelNode checkOutcome(ModelNode result) {
        return ModelTestUtils.checkOutcome((ModelNode)result);
    }

    public static class RbacModelFixer
    implements ModelFixer {
        private final ModelVersion transformFromVersion;

        public RbacModelFixer(ModelVersion transformFromVersion) {
            this.transformFromVersion = transformFromVersion;
        }

        public ModelNode fixModel(ModelNode modelNode) {
            ModelNode result;
            ModelNode modelNode2 = result = this.transformFromVersion.getMajor() < 9 ? this.fixVaultConstraint(this.fixSensitivityConstraint(this.fixApplicationConstraint(modelNode))) : modelNode;
            if (!modelNode.hasDefined(new String[]{"core-service", "management", "access", "authorization", "constraint", "sensitivity-classification", "type", "core", "classification", "credential"})) {
                throw new IllegalArgumentException(modelNode.toString());
            }
            return result;
        }

        private ModelNode fixApplicationConstraint(ModelNode modelNode) {
            if (modelNode.hasDefined(new String[]{"core-service", "management", "access", "authorization", "constraint", "application-classification", "type"})) {
                ModelNode typeNode = modelNode.get(new String[]{"core-service", "management", "access", "authorization", "constraint", "application-classification", "type"});
                for (String type : typeNode.keys()) {
                    if (!typeNode.hasDefined(new String[]{type, "classification"})) continue;
                    ModelNode classificationNode = typeNode.get(new String[]{type, "classification"});
                    for (String classification : classificationNode.keys()) {
                        ModelNode target = classificationNode.get(classification);
                        if (!target.has("default-application")) continue;
                        target.remove("default-application");
                    }
                }
            }
            return modelNode;
        }

        private ModelNode fixSensitivityConstraint(ModelNode modelNode) {
            if (modelNode.hasDefined(new String[]{"core-service", "management", "access", "authorization", "constraint", "sensitivity-classification", "type"})) {
                ModelNode typeNode = modelNode.get(new String[]{"core-service", "management", "access", "authorization", "constraint", "sensitivity-classification", "type"});
                for (String type : typeNode.keys()) {
                    if (!typeNode.hasDefined(new String[]{type, "classification"})) continue;
                    ModelNode classificationNode = typeNode.get(new String[]{type, "classification"});
                    if (!(!"core".equals(type) || classificationNode.hasDefined("credential") && classificationNode.hasDefined("domain-controller"))) {
                        throw new IllegalArgumentException(classificationNode.toString());
                    }
                    for (String classification : classificationNode.keys()) {
                        ModelNode target = classificationNode.get(classification);
                        if (target.has("default-requires-addressable")) {
                            target.remove("default-requires-addressable");
                        }
                        if (target.has("default-requires-read")) {
                            target.remove("default-requires-read");
                        }
                        if (!target.has("default-requires-write")) continue;
                        target.remove("default-requires-write");
                    }
                    if (!"core".equals(type) || classificationNode.hasDefined("credential") && classificationNode.hasDefined("domain-controller")) continue;
                    throw new IllegalArgumentException(classificationNode.toString());
                }
            } else {
                throw new IllegalArgumentException(modelNode.toString());
            }
            return modelNode;
        }

        private ModelNode fixVaultConstraint(ModelNode modelNode) {
            if (modelNode.hasDefined(new String[]{"core-service", "management", "access", "authorization", "constraint", "vault-expression"})) {
                ModelNode target = modelNode.get(new String[]{"core-service", "management", "access", "authorization", "constraint", "vault-expression"});
                if (target.has("default-requires-addressable")) {
                    target.remove("default-requires-addressable");
                }
                if (target.has("default-requires-read")) {
                    target.remove("default-requires-read");
                }
                if (target.has("default-requires-write")) {
                    target.remove("default-requires-write");
                }
            }
            return modelNode;
        }
    }
}

