/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.core.model.bridge.impl.LegacyControllerKernelServicesProxy;
import org.jboss.as.core.model.bridge.local.ScopedKernelServicesBootstrap;
import org.jboss.as.core.model.test.AbstractKernelServicesImpl;
import org.jboss.as.core.model.test.ClassloaderParameter;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.core.model.test.KernelServicesBuilder;
import org.jboss.as.core.model.test.KnownIssuesValidationConfiguration;
import org.jboss.as.core.model.test.LegacyKernelServicesInitializer;
import org.jboss.as.core.model.test.LegacyModelInitializerEntry;
import org.jboss.as.core.model.test.ModelHarmonizer;
import org.jboss.as.core.model.test.ModelInitializer;
import org.jboss.as.core.model.test.ModelWriteSanitizer;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.core.model.test.TestParser;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.model.test.ChildFirstClassLoaderBuilder;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestBootOperationsBuilder;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestModelDescriptionValidator;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.wildfly.common.xml.XMLInputFactoryUtil;
import org.wildfly.legacy.test.spi.Version;

public class CoreModelTestDelegate {
    public static final ModelTestModelDescriptionValidator.AttributeOrParameterArbitraryDescriptorValidator ARBITRARY_DESCRIPTOR_VALIDATOR = (currentType, currentNode, descriptor) -> null;
    private static final Set<PathAddress> EMPTY_RESOURCE_ADDRESSES = new HashSet<PathAddress>();
    private static final Set<PathAddress> MISSING_NAME_ADDRESSES = new HashSet<PathAddress>();
    private final Class<?> testClass;
    private final List<KernelServices> kernelServices = new ArrayList<KernelServices>();
    private volatile ClassloaderParameter currentTransformerClassloaderParameter;

    public CoreModelTestDelegate(Class<?> testClass) {
        this.testClass = testClass;
    }

    void initializeParser() throws Exception {
    }

    void setCurrentTransformerClassloaderParameter(ClassloaderParameter parameter) {
        ClassloaderParameter current = this.currentTransformerClassloaderParameter;
        if (current != null) {
            if (current != parameter) {
                current.setClassLoader(null);
                this.currentTransformerClassloaderParameter = parameter;
            }
        } else {
            this.currentTransformerClassloaderParameter = parameter;
        }
    }

    void cleanup() throws Exception {
        for (KernelServices kernelServices : this.kernelServices) {
            try {
                kernelServices.shutdown();
            }
            catch (Exception exception) {}
        }
        this.kernelServices.clear();
    }

    protected KernelServicesBuilder createKernelServicesBuilder(TestModelType type) {
        return new KernelServicesBuilderImpl(type);
    }

    private void validateDescriptionProviders(TestModelType type, KernelServices kernelServices, Map<ModelNode, Map<String, Set<String>>> attributeDescriptors, Map<ModelNode, Map<String, Map<String, Set<String>>>> operationParameterDescriptors) {
        ModelNode address;
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource-description");
        op.get("address").setEmptyList();
        op.get("recursive").set(true);
        op.get("inherited").set(false);
        op.get("operations").set(true);
        op.get("include-aliases").set(true);
        ModelNode result = kernelServices.executeOperation(op, new InputStream[0]);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        ModelNode model = result.get("result");
        if (type == TestModelType.HOST) {
            model = model.require("children").require("host").require("model-description").require("primary");
        }
        ModelTestModelDescriptionValidator.ValidationConfiguration config = KnownIssuesValidationConfiguration.createAndFixupModel(type, model);
        for (Map.Entry<ModelNode, Map<String, Set<String>>> entry : attributeDescriptors.entrySet()) {
            address = entry.getKey();
            Map<String, Set<String>> descriptors = entry.getValue();
            for (Map.Entry<String, Set<String>> descriptor : descriptors.entrySet()) {
                String attributeName = descriptor.getKey();
                Set<String> arbitraryAttributeDescriptors = descriptor.getValue();
                for (String string : arbitraryAttributeDescriptors) {
                    config.registerAttributeArbitraryDescriptor(address, attributeName, string, ARBITRARY_DESCRIPTOR_VALIDATOR);
                }
            }
        }
        for (Map.Entry<ModelNode, Map<String, Object>> entry : operationParameterDescriptors.entrySet()) {
            address = entry.getKey();
            Map<String, Object> operationDescriptors = entry.getValue();
            for (Map.Entry<String, Object> operationDescriptor : operationDescriptors.entrySet()) {
                String operationName = operationDescriptor.getKey();
                Map parameterDescriptors = (Map)operationDescriptor.getValue();
                for (Map.Entry entry2 : parameterDescriptors.entrySet()) {
                    String parameter = (String)entry2.getKey();
                    Set arbitraryAttributeDescriptors = (Set)entry2.getValue();
                    for (String arbitraryAttributeDescriptor : arbitraryAttributeDescriptors) {
                        config.registerArbitraryDescriptorForOperationParameter(address, operationName, parameter, arbitraryAttributeDescriptor, ARBITRARY_DESCRIPTOR_VALIDATOR);
                    }
                }
            }
        }
        ModelTestModelDescriptionValidator validator = new ModelTestModelDescriptionValidator(PathAddress.EMPTY_ADDRESS.toModelNode(), model, config);
        List list = validator.validateResources();
        if (!list.isEmpty()) {
            StringBuilder builder = new StringBuilder("VALIDATION ERRORS IN MODEL:");
            for (ModelTestModelDescriptionValidator.ValidationFailure failure : list) {
                builder.append(failure);
                builder.append("\n");
            }
            Assert.fail((String)("Failed due to validation errors in the model. Please fix :-) " + builder.toString()));
        }
    }

    ModelNode checkCoreModelTransformation(KernelServices kernelServices, ModelVersion modelVersion, ModelFixer legacyModelFixer, ModelFixer transformedModelFixer) throws IOException {
        ModelNode legacyModel;
        KernelServices legacyServices = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        ModelNode op = new ModelNode();
        op.get("address").setEmptyList();
        op.get("operation").set("read-resource");
        op.get("recursive").set(true);
        op.get("include-defaults").set(false);
        try {
            legacyModel = legacyServices.executeForResult(op, new InputStream[0]);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
        this.removeDefaultAttributesWronglyShowingInRecursiveReadResource(modelVersion, legacyServices, legacyModel);
        ModelNode transformed = kernelServices.readTransformedModel(modelVersion);
        this.adjustUndefinedInTransformedToEmpty(modelVersion, legacyModel, transformed);
        if (legacyModelFixer != null) {
            legacyModel = legacyModelFixer.fixModel(legacyModel);
        }
        if (transformedModelFixer != null) {
            transformed = transformedModelFixer.fixModel(transformed);
        }
        this.temporaryHack(transformed, legacyModel);
        ModelTestUtils.compare((ModelNode)legacyModel, (ModelNode)transformed, (boolean)true);
        return legacyModel;
    }

    private void temporaryHack(ModelNode transformedModel, ModelNode legacyModel) {
        if (legacyModel.hasDefined("namespaces") && !transformedModel.hasDefined("namespaces") && legacyModel.get("namespaces").asList().isEmpty()) {
            legacyModel.get("namespaces").set(new ModelNode());
        }
        if (legacyModel.hasDefined("schema-locations") && !transformedModel.hasDefined("schema-locations") && legacyModel.get("schema-locations").asList().isEmpty()) {
            legacyModel.get("schema-locations").set(new ModelNode());
        }
        legacyModel.remove("management-major-version");
        legacyModel.remove("management-minor-version");
        legacyModel.remove("management-micro-version");
        legacyModel.remove("name");
        legacyModel.remove("release-codename");
        legacyModel.remove("release-version");
        transformedModel.remove("management-major-version");
        transformedModel.remove("management-minor-version");
        transformedModel.remove("management-micro-version");
        transformedModel.remove("name");
        transformedModel.remove("release-codename");
        transformedModel.remove("release-version");
    }

    private void removeDefaultAttributesWronglyShowingInRecursiveReadResource(ModelVersion modelVersion, KernelServices legacyServices, ModelNode legacyModel) {
        if (modelVersion.getMajor() == 1 && modelVersion.getMinor() < 4) {
            this.checkAttributeIsActuallyDefinedAndReplaceIfNot(legacyServices, legacyModel, "management-subsystem-endpoint", "server-group");
            this.checkAttributeIsActuallyDefinedAndReplaceIfNot(legacyServices, legacyModel, "read-only", "path");
            this.removeDefaultAttributesWronglyShowingInRecursiveReadResourceInSocketBindingGroup(modelVersion, legacyServices, legacyModel);
        }
    }

    private void removeDefaultAttributesWronglyShowingInRecursiveReadResourceInSocketBindingGroup(ModelVersion modelVersion, KernelServices legacyServices, ModelNode legacyModel) {
        if (legacyModel.hasDefined("socket-binding-group")) {
            for (Property prop : legacyModel.get("socket-binding-group").asPropertyList()) {
                if (!prop.getValue().isDefined()) continue;
                this.checkAttributeIsActuallyDefinedAndReplaceIfNot(legacyServices, legacyModel, "fixed-source-port", "socket-binding-group", prop.getName(), "remote-destination-outbound-socket-binding");
                this.checkAttributeIsActuallyDefinedAndReplaceIfNot(legacyServices, legacyModel, "fixed-source-port", "socket-binding-group", prop.getName(), "local-destination-outbound-socket-binding");
                this.checkAttributeIsActuallyDefinedAndReplaceIfNot(legacyServices, legacyModel, "fixed-port", "socket-binding-group", prop.getName(), "socket-binding");
            }
        }
    }

    private void adjustUndefinedInTransformedToEmpty(ModelVersion modelVersion, ModelNode legacyModel, ModelNode transformed) {
        boolean is7_1_x = ModelVersion.compare((ModelVersion)ModelVersion.create((int)1, (int)4, (int)0), (ModelVersion)modelVersion) < 0;
        for (PathAddress address : EMPTY_RESOURCE_ADDRESSES) {
            this.harmonizeModel(modelVersion, legacyModel, transformed, address, ModelHarmonizer.UNDEFINED_TO_EMPTY);
        }
        if (!is7_1_x) {
            for (PathAddress address : MISSING_NAME_ADDRESSES) {
                this.harmonizeModel(modelVersion, legacyModel, transformed, address, ModelHarmonizer.MISSING_NAME);
            }
        }
    }

    private void harmonizeModel(ModelVersion modelVersion, ModelNode legacyModel, ModelNode transformed, PathAddress address, ModelHarmonizer harmonizer) {
        if (address.size() > 0) {
            PathElement pathElement = address.getElement(0);
            if (legacyModel.hasDefined(pathElement.getKey()) && transformed.hasDefined(pathElement.getKey())) {
                PathAddress childAddress;
                ModelNode legacyType = legacyModel.get(pathElement.getKey());
                ModelNode transformedType = transformed.get(pathElement.getKey());
                PathAddress pathAddress = childAddress = address.size() > 1 ? address.subAddress(1) : PathAddress.EMPTY_ADDRESS;
                if (pathElement.isWildcard()) {
                    for (String key : legacyType.keys()) {
                        if (!transformedType.has(key)) continue;
                        this.harmonizeModel(modelVersion, legacyType.get(key), transformedType.get(key), childAddress, harmonizer);
                    }
                } else {
                    this.harmonizeModel(modelVersion, legacyType.get(pathElement.getValue()), transformedType.get(pathElement.getValue()), address, harmonizer);
                }
            }
        } else {
            harmonizer.harmonizeModel(modelVersion, legacyModel, transformed);
        }
    }

    private void checkAttributeIsActuallyDefinedAndReplaceIfNot(KernelServices legacyServices, ModelNode legacyModel, String attributeName, String ... parentAddress) {
        ModelNode parentNode = legacyModel;
        for (String s : parentAddress) {
            if (!parentNode.hasDefined(s)) {
                return;
            }
            parentNode = parentNode.get(s);
            if (parentNode.isDefined()) continue;
            return;
        }
        for (Property prop : parentNode.asPropertyList()) {
            ModelNode attribute;
            if (!prop.getValue().isDefined() || !(attribute = parentNode.get(new String[]{prop.getName(), attributeName})).isDefined()) continue;
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            for (int i = 0; i < parentAddress.length; ++i) {
                if (i < parentAddress.length - 1) {
                    op.get("address").add(parentAddress[i], parentAddress[++i]);
                    continue;
                }
                op.get("address").add(parentAddress[i], prop.getName());
            }
            op.get("name").set(attributeName);
            op.get("include-defaults").set(false);
            try {
                ModelNode result = legacyServices.executeForResult(op, new InputStream[0]);
                if (result.isDefined()) continue;
                attribute.set(new ModelNode());
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        EMPTY_RESOURCE_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile")}));
        EMPTY_RESOURCE_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay"), PathElement.pathElement((String)"deployment")}));
        EMPTY_RESOURCE_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group"), PathElement.pathElement((String)"deployment-overlay"), PathElement.pathElement((String)"deployment")}));
        MISSING_NAME_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile")}));
        MISSING_NAME_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"interface")}));
        MISSING_NAME_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path")}));
        MISSING_NAME_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment")}));
        MISSING_NAME_ADDRESSES.add(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group"), PathElement.pathElement((String)"deployment")}));
    }

    private class LegacyKernelServicesInitializerImpl
    implements LegacyKernelServicesInitializer {
        private final ChildFirstClassLoaderBuilder classLoaderBuilder;
        private final ModelVersion modelVersion;
        private final List<LegacyModelInitializerEntry> modelInitializerEntries = new ArrayList<LegacyModelInitializerEntry>();
        private final ModelTestControllerVersion testControllerVersion;
        private boolean dontUseBootOperations = false;
        private boolean skipReverseCheck;
        private ModelFixer reverseCheckMainModelFixer;
        private ModelFixer reverseCheckLegacyModelFixer;
        private ModelTestOperationValidatorFilter.Builder operationValidationExcludeFilterBuilder;

        LegacyKernelServicesInitializerImpl(ModelVersion modelVersion, ModelTestControllerVersion version) {
            this.classLoaderBuilder = new ChildFirstClassLoaderBuilder(version.isEap());
            this.modelVersion = modelVersion;
            this.testControllerVersion = version;
        }

        private LegacyControllerKernelServicesProxy install(AbstractKernelServicesImpl mainServices, ModelInitializer modelInitializer, ModelWriteSanitizer modelWriteSanitizer, List<String> contentRepositoryContents, List<ModelNode> bootOperations) throws Exception {
            ClassLoader legacyCl;
            if (this.testControllerVersion == null) {
                throw new IllegalStateException();
            }
            if (!this.skipReverseCheck) {
                this.bootCurrentVersionWithLegacyBootOperations(bootOperations, modelInitializer, modelWriteSanitizer, contentRepositoryContents, mainServices);
            }
            if (CoreModelTestDelegate.this.currentTransformerClassloaderParameter != null && CoreModelTestDelegate.this.currentTransformerClassloaderParameter.getClassLoader() != null) {
                legacyCl = CoreModelTestDelegate.this.currentTransformerClassloaderParameter.getClassLoader();
            } else {
                this.classLoaderBuilder.addParentFirstClassPattern("org.jboss.as.core.model.bridge.shared.*");
                this.classLoaderBuilder.addParentFirstClassPattern("org.jboss.modules.*");
                this.classLoaderBuilder.addParentFirstClassPattern("org.jboss.logmanager.*");
                this.classLoaderBuilder.addMavenResourceURL("org.wildfly.core:wildfly-core-model-test-framework:" + ModelTestControllerVersion.CurrentVersion.VERSION);
                this.classLoaderBuilder.addMavenResourceURL("org.wildfly.core:wildfly-model-test:" + ModelTestControllerVersion.CurrentVersion.VERSION);
                this.classLoaderBuilder.addMavenResourceURL("org.wildfly.legacy.test:wildfly-legacy-spi:" + Version.LEGACY_TEST_CONTROLLER_VERSION);
                if (this.testControllerVersion != ModelTestControllerVersion.MASTER) {
                    String groupId = this.testControllerVersion.getCoreMavenGroupId();
                    String hostControllerArtifactId = this.testControllerVersion.getHostControllerMavenArtifactId();
                    this.classLoaderBuilder.addRecursiveMavenResourceURL(groupId + ":" + hostControllerArtifactId + ":" + this.testControllerVersion.getCoreVersion(), new String[0]);
                    this.classLoaderBuilder.addMavenResourceURL("org.wildfly.legacy.test:wildfly-legacy-core-" + this.testControllerVersion.getTestControllerVersion() + ":" + Version.LEGACY_TEST_CONTROLLER_VERSION);
                }
                legacyCl = this.classLoaderBuilder.build();
                if (CoreModelTestDelegate.this.currentTransformerClassloaderParameter != null) {
                    CoreModelTestDelegate.this.currentTransformerClassloaderParameter.setClassLoader(legacyCl);
                }
            }
            ScopedKernelServicesBootstrap scopedBootstrap = new ScopedKernelServicesBootstrap(legacyCl);
            LegacyControllerKernelServicesProxy legacyServices = scopedBootstrap.createKernelServices(bootOperations, this.getOperationValidationFilter(), this.modelVersion, this.modelInitializerEntries);
            return legacyServices;
        }

        @Override
        public LegacyKernelServicesInitializer initializerCreateModelResource(PathAddress parentAddress, PathElement relativeResourceAddress, ModelNode model, String ... capabilities) {
            this.modelInitializerEntries.add(new LegacyModelInitializerEntry(parentAddress, relativeResourceAddress, model, capabilities));
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer initializerCreateModelResource(PathAddress parentAddress, PathElement relativeResourceAddress, ModelNode model) {
            return this.initializerCreateModelResource(parentAddress, relativeResourceAddress, model, new String[0]);
        }

        @Override
        public LegacyKernelServicesInitializer addOperationValidationExclude(String name, PathAddress pathAddress) {
            this.addOperationValidationConfig(name, pathAddress, ModelTestOperationValidatorFilter.Action.NOCHECK);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addOperationValidationResolve(String name, PathAddress pathAddress) {
            this.addOperationValidationConfig(name, pathAddress, ModelTestOperationValidatorFilter.Action.RESOLVE);
            return this;
        }

        private void addOperationValidationConfig(String name, PathAddress pathAddress, ModelTestOperationValidatorFilter.Action action) {
            if (this.operationValidationExcludeFilterBuilder == null) {
                this.operationValidationExcludeFilterBuilder = ModelTestOperationValidatorFilter.createBuilder();
            }
            this.operationValidationExcludeFilterBuilder.addOperation(pathAddress, name, action, null);
        }

        @Override
        public LegacyKernelServicesInitializer setDontUseBootOperations() {
            this.dontUseBootOperations = true;
            return this;
        }

        boolean isDontUseBootOperations() {
            return this.dontUseBootOperations;
        }

        @Override
        public LegacyKernelServicesInitializer skipReverseControllerCheck() {
            this.skipReverseCheck = true;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer configureReverseControllerCheck(ModelFixer mainModelFixer, ModelFixer legacyModelFixer) {
            this.reverseCheckMainModelFixer = mainModelFixer;
            this.reverseCheckLegacyModelFixer = legacyModelFixer;
            return this;
        }

        private KernelServices bootCurrentVersionWithLegacyBootOperations(List<ModelNode> bootOperations, ModelInitializer modelInitializer, ModelWriteSanitizer modelWriteSanitizer, List<String> contentRepositoryHashes, KernelServices mainServices) throws Exception {
            KernelServicesBuilder reverseServicesBuilder = CoreModelTestDelegate.this.createKernelServicesBuilder(TestModelType.DOMAIN).setBootOperations(bootOperations).setModelInitializer(modelInitializer, modelWriteSanitizer);
            for (String hash : contentRepositoryHashes) {
                reverseServicesBuilder.createContentRepositoryContent(hash);
            }
            KernelServices reverseServices = reverseServicesBuilder.build();
            if (reverseServices.getBootError() != null) {
                Throwable t = reverseServices.getBootError();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t);
            }
            Assert.assertTrue((String)reverseServices.getBootErrorDescription(), (reverseServices.isSuccessfulBoot() && !reverseServices.hasBootErrorCollectorFailures() ? 1 : 0) != 0);
            ModelNode mainModel = mainServices.readWholeModel();
            if (this.reverseCheckMainModelFixer != null) {
                mainModel = this.reverseCheckMainModelFixer.fixModel(mainModel);
            }
            ModelNode reverseModel = reverseServices.readWholeModel();
            if (this.reverseCheckLegacyModelFixer != null) {
                reverseModel = this.reverseCheckLegacyModelFixer.fixModel(reverseModel);
            }
            ModelTestUtils.compare((ModelNode)mainModel, (ModelNode)reverseModel);
            return reverseServices;
        }

        private ModelTestOperationValidatorFilter getOperationValidationFilter() {
            if (this.operationValidationExcludeFilterBuilder != null) {
                return this.operationValidationExcludeFilterBuilder.build();
            }
            return ModelTestOperationValidatorFilter.createValidateAll();
        }
    }

    private class KernelServicesBuilderImpl
    implements KernelServicesBuilder,
    ModelTestBootOperationsBuilder.BootOperationParser {
        private final TestModelType type;
        private final ModelTestBootOperationsBuilder bootOperationBuilder;
        private final TestParser testParser;
        private ProcessType processType;
        private ModelInitializer modelInitializer;
        private ModelWriteSanitizer modelWriteSanitizer;
        private boolean validateDescription;
        private boolean validateOperations;
        private XMLMapper xmlMapper;
        private Map<ModelVersion, LegacyKernelServicesInitializerImpl> legacyControllerInitializers;
        private List<String> contentRepositoryContents;
        private final RunningModeControl runningModeControl;
        ExtensionRegistry extensionRegistry;
        private final Map<ModelNode, Map<String, Set<String>>> attributeDescriptors;
        private Map<ModelNode, Map<String, Map<String, Set<String>>>> operationParameterDescriptors;

        public KernelServicesBuilderImpl(TestModelType type) {
            this.bootOperationBuilder = new ModelTestBootOperationsBuilder(CoreModelTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            this.validateOperations = true;
            this.xmlMapper = XMLMapper.Factory.create();
            this.legacyControllerInitializers = new HashMap<ModelVersion, LegacyKernelServicesInitializerImpl>();
            this.contentRepositoryContents = new ArrayList<String>();
            this.attributeDescriptors = new HashMap<ModelNode, Map<String, Set<String>>>();
            this.operationParameterDescriptors = new HashMap<ModelNode, Map<String, Map<String, Set<String>>>>();
            this.type = type;
            this.processType = type == TestModelType.HOST || type == TestModelType.DOMAIN ? ProcessType.HOST_CONTROLLER : ProcessType.STANDALONE_SERVER;
            this.runningModeControl = type == TestModelType.HOST ? new HostRunningModeControl(RunningMode.ADMIN_ONLY, RestartMode.HC_ONLY) : new RunningModeControl(RunningMode.ADMIN_ONLY);
            this.extensionRegistry = ExtensionRegistry.builder((ProcessType)this.processType).withRunningModeControl(this.runningModeControl).build();
            this.testParser = TestParser.create(this.extensionRegistry, this.xmlMapper, type);
        }

        @Override
        public KernelServicesBuilder validateDescription() {
            this.validateDescription = true;
            return this;
        }

        @Override
        public KernelServicesBuilder setXmlResource(String resource) throws IOException, XMLStreamException {
            this.bootOperationBuilder.setXmlResource(resource);
            return this;
        }

        @Override
        public KernelServicesBuilder setXml(String subsystemXml) throws XMLStreamException {
            this.bootOperationBuilder.setXml(subsystemXml);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(List<ModelNode> bootOperations) {
            this.bootOperationBuilder.setBootOperations(bootOperations);
            return this;
        }

        @Override
        public List<ModelNode> parseXml(String xml) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(CoreModelTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXml(xml);
            return builder.build();
        }

        @Override
        public List<ModelNode> parseXmlResource(String xmlResource) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(CoreModelTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXmlResource(xmlResource);
            return builder.build();
        }

        @Override
        public KernelServicesBuilder setModelInitializer(ModelInitializer modelInitializer, ModelWriteSanitizer modelWriteSanitizer) {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            this.modelInitializer = modelInitializer;
            this.modelWriteSanitizer = modelWriteSanitizer;
            this.testParser.addModelWriteSanitizer(modelWriteSanitizer);
            return this;
        }

        @Override
        public KernelServicesBuilder createContentRepositoryContent(String hash) {
            this.contentRepositoryContents.add(hash);
            return this;
        }

        @Override
        public KernelServices build() throws Exception {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            List bootOperations = this.bootOperationBuilder.build();
            if (this.type == TestModelType.HOST) {
                this.adjustLocalDomainControllerWriteForHost(bootOperations);
            }
            AbstractKernelServicesImpl kernelServices = AbstractKernelServicesImpl.create(this.processType, this.runningModeControl, ModelTestOperationValidatorFilter.createValidateAll(), bootOperations, this.testParser, null, this.type, this.modelInitializer, this.extensionRegistry, this.contentRepositoryContents);
            CoreModelTestDelegate.this.kernelServices.add(kernelServices);
            if (this.validateDescription) {
                CoreModelTestDelegate.this.validateDescriptionProviders(this.type, kernelServices, this.attributeDescriptors, this.operationParameterDescriptors);
            }
            ModelTestUtils.validateModelDescriptions((PathAddress)PathAddress.EMPTY_ADDRESS, (ImmutableManagementResourceRegistration)kernelServices.getRootRegistration());
            ModelNode model = kernelServices.readWholeModel();
            model = this.removeForIntellij(model);
            ModelTestUtils.scanForExpressionFormattedStrings((ModelNode)model);
            for (Map.Entry<ModelVersion, LegacyKernelServicesInitializerImpl> entry : this.legacyControllerInitializers.entrySet()) {
                List<ModelNode> transformedBootOperations;
                LegacyKernelServicesInitializerImpl legacyInitializer = entry.getValue();
                if (legacyInitializer.isDontUseBootOperations()) {
                    transformedBootOperations = Collections.emptyList();
                } else {
                    transformedBootOperations = new ArrayList();
                    for (ModelNode op : bootOperations) {
                        ModelNode transformed = kernelServices.transformOperation(entry.getKey(), op).getTransformedOperation();
                        if (transformed == null) continue;
                        transformedBootOperations.add(transformed);
                    }
                }
                LegacyControllerKernelServicesProxy legacyServices = legacyInitializer.install(kernelServices, this.modelInitializer, this.modelWriteSanitizer, this.contentRepositoryContents, transformedBootOperations);
                kernelServices.addLegacyKernelService(entry.getKey(), legacyServices);
            }
            return kernelServices;
        }

        private void adjustLocalDomainControllerWriteForHost(List<ModelNode> bootOperations) {
            boolean dcInBootOps = false;
            for (ModelNode op : bootOperations) {
                String attributeName;
                String opName = op.get("operation").asString();
                if (opName.equals("write-local-domain-controller") || opName.equals("write-remote-domain-controller")) {
                    dcInBootOps = true;
                    break;
                }
                if ("write-attribute".equals(opName) && "domain-controller".equals(attributeName = op.get("name").asString())) {
                    dcInBootOps = true;
                    break;
                }
                if (!"add".equals(opName) || !op.has("is-domain-controller") || op.get("is-domain-controller").equals(new ModelNode().setEmptyObject())) continue;
                dcInBootOps = true;
                break;
            }
            if (!dcInBootOps) {
                this.testParser.addModelWriteSanitizer(new ModelWriteSanitizer(){

                    @Override
                    public ModelNode sanitize(ModelNode model) {
                        if (model.isDefined() && model.has("domain-controller")) {
                            model.remove("domain-controller");
                        }
                        return model;
                    }
                });
            }
        }

        private ModelNode removeForIntellij(ModelNode model) {
            ModelNode runtime = this.findModelNode(model, "host", "primary", "core-service", "platform-mbean", "type", "runtime");
            if (runtime.isDefined()) {
                runtime.remove("input-arguments");
                if (runtime.hasDefined("system-properties")) {
                    ModelNode properties = runtime.get("system-properties");
                    properties.remove("org.jboss.model.test.maven.repository.urls");
                }
            }
            return model;
        }

        private ModelNode findModelNode(ModelNode model, String ... name) {
            ModelNode currentModel = model;
            for (String part : name) {
                if (!currentModel.hasDefined(part)) {
                    return new ModelNode();
                }
                currentModel = currentModel.get(part);
            }
            return currentModel;
        }

        public List<ModelNode> parse(String xml) throws XMLStreamException {
            XMLStreamReader reader = XMLInputFactoryUtil.create().createXMLStreamReader(new StringReader(xml));
            ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
            this.xmlMapper.parseDocument(operationList, reader);
            return operationList;
        }

        @Override
        public LegacyKernelServicesInitializer createLegacyKernelServicesBuilder(ModelVersion modelVersion, ModelTestControllerVersion testControllerVersion) {
            if (this.type != TestModelType.DOMAIN) {
                throw new IllegalStateException("Can only create legacy kernel services for DOMAIN.");
            }
            LegacyKernelServicesInitializerImpl legacyKernelServicesInitializerImpl = new LegacyKernelServicesInitializerImpl(modelVersion, testControllerVersion);
            this.legacyControllerInitializers.put(modelVersion, legacyKernelServicesInitializerImpl);
            return legacyKernelServicesInitializerImpl;
        }

        @Override
        public KernelServicesBuilder setDontValidateOperations() {
            this.validateOperations = true;
            return this;
        }

        @Override
        public KernelServicesBuilder registerAttributeArbitraryDescriptor(ModelNode address, String name, String descriptor) {
            if (!this.attributeDescriptors.containsKey(address)) {
                this.attributeDescriptors.put(address, new HashMap());
            }
            if (!this.attributeDescriptors.get(address).containsKey(name)) {
                this.attributeDescriptors.get(address).put(name, new HashSet());
            }
            this.attributeDescriptors.get(address).get(name).add(descriptor);
            return this;
        }

        @Override
        public KernelServicesBuilder registerArbitraryDescriptorForOperationParameter(ModelNode address, String operation, String parameter, String descriptor) {
            if (!this.operationParameterDescriptors.containsKey(address)) {
                this.operationParameterDescriptors.put(address, new HashMap());
            }
            if (!this.operationParameterDescriptors.get(address).containsKey(operation)) {
                this.operationParameterDescriptors.get(address).put(operation, new HashMap());
            }
            if (!this.operationParameterDescriptors.get(address).get(operation).containsKey(parameter)) {
                this.operationParameterDescriptors.get(address).get(operation).put(parameter, new HashSet());
            }
            this.operationParameterDescriptors.get(address).get(operation).get(parameter).add(descriptor);
            return this;
        }
    }
}

