/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.core.model.test.ModelWriteSanitizer;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.host.controller.parsing.DomainXml;
import org.jboss.as.host.controller.parsing.HostXml;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class TestParser
implements ModelTestParser {
    private final TestModelType type;
    private final XMLElementReader<List<ModelNode>> reader;
    private final XMLElementWriter<ModelMarshallingContext> writer;
    private volatile List<ModelWriteSanitizer> writeSanitizers;

    public TestParser(TestModelType type, XMLElementReader<List<ModelNode>> reader, XMLElementWriter<ModelMarshallingContext> writer) {
        this.type = type;
        this.reader = reader;
        this.writer = writer;
    }

    public static TestParser create(ExtensionRegistry registry, XMLMapper xmlMapper, TestModelType type) {
        String root;
        TestParser testParser;
        if (type == TestModelType.STANDALONE) {
            StandaloneXml standaloneXml = new StandaloneXml(null, Executors.newCachedThreadPool(), registry);
            testParser = new TestParser(type, (XMLElementReader<List<ModelNode>>)standaloneXml, (XMLElementWriter<ModelMarshallingContext>)standaloneXml);
            root = "server";
        } else if (type == TestModelType.DOMAIN) {
            DomainXml domainXml = new DomainXml(null, Executors.newCachedThreadPool(), registry);
            testParser = new TestParser(type, (XMLElementReader<List<ModelNode>>)domainXml, (XMLElementWriter<ModelMarshallingContext>)domainXml);
            root = "domain";
        } else if (type == TestModelType.HOST) {
            Namespace[] hostXml = new HostXml("primary", RunningMode.NORMAL, false, null, Executors.newCachedThreadPool(), registry);
            testParser = new TestParser(type, (XMLElementReader<List<ModelNode>>)hostXml, (XMLElementWriter<ModelMarshallingContext>)hostXml);
            root = "host";
        } else {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        try {
            for (Namespace ns : Namespace.ALL_NAMESPACES) {
                xmlMapper.registerRootElement(new QName(ns.getUriString(), root), (XMLElementReader)testParser);
            }
        }
        catch (NoSuchFieldError e) {
            xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), root), (XMLElementReader)testParser);
            xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_1.getUriString(), root), (XMLElementReader)testParser);
            xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_2.getUriString(), root), (XMLElementReader)testParser);
        }
        return testParser;
    }

    void addModelWriteSanitizer(ModelWriteSanitizer writeSanitizer) {
        if (writeSanitizer == null) {
            return;
        }
        if (this.writeSanitizers == null) {
            this.writeSanitizers = new ArrayList<ModelWriteSanitizer>();
        }
        this.writeSanitizers.add(writeSanitizer);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> value) throws XMLStreamException {
        this.reader.readElement(reader, value);
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, ModelMarshallingContext context) throws XMLStreamException {
        this.writer.writeContent(streamWriter, (Object)this.sanitizeContext(this.wrapPossibleHost(context)));
    }

    private ModelMarshallingContext wrapPossibleHost(final ModelMarshallingContext context) {
        if (this.type == TestModelType.HOST) {
            return new ModelMarshallingContext(){

                public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String subsystemName) {
                    return context.getSubsystemWriter(subsystemName);
                }

                public ModelNode getModelNode() {
                    return context.getModelNode().get(new String[]{"host", "primary"});
                }
            };
        }
        return context;
    }

    private ModelMarshallingContext sanitizeContext(final ModelMarshallingContext context) {
        if (this.writeSanitizers == null) {
            return context;
        }
        ModelNode model = context.getModelNode();
        for (ModelWriteSanitizer sanitizer : this.writeSanitizers) {
            model = sanitizer.sanitize(model);
        }
        final ModelNode theModel = model;
        return new ModelMarshallingContext(){

            public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String subsystemName) {
                return context.getSubsystemWriter(subsystemName);
            }

            public ModelNode getModelNode() {
                return theModel;
            }
        };
    }
}

