/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.SchemaValidator;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Test;

public abstract class AbstractSubsystemBaseTest
extends AbstractSubsystemTest {
    public AbstractSubsystemBaseTest(String mainSubsystemName, Extension mainExtension) {
        super(mainSubsystemName, mainExtension);
    }

    public AbstractSubsystemBaseTest(String mainSubsystemName, Extension mainExtension, Comparator<PathAddress> removeOrderComparator) {
        super(mainSubsystemName, mainExtension, removeOrderComparator);
    }

    protected abstract String getSubsystemXml() throws IOException;

    protected String getSubsystemXsdPath() throws Exception {
        return null;
    }

    @Deprecated
    protected String[] getSubsystemTemplatePaths() throws IOException {
        return new String[0];
    }

    protected Properties getResolvedProperties() {
        return new Properties();
    }

    protected String getSubsystemXml(String configId) throws IOException {
        return this.readResource(configId);
    }

    protected String getComparisonXml() throws IOException {
        return null;
    }

    protected String getComparisonXml(String configId) throws IOException {
        return null;
    }

    @Test
    public void testSubsystem() throws Exception {
        this.standardSubsystemTest(null);
    }

    @Test
    public void testSchema() throws Exception {
        String schemaPath = this.getSubsystemXsdPath();
        Assume.assumeTrue((String)"getSubsystemXsdPath() has been overridden to disable the validation of the subsystem templates", (schemaPath != null ? 1 : 0) != 0);
        SchemaValidator.validateXML(this.getSubsystemXml(), schemaPath, this.getResolvedProperties());
    }

    @Deprecated
    protected void testSchemaOfSubsystemTemplates() throws Exception {
        throw new AssumptionViolatedException("testSchemaOfSubsystemTemplates is deprecated");
    }

    protected void standardSubsystemTest(String configId) throws Exception {
        this.standardSubsystemTest(configId, true);
    }

    protected KernelServices standardSubsystemTest(String configId, boolean compareXml) throws Exception {
        return this.standardSubsystemTest(configId, null, compareXml);
    }

    protected void standardSubsystemTest(String configId, String configIdResolvedModel) throws Exception {
        this.standardSubsystemTest(configId, configIdResolvedModel, true);
    }

    protected KernelServices standardSubsystemTest(String configId, String configIdResolvedModel, boolean compareXml) throws Exception {
        return this.standardSubsystemTest(configId, configIdResolvedModel, compareXml, this.createAdditionalInitialization());
    }

    protected KernelServices standardSubsystemTest(String configId, String configIdResolvedModel, boolean compareXml, AdditionalInitialization additionalInit) throws Exception {
        String subsystemXml = configId == null ? this.getSubsystemXml() : this.getSubsystemXml(configId);
        KernelServices servicesA = super.createKernelServicesBuilder(additionalInit).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)servicesA.isSuccessfulBoot());
        ModelNode modelA = servicesA.readWholeModel();
        this.validateModel(modelA);
        ModelTestUtils.scanForExpressionFormattedStrings((ModelNode)modelA);
        String marshalled = servicesA.getPersistedSubsystemXml();
        servicesA.shutdown();
        String normalizedSubsystem = this.normalizeXML(subsystemXml);
        if (compareXml) {
            String comparisonXml = configId == null ? this.getComparisonXml() : this.getComparisonXml(configId);
            comparisonXml = comparisonXml != null ? this.normalizeXML(comparisonXml) : normalizedSubsystem;
            this.compareXml(configId, comparisonXml, this.normalizeXML(marshalled));
        }
        KernelServices servicesB = super.createKernelServicesBuilder(additionalInit).setSubsystemXml(marshalled).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)servicesB.isSuccessfulBoot());
        ModelNode modelB = servicesB.readWholeModel();
        this.compare(modelA, modelB);
        this.validateDescribeOperation(servicesB, additionalInit, modelA);
        this.assertRemoveSubsystemResources(servicesB, this.getIgnoredChildResourcesForRemovalTest());
        servicesB.shutdown();
        if (configIdResolvedModel != null) {
            String subsystemResolvedXml = this.getSubsystemXml(configIdResolvedModel);
            KernelServices servicesD = super.createKernelServicesBuilder(additionalInit).setSubsystemXml(subsystemResolvedXml).build();
            Assert.assertTrue((String)"Subsystem w/ resolved xml boot failed!", (boolean)servicesD.isSuccessfulBoot());
            ModelNode modelD = servicesD.readWholeModel();
            this.validateModel(modelD);
            this.resolveandCompareModel(modelA, modelD);
        }
        return servicesA;
    }

    protected void validateDescribeOperation(KernelServices hc, AdditionalInitialization serverInit, ModelNode expectedModel) throws Exception {
        ModelNode operation = this.createDescribeOperation();
        ModelNode result = hc.executeOperation(operation, new InputStream[0]);
        Assert.assertTrue((String)("the subsystem describe operation has to generate a list of operations to recreate the subsystem: " + result.asString()), (!result.hasDefined("failure-description") ? 1 : 0) != 0);
        List operations = result.get("result").asList();
        KernelServices servicesC = super.createKernelServicesBuilder(serverInit).setBootOperations(operations).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)servicesC.isSuccessfulBoot());
        ModelNode serverModel = servicesC.readWholeModel();
        this.compare(expectedModel, serverModel);
        servicesC.shutdown();
    }

    protected void validateModel(ModelNode model) {
        Assert.assertNotNull((Object)model);
    }

    protected ModelNode createDescribeOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", this.getMainSubsystemName());
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(address);
        return operation;
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return AdditionalInitialization.MANAGEMENT;
    }

    protected Set<PathAddress> getIgnoredChildResourcesForRemovalTest() {
        return Collections.emptySet();
    }
}

