/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.staxmapper.IntVersion;

public abstract class AbstractSubsystemSchemaTest<S extends SubsystemSchema<S>>
extends AbstractSubsystemBaseTest {
    private final S schema;
    private final boolean latest;

    protected AbstractSubsystemSchemaTest(String subsystemName, Extension extension, S testSchema, S currentSchema) {
        super(subsystemName, extension);
        this.schema = testSchema;
        this.latest = testSchema.since(currentSchema);
    }

    protected S getSubsystemSchema() {
        return this.schema;
    }

    protected String getSubsystemXmlPathPattern() {
        return "%s-%d.%d.xml";
    }

    protected String getSubsystemXsdPathPattern() {
        return "schema/wildfly-%s_%d_%d.xsd";
    }

    @Override
    protected String getSubsystemXml() throws IOException {
        return this.readResource(String.format(Locale.ROOT, this.getSubsystemXmlPathPattern(), this.getMainSubsystemName(), ((IntVersion)this.schema.getVersion()).major(), ((IntVersion)this.schema.getVersion()).minor()));
    }

    @Override
    protected String getSubsystemXsdPath() throws Exception {
        return String.format(Locale.ROOT, this.getSubsystemXsdPathPattern(), this.getMainSubsystemName(), ((IntVersion)this.schema.getVersion()).major(), ((IntVersion)this.schema.getVersion()).minor());
    }

    @Override
    public void testSubsystem() throws Exception {
        this.standardSubsystemTest(null, this.latest);
    }
}

