/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.junit.Assert;

public class TransformerAttachmentGrabber
implements OperationStepHandler {
    private static final AttributeDefinition VALUE = SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.OBJECT).build();
    static final OperationDefinition DESC = new SimpleOperationDefinitionBuilder("execute-grab-attachment-and-transform", (ResourceDescriptionResolver)NonResolvingResourceDescriptionResolver.INSTANCE).setParameters(new AttributeDefinition[]{VALUE}).build();
    private static TransformerOperationAttachment attachment;

    TransformerAttachmentGrabber() {
    }

    static void clear() {
        attachment = null;
    }

    public static TransformerOperationAttachment getAttachment() {
        return attachment;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (attachment != null) {
            Assert.fail((String)"Attachment is already set");
        }
        ModelNode realOp = operation.require(VALUE.getName());
        String opName = realOp.require("operation").asString();
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)realOp.require("address"));
        OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(opAddr, opName);
        context.addStep(realOp, handler, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                attachment = (TransformerOperationAttachment)context.getAttachment(TransformerOperationAttachment.KEY);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

