/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ProcessEnvironment {
    protected static final String UUID_FILE = "process-uuid";
    protected static final String KERNEL_DIR = "kernel";
    public static final String JBOSS_DOMAIN_UUID = "jboss.domain.uuid";
    public static final AttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setAllowExpression(true)).build();

    public OperationStepHandler getProcessNameReadHandler() {
        return new ProcessNameReadAttributeHandler();
    }

    public OperationStepHandler getProcessNameWriteHandler() {
        return new ProcessNameWriteAttributeHandler();
    }

    protected abstract String getProcessName();

    protected abstract void setProcessName(String var1);

    protected abstract boolean isRuntimeSystemPropertyUpdateAllowed(String var1, String var2, boolean var3) throws OperationFailedException;

    protected abstract void systemPropertyUpdated(String var1, String var2);

    public abstract UUID getInstanceUuid();

    public abstract String getQualifiedHostName();

    public abstract String getHostName();

    public abstract RunningModeControl getRunningModeControl();

    public abstract String getHostControllerName();

    protected final UUID obtainProcessUUID(Path filePath, String assignedValue) throws IOException {
        String uuidString = "";
        UUID uuid = null;
        if (assignedValue == null && Files.exists(filePath, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(filePath);){
                uuidString = lines.findFirst().get();
                uuid = UUID.fromString(uuidString);
            }
            catch (NoSuchElementException e) {
                ControllerLogger.ROOT_LOGGER.uuidIsEmpty(filePath.toString());
            }
            catch (IllegalArgumentException e) {
                ControllerLogger.ROOT_LOGGER.uuidNotValid(uuidString, filePath.toString());
            }
        }
        if (uuid == null) {
            uuid = assignedValue == null ? UUID.randomUUID() : UUID.fromString(assignedValue);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.write(filePath, Collections.singletonList(uuid.toString()), StandardOpenOption.CREATE);
        }
        return uuid;
    }

    protected static String resolveGUID(String unresolvedName) {
        String result;
        if (JBOSS_DOMAIN_UUID.equals(unresolvedName)) {
            try {
                InetAddress localhost = InetAddressUtil.getLocalHost();
                result = UUID.nameUUIDFromBytes(localhost.getAddress()).toString();
            }
            catch (UnknownHostException e) {
                throw ControllerLogger.ROOT_LOGGER.cannotResolveProcessUUID(e);
            }
        } else {
            result = unresolvedName;
        }
        return result;
    }

    private class ProcessNameReadAttributeHandler
    implements OperationStepHandler {
        private ProcessNameReadAttributeHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
            if (model.hasDefined(NAME.getName())) {
                context.getResult().set(model.get(NAME.getName()));
            } else {
                context.getResult().set(ProcessEnvironment.this.getProcessName());
            }
        }
    }

    protected class ProcessNameWriteAttributeHandler
    implements OperationStepHandler {
        protected ProcessNameWriteAttributeHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
            ModelNode mockOp = new ModelNode();
            mockOp.get(NAME.getName()).set(newValue);
            NAME.validateAndSet(mockOp, model);
            final boolean booting = context.isBooting();
            String resolved = null;
            if (booting) {
                ModelNode resolvedNode = NAME.resolveModelAttribute(context, model);
                resolved = resolvedNode.isDefined() ? resolvedNode.asString() : null;
                resolved = resolved == null ? null : ProcessEnvironment.resolveGUID(resolved);
            } else {
                context.reloadRequired();
            }
            final String processName = resolved;
            if (booting) {
                context.addStep(new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ProcessEnvironment.this.setProcessName(processName);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep(new OperationContext.RollbackHandler(){

                @Override
                public void handleRollback(OperationContext context, ModelNode operation) {
                    if (!booting) {
                        context.revertReloadRequired();
                    }
                }
            });
        }
    }
}

