/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.logging.ControllerLogger;

public abstract class AllowAllowNotConstraint
extends AbstractConstraint {
    private final String type;
    private final Boolean is;
    private final Boolean allows;
    private final Boolean allowsNot;

    protected AllowAllowNotConstraint(boolean is) {
        this.is = is;
        this.allowsNot = null;
        this.allows = null;
        this.type = this.getClass().getSimpleName();
    }

    protected AllowAllowNotConstraint(boolean allows, boolean allowsNot) {
        this.is = null;
        this.allows = allows;
        this.allowsNot = allowsNot;
        this.type = this.getClass().getSimpleName();
    }

    @Override
    public boolean violates(Constraint other, Action.ActionEffect actionEffect) {
        if (other.getClass() == this.getClass()) {
            boolean violates;
            AllowAllowNotConstraint aanc = (AllowAllowNotConstraint)other;
            if (this.is == null) {
                boolean violates2;
                assert (aanc.is != null) : "incompatible comparison of user and required constraints";
                boolean bl = aanc.is.booleanValue() ? !this.allows.booleanValue() : (violates2 = this.allowsNot == false);
                if (violates2) {
                    ControllerLogger.ACCESS_LOGGER.tracef("%s violated for action %s : target is: %s, user allows: %s, user allows-not: %s", new Object[]{this.type, actionEffect, aanc.is, this.allows, this.allowsNot});
                }
                return violates2;
            }
            assert (aanc.is == null) : "incompatible comparison of user and required constraints";
            boolean bl = this.is.booleanValue() ? !aanc.allows.booleanValue() : (violates = aanc.allowsNot == false);
            if (violates) {
                ControllerLogger.ACCESS_LOGGER.tracef("%s violated for action %s : target is: %s, user allows: %s, user allows-not: %s", new Object[]{this.type, actionEffect, this.is, aanc.allows, aanc.allowsNot});
            }
            return violates;
        }
        return false;
    }
}

