/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.IntVersion;

public abstract class AbstractSubsystemSchemaTest<S extends SubsystemSchema<S>>
extends AbstractSubsystemBaseTest {
    private final S schema;
    private final boolean latest;

    protected AbstractSubsystemSchemaTest(String subsystemName, Extension extension, S testSchema, S currentSchema) {
        super(subsystemName, extension, testSchema.getStability());
        this.schema = testSchema;
        this.latest = testSchema.since(currentSchema);
    }

    protected S getSubsystemSchema() {
        return this.schema;
    }

    protected String getSubsystemXmlPathPattern() {
        return this.schema.getStability() == Stability.DEFAULT ? "%1$s-%2$d.%3$d.xml" : "%1$s-%4$s-%2$d.%3$d.xml";
    }

    protected String getSubsystemXsdPathPattern() {
        return this.schema.getStability() == Stability.DEFAULT ? "schema/wildfly-%1$s_%2$d_%3$d.xsd" : "schema/wildfly-%1$s_%4$s_%2$d_%3$d.xsd";
    }

    @Override
    protected String getSubsystemXml() throws IOException {
        return this.readResource(String.format(Locale.ROOT, this.getSubsystemXmlPathPattern(), this.getMainSubsystemName(), ((IntVersion)this.schema.getVersion()).major(), ((IntVersion)this.schema.getVersion()).minor(), this.schema.getStability()));
    }

    @Override
    protected String getSubsystemXsdPath() throws Exception {
        return String.format(Locale.ROOT, this.getSubsystemXsdPathPattern(), this.getMainSubsystemName(), ((IntVersion)this.schema.getVersion()).major(), ((IntVersion)this.schema.getVersion()).minor(), this.schema.getStability());
    }

    @Override
    public void testSubsystem() throws Exception {
        this.standardSubsystemTest(null, this.latest);
    }

    @Override
    protected AdditionalInitialization createAdditionalInitialization() {
        return new AdditionalInitialization.ManagementAdditionalInitialization(this.schema);
    }
}

