/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestModelDescriptionValidator;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

public class AdditionalInitialization
extends AdditionalParsers
implements FeatureRegistry {
    public static final AdditionalInitialization MANAGEMENT = new ManagementAdditionalInitialization();
    public static final AdditionalInitialization ADMIN_ONLY_HC = new AdminOnlyHostControllerAdditionalInitialization();
    public static final ModelTestModelDescriptionValidator.AttributeOrParameterArbitraryDescriptorValidator ARBITRARY_DESCRIPTOR_VALIDATOR = (currentType, currentNode, descriptor) -> null;

    public static AdditionalInitialization fromModelTestControllerVersion(ModelTestControllerVersion version) {
        return new ManagementAdditionalInitialization(version);
    }

    public static AdditionalInitialization withCapabilities(final String ... capabilities) {
        return new ManagementAdditionalInitialization(){

            @Override
            protected void initializeExtraSubystemsAndModel(ExtensionRegistry extensionRegistry, Resource rootResource, ManagementResourceRegistration rootRegistration, RuntimeCapabilityRegistry capabilityRegistry) {
                super.initializeExtraSubystemsAndModel(extensionRegistry, rootResource, rootRegistration, capabilityRegistry);
                1.registerCapabilities(capabilityRegistry, capabilities);
            }
        };
    }

    public static AdditionalInitialization withCapabilities(Stability stability, final String ... capabilities) {
        return new ManagementAdditionalInitialization(stability){

            @Override
            protected void initializeExtraSubystemsAndModel(ExtensionRegistry extensionRegistry, Resource rootResource, ManagementResourceRegistration rootRegistration, RuntimeCapabilityRegistry capabilityRegistry) {
                super.initializeExtraSubystemsAndModel(extensionRegistry, rootResource, rootRegistration, capabilityRegistry);
                2.registerCapabilities(capabilityRegistry, capabilities);
            }
        };
    }

    public static <S extends SubsystemSchema<S>> AdditionalInitialization withCapabilities(S schema, final String ... capabilities) {
        return new ManagementAdditionalInitialization(schema){

            @Override
            protected void initializeExtraSubystemsAndModel(ExtensionRegistry extensionRegistry, Resource rootResource, ManagementResourceRegistration rootRegistration, RuntimeCapabilityRegistry capabilityRegistry) {
                super.initializeExtraSubystemsAndModel(extensionRegistry, rootResource, rootRegistration, capabilityRegistry);
                3.registerCapabilities(capabilityRegistry, capabilities);
            }
        };
    }

    public static AdditionalInitialization withCapabilities(final Map<String, Object> capabilities) {
        return new AdditionalInitialization(){

            @Override
            protected void initializeExtraSubystemsAndModel(ExtensionRegistry extensionRegistry, Resource rootResource, ManagementResourceRegistration rootRegistration, RuntimeCapabilityRegistry capabilityRegistry) {
                super.initializeExtraSubystemsAndModel(extensionRegistry, rootResource, rootRegistration, capabilityRegistry);
                4.registerCapabilities(capabilityRegistry, capabilities);
            }
        };
    }

    public static AdditionalInitialization withArbitraryDescriptors(final ModelNode address, final List<String> operations, final Map<String, String> arbitraryDescriptors) {
        return new AdditionalInitialization(){

            @Override
            protected ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration() {
                ModelDescriptionValidator.ValidationConfiguration config = super.getModelValidationConfiguration();
                arbitraryDescriptors.entrySet().stream().map(arbitraryDescriptor -> {
                    config.registerAttributeArbitraryDescriptor(address, (String)arbitraryDescriptor.getKey(), (String)arbitraryDescriptor.getValue(), ARBITRARY_DESCRIPTOR_VALIDATOR);
                    return arbitraryDescriptor;
                }).forEach(arbitraryDescriptor -> {
                    for (String operation : operations) {
                        config.registerArbitraryDescriptorForOperation(address, operation, (String)arbitraryDescriptor.getValue(), ARBITRARY_DESCRIPTOR_VALIDATOR);
                    }
                });
                return config;
            }
        };
    }

    public static void registerCapabilities(RuntimeCapabilityRegistry capabilityRegistry, String ... capabilities) {
        for (String capabilityName : capabilities) {
            RuntimeCapability capability = RuntimeCapability.Builder.of((String)capabilityName).build();
            capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(capability, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        }
    }

    public static void registerCapabilities(RuntimeCapabilityRegistry capabilityRegistry, RuntimeCapability<?> ... capabilities) {
        for (RuntimeCapability<?> capability : capabilities) {
            capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(capability, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        }
    }

    public static void registerCapabilities(RuntimeCapabilityRegistry capabilityRegistry, Map<String, Object> capabilities) {
        for (Map.Entry<String, Object> entry : capabilities.entrySet()) {
            String capabilityName = entry.getKey();
            RuntimeCapability<Object> capability = AdditionalInitialization.createCapability(capabilityName, entry.getValue());
            capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(capability, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        }
    }

    public static void registerServiceCapabilities(RuntimeCapabilityRegistry capabilityRegistry, Map<String, Class> capabilities) {
        for (Map.Entry<String, Class> entry : capabilities.entrySet()) {
            String capabilityName = entry.getKey();
            RuntimeCapability capability = RuntimeCapability.Builder.of((String)capabilityName, (Class)entry.getValue()).build();
            capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(capability, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        }
    }

    public static void registerServiceCapability(RuntimeCapabilityRegistry capabilityRegistry, String name, Class serviceType) {
        RuntimeCapability capability = RuntimeCapability.Builder.of((String)name, (Class)serviceType).build();
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(capability, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
    }

    private static <T> RuntimeCapability<T> createCapability(String capabilityName, T api) {
        return RuntimeCapability.Builder.of((String)capabilityName, api).build();
    }

    protected ProcessType getProcessType() {
        return ProcessType.STANDALONE_SERVER;
    }

    public Stability getStability() {
        return Stability.DEFAULT;
    }

    protected RunningMode getRunningMode() {
        return RunningMode.NORMAL;
    }

    protected RunningMode getExtensionRegistryRunningMode() {
        return RunningMode.NORMAL;
    }

    protected boolean isValidateOperations() {
        return true;
    }

    protected ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration() {
        return new ModelDescriptionValidator.ValidationConfiguration();
    }

    protected ControllerInitializer createControllerInitializer() {
        return new ControllerInitializer();
    }

    protected void setupController(ControllerInitializer controllerInitializer) {
    }

    protected void addExtraServices(ServiceTarget target) {
    }

    protected void initializeExtraSubystemsAndModel(ExtensionRegistry extensionRegistry, Resource rootResource, ManagementResourceRegistration rootRegistration, RuntimeCapabilityRegistry capabilityRegistry) {
    }

    public static class AdminOnlyHostControllerAdditionalInitialization
    extends ManagementAdditionalInitialization
    implements Serializable {
        public AdminOnlyHostControllerAdditionalInitialization() {
        }

        public <S extends SubsystemSchema<S>> AdminOnlyHostControllerAdditionalInitialization(S schema) {
            super(schema);
        }

        public AdminOnlyHostControllerAdditionalInitialization(Stability stability) {
            super(stability);
        }

        @Override
        protected ProcessType getProcessType() {
            return ProcessType.HOST_CONTROLLER;
        }
    }

    public static class ManagementAdditionalInitialization
    extends AdditionalInitialization
    implements Serializable {
        private static final long serialVersionUID = -509444465514822866L;
        private final Stability stability;

        public ManagementAdditionalInitialization() {
            this(Stability.DEFAULT);
        }

        public <S extends SubsystemSchema<S>> ManagementAdditionalInitialization(S schema) {
            this(schema.getStability());
        }

        public ManagementAdditionalInitialization(ModelTestControllerVersion version) {
            this(version.getStability());
        }

        public ManagementAdditionalInitialization(Stability stability) {
            this.stability = stability;
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }

        @Override
        protected RunningMode getRunningMode() {
            return RunningMode.ADMIN_ONLY;
        }
    }

    public static class HostControllerAdditionalInitialization
    extends AdditionalInitialization
    implements Serializable {
        private static final long serialVersionUID = -509444465514822866L;

        @Override
        protected ProcessType getProcessType() {
            return ProcessType.HOST_CONTROLLER;
        }

        @Override
        protected RunningMode getRunningMode() {
            return RunningMode.ADMIN_ONLY;
        }

        @Override
        protected boolean isValidateOperations() {
            return true;
        }
    }
}

