/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.subsystem.test.AbstractKernelServicesImpl;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KnownVersions;
import org.jboss.as.subsystem.test.ReadTransformedResourceOperation;
import org.jboss.as.subsystem.test.TransformerAttachmentGrabber;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

class MainKernelServicesImpl
extends AbstractKernelServicesImpl {
    private final Class<?> testClass;
    private static final ModelVersion CURRENT_CORE_VERSION = ModelVersion.create((int)28, (int)0, (int)0);

    protected MainKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, String mainSubsystemName, ExtensionRegistry extensionRegistry, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, boolean registerTransformers, Class<?> testClass) {
        super(container, controllerService, persister, rootRegistration, operationValidator, mainSubsystemName, extensionRegistry, legacyModelVersion, successfulBoot, bootError, registerTransformers);
        this.testClass = testClass;
        ManagementWorkerService.installService((ServiceTarget)container.subTarget());
    }

    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        return this.transformOperation(modelVersion, operation, null);
    }

    private OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation, TransformerOperationAttachment attachment) throws OperationFailedException {
        this.checkIsMainController();
        PathElement pathElement = PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName);
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (opAddr.size() > 0 && opAddr.getElement(0).equals(pathElement) || operation.get("operation").asString().equals("composite")) {
            Map<PathAddress, ModelVersion> subsystem = Collections.singletonMap(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{pathElement}), modelVersion);
            TransformationTargetImpl transformationTarget = TransformationTargetImpl.create(null, (TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)this.getCoreModelVersionByLegacyModelVersion(modelVersion), subsystem, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER);
            Transformers transformers = Transformers.Factory.create((TransformationTarget)transformationTarget);
            TransformationContext transformationContext = this.createTransformationContext((TransformationTarget)transformationTarget, attachment);
            return transformers.transformOperation(transformationContext, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public ModelNode readTransformedModel(ModelVersion modelVersion, boolean includeDefaults) {
        this.getLegacyServices(modelVersion);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-transformed-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("subsystem").set(this.mainSubsystemName);
        op.get("include-defaults").set(includeDefaults);
        ModelNode response = this.internalExecute(op, new ReadTransformedResourceOperation(this.getTransformersRegistry(), this.getCoreModelVersionByLegacyModelVersion(modelVersion), modelVersion));
        return ModelTestUtils.checkResultAndGetContents((ModelNode)response);
    }

    @Override
    public ModelNode executeOperation(ModelVersion modelVersion, final OperationTransformer.TransformedOperation op) {
        KernelServices legacy = (KernelServices)this.getLegacyServices(modelVersion);
        ModelNode result = new ModelNode();
        if (op.getTransformedOperation() != null && op.rejectOperation(result = legacy.executeOperation(op.getTransformedOperation(), new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                if (op.rejectOperation(result)) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
        }))) {
            ModelNode newResponse = new ModelNode();
            newResponse.get("outcome").set("failed");
            newResponse.get("failure-description").set(op.getFailureDescription());
            return newResponse;
        }
        OperationResultTransformer resultTransformer = op.getResultTransformer();
        if (resultTransformer != null) {
            result = resultTransformer.transformResult(result);
        }
        return result;
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public OperationTransformer.TransformedOperation executeInMainAndGetTheTransformedOperation(ModelNode op, ModelVersion modelVersion) {
        try {
            ModelNode wrapper = Util.createEmptyOperation((String)TransformerAttachmentGrabber.DESC.getName(), (PathAddress)PathAddress.EMPTY_ADDRESS);
            wrapper.get("value").set(op);
            ModelTestUtils.checkOutcome((ModelNode)this.executeOperation(wrapper, new InputStream[0]));
            try {
                OperationTransformer.TransformedOperation transformedOperation = this.transformOperation(modelVersion, op, TransformerAttachmentGrabber.getAttachment());
                return transformedOperation;
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            TransformerAttachmentGrabber.clear();
        }
    }

    private ModelVersion getCoreModelVersionByLegacyModelVersion(ModelVersion legacyModelVersion) {
        if (System.getProperty("jboss.test.core.model.version.override") != null) {
            return ModelVersion.fromString((String)System.getProperty("jboss.test.core.model.version.override"));
        }
        ModelVersion coreModelVersion = KnownVersions.getCoreModelVersionForSubsystemVersion(this.mainSubsystemName, legacyModelVersion);
        if (coreModelVersion != null) {
            return coreModelVersion;
        }
        String fileName = this.mainSubsystemName + "-versions-to-as-versions.properties";
        InputStream in = this.getClass().getResourceAsStream("/" + fileName);
        if (in == null) {
            return CURRENT_CORE_VERSION;
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        String asVersion = (String)props.get(legacyModelVersion.toString());
        if (asVersion == null) {
            return CURRENT_CORE_VERSION;
        }
        coreModelVersion = KnownVersions.AS_CORE_MODEL_VERSION_BY_AS_VERSION.get(asVersion);
        if (coreModelVersion == null) {
            coreModelVersion = CURRENT_CORE_VERSION;
        }
        return coreModelVersion;
    }
}

