/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.wildfly.extension.nosql.cdi.DefaultLiteral;
import org.wildfly.extension.nosql.cdi.NamedLiteral;
import org.wildfly.extension.nosql.subsystem.cassandra.CassandraSubsystemService;
import org.wildfly.nosql.common.ConnectionServiceAccess;
import org.wildfly.nosql.common.SubsystemService;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class CassandraExtension
implements Extension {
    private static final Logger log = Logger.getLogger(CassandraExtension.class.getName());
    private final Class sessionClass;
    private final Class clusterClass;

    public CassandraExtension(Class clusterClass, Class sessionClass) {
        this.clusterClass = clusterClass;
        this.sessionClass = sessionClass;
    }

    void registerNoSQLSourceBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (bm.getBeans((Type)this.clusterClass, new Annotation[]{DefaultLiteral.INSTANCE}).isEmpty()) {
            for (String profile : this.getService().profileNames()) {
                log.log(Level.INFO, "Registering bean for profile {0}", profile);
                abd.addBean(bm.createBean(new ClusterBeanAttributes(bm.createBeanAttributes(bm.createAnnotatedType(this.clusterClass)), profile), this.clusterClass, new ClusterProducerFactory(profile, this.clusterClass)));
                abd.addBean(bm.createBean(new SessionBeanAttributes(bm.createBeanAttributes(bm.createAnnotatedType(this.sessionClass)), profile), this.sessionClass, new SessionProducerFactory(profile, this.sessionClass)));
            }
        } else {
            log.log(Level.INFO, "Application contains a default Cluster Bean, automatic registration will be disabled");
        }
    }

    private SubsystemService getService() {
        return (SubsystemService)CurrentServiceContainer.getServiceContainer().getService(CassandraSubsystemService.serviceName()).getValue();
    }

    private static class SessionProducerFactory<T>
    implements InjectionTargetFactory<T> {
        private final String profile;
        private final Class sessionClass;

        SessionProducerFactory(String profile, Class sessionClass) {
            this.profile = profile;
            this.sessionClass = sessionClass;
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            return new InjectionTarget<T>(){

                public void inject(T instance, CreationalContext<T> ctx) {
                }

                public void postConstruct(T instance) {
                }

                public void preDestroy(T instance) {
                }

                public T produce(CreationalContext<T> ctx) {
                    NoSQLConnection noSQLConnection = ConnectionServiceAccess.connection((String)profile);
                    return noSQLConnection.unwrap(sessionClass);
                }

                public void dispose(T database) {
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.EMPTY_SET;
                }
            };
        }
    }

    private static class SessionBeanAttributes<T>
    implements BeanAttributes<T> {
        private BeanAttributes<T> delegate;
        private final String profile;

        SessionBeanAttributes(BeanAttributes<T> beanAttributes, String profile) {
            this.delegate = beanAttributes;
            this.profile = profile;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>(this.delegate.getQualifiers());
            NamedLiteral namedLiteral = new NamedLiteral(this.profile);
            qualifiers.add((Annotation)((Object)namedLiteral));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }

    private static class ClusterProducerFactory<T>
    implements InjectionTargetFactory<T> {
        private final String profile;
        private final Class clusterClass;

        ClusterProducerFactory(String profile, Class clusterClass) {
            this.profile = profile;
            this.clusterClass = clusterClass;
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            return new InjectionTarget<T>(){

                public void inject(T instance, CreationalContext<T> ctx) {
                }

                public void postConstruct(T instance) {
                }

                public void preDestroy(T instance) {
                }

                public T produce(CreationalContext<T> ctx) {
                    NoSQLConnection noSQLConnection = ConnectionServiceAccess.connection((String)profile);
                    return noSQLConnection.unwrap(clusterClass);
                }

                public void dispose(T connection) {
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.EMPTY_SET;
                }
            };
        }
    }

    private static class ClusterBeanAttributes<T>
    implements BeanAttributes<T> {
        private final BeanAttributes<T> delegate;
        private final String profile;

        ClusterBeanAttributes(BeanAttributes<T> beanAttributes, String profile) {
            this.delegate = beanAttributes;
            this.profile = profile;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>(this.delegate.getQualifiers());
            NamedLiteral namedLiteral = new NamedLiteral(this.profile);
            qualifiers.add((Annotation)((Object)namedLiteral));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }
}

