/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.nosql.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Named;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.nosql.common.MethodHandleBuilder;
import org.wildfly.nosql.common.NoSQLConstants;
import org.wildfly.nosql.common.NoSQLLogger;
import org.wildfly.nosql.common.SubsystemService;

public class DriverScanDependencyProcessor
implements DeploymentUnitProcessor {
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName RESOURCES_ANNOTATION_NAME = DotName.createSimple((String)Resources.class.getName());
    private static final DotName NAMED_ANNOTATION_NAME = DotName.createSimple((String)Named.class.getName());
    private static final AttachmentKey<Map<String, String>> perModuleNameKey = AttachmentKey.create(Map.class);
    private ServiceName serviceName;

    public DriverScanDependencyProcessor(String serviceName) {
        this.serviceName = ServiceName.JBOSS.append(new String[]{serviceName});
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List resourceAnnotations = index.getAnnotations(RESOURCE_ANNOTATION_NAME);
        for (Object annotation : resourceAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            AnnotationValue lookupValue = annotation.value("lookup");
            String lookup = lookupValue != null ? lookupValue.asString() : null;
            if (lookup == null) continue;
            if (annotationTarget instanceof FieldInfo) {
                this.processFieldResource(deploymentUnit, lookup);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                AnnotationInstance[] methodInfo = (AnnotationInstance[])annotationTarget;
                this.processMethodResource(deploymentUnit, (MethodInfo)methodInfo, lookup);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            this.processClassResource(deploymentUnit, lookup);
        }
        List resourcesAnnotations = index.getAnnotations(RESOURCES_ANNOTATION_NAME);
        for (AnnotationInstance outerAnnotation : resourcesAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                String lookup;
                AnnotationValue lookupValue = annotation.value("lookup");
                String string = lookup = lookupValue != null ? lookupValue.asString() : null;
                if (lookup == null) continue;
                this.processClassResource(deploymentUnit, lookup);
            }
        }
        List namedAnnotations = index.getAnnotations(NAMED_ANNOTATION_NAME);
        for (AnnotationInstance annotation : namedAnnotations) {
            String profile;
            AnnotationTarget annotationTarget = annotation.target();
            AnnotationValue profileValue = annotation.value("value");
            String string = profile = profileValue != null ? profileValue.asString() : null;
            if (annotationTarget instanceof FieldInfo) {
                this.processFieldNamedQualifier(deploymentUnit, profile);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                this.processMethodNamedQualifier(deploymentUnit, methodInfo, profile);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            this.processClassNamedQualifier(deploymentUnit, profile);
        }
    }

    private void processClassNamedQualifier(DeploymentUnit deploymentUnit, String profile) {
        if (this.isEmpty(profile)) {
            NoSQLLogger.ROOT_LOGGER.annotationAttributeMissing("@Named", "value");
            return;
        }
        SubsystemService service = this.getService();
        String moduleName = service.moduleNameFromProfile(profile);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedNamedQualifier(profile, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringNamedQualifier(profile, this.getService().profileNames());
        }
    }

    private void processMethodNamedQualifier(DeploymentUnit deploymentUnit, MethodInfo methodInfo, String profile) {
        SubsystemService service = this.getService();
        String moduleName = this.getService().moduleNameFromProfile(profile);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedNamedQualifier(profile, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringNamedQualifier(profile, this.getService().profileNames());
        }
    }

    private void processFieldNamedQualifier(DeploymentUnit deploymentUnit, String profile) {
        SubsystemService service = this.getService();
        String moduleName = this.getService().moduleNameFromProfile(profile);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedNamedQualifier(profile, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringNamedQualifier(profile, this.getService().profileNames());
        }
    }

    protected void processFieldResource(DeploymentUnit deploymentUnit, String lookup) throws DeploymentUnitProcessingException {
        SubsystemService service = this.getService();
        String moduleName = this.getService().moduleNameFromJndi(lookup);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedResourceLookup(lookup, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringResourceLookup(lookup, this.getService().jndiNames());
        }
    }

    protected void processMethodResource(DeploymentUnit deploymentUnit, MethodInfo methodInfo, String lookup) throws DeploymentUnitProcessingException {
        SubsystemService service = this.getService();
        String moduleName = this.getService().moduleNameFromJndi(lookup);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedResourceLookup(lookup, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringResourceLookup(lookup, this.getService().jndiNames());
        }
    }

    protected void processClassResource(DeploymentUnit deploymentUnit, String lookup) throws DeploymentUnitProcessingException {
        if (this.isEmpty(lookup)) {
            NoSQLLogger.ROOT_LOGGER.annotationAttributeMissing("@Resource", "lookup");
            return;
        }
        SubsystemService service = this.getService();
        String moduleName = this.getService().moduleNameFromJndi(lookup);
        if (moduleName != null) {
            this.savePerDeploymentModuleName(deploymentUnit, moduleName, service.vendorKey());
            NoSQLLogger.ROOT_LOGGER.scannedResourceLookup(lookup, moduleName);
        } else {
            NoSQLLogger.ROOT_LOGGER.ignoringResourceLookup(lookup, this.getService().jndiNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePerDeploymentModuleName(DeploymentUnit deploymentUnit, String module, String vendorKey) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            HashMap<String, String> currentValue = (HashMap<String, String>)deploymentUnit.getAttachment(perModuleNameKey);
            if (currentValue == null) {
                currentValue = new HashMap<String, String>();
                deploymentUnit.putAttachment(perModuleNameKey, currentValue);
            }
            if (currentValue.get(vendorKey) != null && !currentValue.get(vendorKey).equals(module)) {
                throw NoSQLLogger.ROOT_LOGGER.cannotAddReferenceToModule(module, currentValue.get(vendorKey), deploymentUnit.getName());
            }
            currentValue.put(vendorKey, module);
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.mongoSetup(deploymentUnit, moduleLoader, module);
        this.cassandraSetup(deploymentUnit, moduleLoader, module);
        this.neo4jSetup(deploymentUnit, moduleLoader, module);
        this.orientSetup(deploymentUnit, moduleLoader, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, String> getPerDeploymentDeploymentModuleName(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            return (Map)deploymentUnit.getAttachment(perModuleNameKey);
        }
    }

    private void mongoSetup(DeploymentUnit deploymentUnit, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        Class mongoDatabaseClass;
        Class mongoClientClass;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        try {
            mongoClientClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass(NoSQLConstants.MONGOCLIENTCLASS);
            mongoDatabaseClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.mongodb.client.MongoDatabase");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        try {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)parent);
                ModuleIdentifier mongoCDIExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.mongodb");
                methodHandleBuilder.classLoader(mongoCDIExtensionModule);
                methodHandleBuilder.className("org.wildfly.extension.nosql.cdi.MongoExtension");
                MethodHandle extensionCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, Class.class, Class.class));
                Extension extension = extensionCtor.invoke(mongoClientClass, mongoDatabaseClass);
                extensions.registerExtensionInstance(extension, parent);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("unexpected error constructing " + methodHandleBuilder.getTargetClass().getName(), throwable);
        }
    }

    private void orientSetup(DeploymentUnit deploymentUnit, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        Class oPartitionedDatabasePoolClass;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        try {
            oPartitionedDatabasePoolClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.orientechnologies.orient.core.db.OPartitionedDatabasePool");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        try {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)parent);
                ModuleIdentifier cdiExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.orientdb");
                methodHandleBuilder.classLoader(cdiExtensionModule);
                methodHandleBuilder.className("org.wildfly.extension.nosql.cdi.OrientExtension");
                MethodHandle extensionCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, Class.class));
                Extension extension = extensionCtor.invoke(oPartitionedDatabasePoolClass);
                extensions.registerExtensionInstance(extension, parent);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("unexpected error constructing " + methodHandleBuilder.getTargetClass().getName(), throwable);
        }
    }

    private void neo4jSetup(DeploymentUnit deploymentUnit, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        Class driverClass;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        try {
            driverClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("org.neo4j.driver.v1.Driver");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        try {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)parent);
                ModuleIdentifier cdiExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.neo4j");
                methodHandleBuilder.classLoader(cdiExtensionModule);
                methodHandleBuilder.className("org.wildfly.extension.nosql.cdi.Neo4jExtension");
                MethodHandle extensionCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, Class.class));
                Extension extension = extensionCtor.invoke(driverClass);
                extensions.registerExtensionInstance(extension, parent);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("unexpected error constructing " + methodHandleBuilder.getTargetClass().getName(), throwable);
        }
    }

    private void cassandraSetup(DeploymentUnit deploymentUnit, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        Class sessionClass;
        Class clusterClass;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        try {
            clusterClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.datastax.driver.core.Cluster");
            sessionClass = moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.datastax.driver.core.Session");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        try {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)parent);
                ModuleIdentifier cdiExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.cassandra");
                methodHandleBuilder.classLoader(cdiExtensionModule);
                methodHandleBuilder.className("org.wildfly.extension.nosql.cdi.CassandraExtension");
                MethodHandle extensionCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, Class.class, Class.class));
                Extension extension = extensionCtor.invoke(clusterClass, sessionClass);
                extensions.registerExtensionInstance(extension, parent);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("unexpected error constructing " + methodHandleBuilder.getTargetClass().getName(), throwable);
        }
    }

    private SubsystemService getService() {
        return (SubsystemService)CurrentServiceContainer.getServiceContainer().getService(this.serviceName).getValue();
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

