/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.mongodb;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.mongodb.ConfigurationBuilder;
import org.wildfly.extension.nosql.driver.mongodb.MongoInteraction;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoSubsystemService;
import org.wildfly.nosql.common.NoSQLLogger;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class MongoClientConnectionsService
implements Service<MongoClientConnectionsService>,
NoSQLConnection {
    final ConfigurationBuilder configurationBuilder;
    private Map<String, OutboundSocketBinding> outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    private Object client;
    private Object database;
    private MongoInteraction mongoInteraction;
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    private final InjectedValue<MongoSubsystemService> mongoSubsystemServiceInjectedValue = new InjectedValue();

    public InjectedValue<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public InjectedValue<MongoSubsystemService> getMongoSubsystemServiceInjectedValue() {
        return this.mongoSubsystemServiceInjectedValue;
    }

    public MongoClientConnectionsService(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
        this.mongoInteraction = new MongoInteraction(configurationBuilder);
    }

    public Injector<OutboundSocketBinding> getOutboundSocketBindingInjector(String name) {
        return new MapInjector(this.outboundSocketBindings, (Object)name);
    }

    public void start(StartContext startContext) throws StartException {
        ((MongoSubsystemService)this.mongoSubsystemServiceInjectedValue.getValue()).addModuleNameFromJndi(this.configurationBuilder.getJNDIName(), this.configurationBuilder.getModuleName());
        ((MongoSubsystemService)this.mongoSubsystemServiceInjectedValue.getValue()).addModuleNameFromProfile(this.configurationBuilder.getDescription(), this.configurationBuilder.getModuleName());
        for (OutboundSocketBinding target : this.outboundSocketBindings.values()) {
            try {
                this.mongoInteraction.hostPort(target.getUnresolvedDestinationAddress(), target.getDestinationPort());
            }
            catch (Throwable throwable) {
                throw new RuntimeException("could not setup ServerAddress for " + target.getUnresolvedDestinationAddress() + " " + target.getDestinationPort(), throwable);
            }
        }
        if (this.subjectFactory.getOptionalValue() != null) {
            this.mongoInteraction.subjectFactory((SubjectFactory)this.subjectFactory.getOptionalValue());
        }
        try {
            this.client = this.mongoInteraction.mongoClient();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("could not setup connection to " + this.configurationBuilder.getDescription(), throwable);
        }
        if (this.configurationBuilder.getDatabase() != null) {
            try {
                this.database = this.mongoInteraction.getDB();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("could not use database " + this.configurationBuilder.getDatabase(), throwable);
            }
        }
    }

    public void stop(StopContext stopContext) {
        try {
            ((MongoSubsystemService)this.mongoSubsystemServiceInjectedValue.getValue()).removeModuleNameFromJndi(this.configurationBuilder.getJNDIName());
            ((MongoSubsystemService)this.mongoSubsystemServiceInjectedValue.getValue()).removeModuleNameFromProfile(this.configurationBuilder.getDescription());
            this.mongoInteraction.close();
        }
        catch (Throwable throwable) {
            NoSQLLogger.ROOT_LOGGER.driverFailedToStop(throwable);
        }
        this.client = null;
    }

    public MongoClientConnectionsService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Object getClient() {
        return this.client;
    }

    public Object getDatabase() {
        return this.database;
    }

    private Class getMongoClientClass() {
        return this.mongoInteraction.getMongoClientClass();
    }

    private Class getMongoDatabaseClass() {
        return this.mongoInteraction.getMongoDatabaseClass();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.getMongoClientClass().isAssignableFrom(clazz)) {
            return (T)this.client;
        }
        if (this.database != null && this.getMongoDatabaseClass().isAssignableFrom(clazz)) {
            return (T)this.database;
        }
        throw NoSQLLogger.ROOT_LOGGER.unassignable(clazz);
    }
}

