/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.mongodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.mongodb.AuthType;
import org.wildfly.extension.nosql.driver.mongodb.ConfigurationBuilder;
import org.wildfly.extension.nosql.driver.mongodb.MongoClientConnectionsService;
import org.wildfly.extension.nosql.driver.mongodb.ReadConcernType;
import org.wildfly.extension.nosql.driver.mongodb.WriteConcernType;
import org.wildfly.extension.nosql.subsystem.mongodb.HostDefinition;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoDriverExtension;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoSubsystemService;
import org.wildfly.extension.nosql.subsystem.mongodb.PropertiesDescription;
import org.wildfly.nosql.common.ConnectionServiceAccess;

public class MongoDefinition
extends PersistentResourceDefinition {
    private static final List<? extends PersistentResourceDefinition> CHILDREN;
    protected static final SimpleAttributeDefinition ID_NAME;
    protected static final SimpleAttributeDefinition JNDI_NAME;
    protected static final SimpleAttributeDefinition DATABASE;
    protected static final SimpleAttributeDefinition ADMIN_DATABASE;
    protected static final SimpleAttributeDefinition MODULE;
    protected static final SimpleAttributeDefinition SECURITY_DOMAIN;
    protected static final SimpleAttributeDefinition AUTH_TYPE;
    protected static final SimpleAttributeDefinition SSL;
    protected static final SimpleAttributeDefinition REPLICA_SET;
    protected static List<SimpleAttributeDefinition> ATTRIBUTES;
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP;
    static final MongoDefinition INSTANCE;

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    private MongoDefinition() {
        super(MongoDriverExtension.PROFILE_PATH, (ResourceDescriptionResolver)MongoDriverExtension.getResolver("mongo"), (OperationStepHandler)ProfileAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    static {
        ArrayList<PersistentResourceDefinition> children = new ArrayList<PersistentResourceDefinition>();
        children.add(HostDefinition.INSTANCE);
        children.add(PropertiesDescription.INSTANCE);
        CHILDREN = Collections.unmodifiableList(children);
        ID_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("id", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        DATABASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("database", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        ADMIN_DATABASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("adminDatabase", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
        SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
        AUTH_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auth-type", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(AuthType.class, true, true))).setDefaultValue(new ModelNode(AuthType.DEFAULT.toString()))).setAllowExpression(false)).build();
        SSL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        REPLICA_SET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replicaSet", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
        ATTRIBUTES = Arrays.asList(ID_NAME, JNDI_NAME, DATABASE, ADMIN_DATABASE, MODULE, SECURITY_DOMAIN, AUTH_TYPE, SSL, REPLICA_SET);
        ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
        INSTANCE = new MongoDefinition();
    }

    private static class ProfileAdd
    extends AbstractAddStepHandler {
        private static final ProfileAdd INSTANCE = new ProfileAdd();

        private ProfileAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode profileEntry = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            HashSet<String> outboundSocketBindings = new HashSet<String>();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (profileEntry.hasDefined("id")) {
                builder.setDescription(profileEntry.get("id").asString());
            }
            if (profileEntry.hasDefined("jndi-name")) {
                builder.setJNDIName(profileEntry.get("jndi-name").asString());
            }
            if (profileEntry.hasDefined("module")) {
                builder.setModuleName(profileEntry.get("module").asString());
            }
            if (profileEntry.hasDefined("database")) {
                builder.setDatabase(profileEntry.get("database").asString());
            }
            if (profileEntry.hasDefined("adminDatabase")) {
                builder.setAdminDatabase(profileEntry.get("adminDatabase").asString());
            }
            if (profileEntry.hasDefined("security-domain")) {
                builder.setSecurityDomain(profileEntry.get("security-domain").asString());
            }
            if (profileEntry.hasDefined("auth-type")) {
                AuthType authType = AuthType.valueOf(profileEntry.get("auth-type").asString());
                builder.setAuthType(authType);
            }
            if (profileEntry.hasDefined("ssl")) {
                builder.setSSL(profileEntry.get("ssl").asBoolean());
            }
            if (profileEntry.hasDefined("replicaSet")) {
                builder.setReplicaSet(profileEntry.get("replicaSet").asString());
            }
            if (profileEntry.hasDefined("host")) {
                ModelNode hostModels = profileEntry.get("host");
                for (ModelNode host : hostModels.asList()) {
                    for (ModelNode hostEntry : host.get(0).asList()) {
                        if (!hostEntry.hasDefined("outbound-socket-binding-ref")) continue;
                        String outboundSocketBindingRef = hostEntry.get("outbound-socket-binding-ref").asString();
                        outboundSocketBindings.add(outboundSocketBindingRef);
                    }
                }
            }
            if (profileEntry.hasDefined("properties")) {
                for (ModelNode propertyProfiles : profileEntry.get("properties").asList()) {
                    for (ModelNode propertyModels : propertyProfiles.get(0).asList()) {
                        if (!propertyModels.hasDefined("property")) continue;
                        for (Property property : propertyModels.get("property").asPropertyList()) {
                            if (property.getName().equals("writeConcern")) {
                                builder.setWriteConcern(WriteConcernType.valueOf(property.getValue().asString()).name());
                                continue;
                            }
                            if (!property.getName().equals("readConcern")) continue;
                            builder.setReadConcern(ReadConcernType.valueOf(property.getValue().asString()).name());
                        }
                    }
                }
            }
            this.startMongoDriverService(context, builder, outboundSocketBindings);
        }

        private void startMongoDriverService(OperationContext context, ConfigurationBuilder builder, Set<String> outboundSocketBindings) {
            if (builder.getJNDIName() != null && builder.getJNDIName().length() > 0) {
                MongoClientConnectionsService mongoClientConnectionsService = new MongoClientConnectionsService(builder);
                ServiceName serviceName = ConnectionServiceAccess.serviceName((String)builder.getDescription());
                ContextNames.BindInfo bindingInfo = ContextNames.bindInfoFor((String)builder.getJNDIName());
                final BinderService binderService = new BinderService(bindingInfo.getBindName());
                context.getServiceTarget().addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(MongoSubsystemService.serviceName()).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(serviceName, MongoClientConnectionsService.class, (Injector)new Injector<MongoClientConnectionsService>(){

                    public void inject(MongoClientConnectionsService value) throws InjectionException {
                        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue(value.getDatabase() != null ? value.getDatabase() : value.getClient())));
                    }

                    public void uninject() {
                        binderService.getNamingStoreInjector().uninject();
                    }
                }).install();
                ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)mongoClientConnectionsService);
                serviceBuilder.addDependency(MongoSubsystemService.serviceName(), (Injector)new CastingInjector(mongoClientConnectionsService.getMongoSubsystemServiceInjectedValue(), MongoSubsystemService.class));
                for (String outboundSocketBinding : outboundSocketBindings) {
                    ServiceName outboundSocketBindingDependency = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketBinding, OutboundSocketBinding.class);
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, outboundSocketBindingDependency, OutboundSocketBinding.class, mongoClientConnectionsService.getOutboundSocketBindingInjector(outboundSocketBinding));
                }
                if (builder.getSecurityDomain() != null) {
                    serviceBuilder.addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, mongoClientConnectionsService.getSubjectFactoryInjector());
                }
                serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
    }
}

