/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.neo4j;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.nosql.subsystem.neo4j.Neo4jDriverDefinition;
import org.wildfly.extension.nosql.subsystem.neo4j.Neo4jSubsystemService;
import org.wildfly.nosql.common.DriverDependencyProcessor;
import org.wildfly.nosql.common.DriverScanDependencyProcessor;

public class Neo4jDriverSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final Neo4jDriverSubsystemAdd INSTANCE = new Neo4jDriverSubsystemAdd();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private Neo4jDriverSubsystemAdd() {
        super(Neo4jDriverDefinition.DRIVER_SERVICE_CAPABILITY, new AttributeDefinition[0]);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : Neo4jDriverDefinition.INSTANCE.getAttributes()) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.runtimeValidator.validate(operation.resolve());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                int PARSE_NEO4J_DRIVER = 19456;
                int DEPENDENCIES_NEO4J_DRIVER = 7952;
                processorTarget.addDeploymentProcessor("neo4jdriver", Phase.PARSE, 19456, (DeploymentUnitProcessor)new DriverScanDependencyProcessor("neo4jsubsystem"));
                processorTarget.addDeploymentProcessor("neo4jdriver", Phase.DEPENDENCIES, 7952, (DeploymentUnitProcessor)DriverDependencyProcessor.getInstance());
            }
        }, OperationContext.Stage.RUNTIME);
        this.startNeo4jDriverSubsysteService(context);
    }

    private void startNeo4jDriverSubsysteService(OperationContext context) {
        Neo4jSubsystemService neo4jSubsystemService = new Neo4jSubsystemService();
        context.getServiceTarget().addService(Neo4jSubsystemService.serviceName(), (Service)neo4jSubsystemService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, neo4jSubsystemService.getTransactionManagerInjector()).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, neo4jSubsystemService.getTxSyncRegistryInjector()).install();
    }
}

