/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.neo4j.ConfigurationBuilder;
import org.wildfly.extension.nosql.driver.neo4j.Neo4jClientConnectionService;
import org.wildfly.extension.nosql.driver.neo4j.transaction.TransactionEnlistmentType;
import org.wildfly.extension.nosql.subsystem.neo4j.HostDefinition;
import org.wildfly.extension.nosql.subsystem.neo4j.Neo4jDriverExtension;
import org.wildfly.extension.nosql.subsystem.neo4j.Neo4jSubsystemService;
import org.wildfly.nosql.common.ConnectionServiceAccess;
import org.wildfly.nosql.common.NoSQLLogger;

public class Neo4jDefinition
extends PersistentResourceDefinition {
    private static final List<? extends PersistentResourceDefinition> CHILDREN;
    protected static final SimpleAttributeDefinition ID_NAME;
    protected static final SimpleAttributeDefinition JNDI_NAME;
    protected static final SimpleAttributeDefinition MODULE;
    protected static final SimpleAttributeDefinition TRANSACTION;
    protected static final SimpleAttributeDefinition SECURITY_DOMAIN;
    protected static List<SimpleAttributeDefinition> ATTRIBUTES;
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP;
    static final Neo4jDefinition INSTANCE;

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    private Neo4jDefinition() {
        super(Neo4jDriverExtension.PROFILE_PATH, (ResourceDescriptionResolver)Neo4jDriverExtension.getResolver("neo4j"), (OperationStepHandler)ProfileAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    static {
        ArrayList<HostDefinition> children = new ArrayList<HostDefinition>();
        children.add(HostDefinition.INSTANCE);
        CHILDREN = Collections.unmodifiableList(children);
        ID_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("id", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
        TRANSACTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("transaction", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).setValidator(new ParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                String str;
                if (value.isDefined() && TransactionEnlistmentType.getFromStringValue(str = value.asString()) == null) {
                    throw NoSQLLogger.ROOT_LOGGER.invalidParameter("transaction", str, TransactionEnlistmentType.allowedNames());
                }
            }

            public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
                this.validateParameter(parameterName, value.resolve());
            }
        })).build();
        SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
        ATTRIBUTES = Arrays.asList(ID_NAME, JNDI_NAME, MODULE, TRANSACTION, SECURITY_DOMAIN);
        ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
        INSTANCE = new Neo4jDefinition();
    }

    private static class ProfileAdd
    extends AbstractAddStepHandler {
        private static final ProfileAdd INSTANCE = new ProfileAdd();

        private ProfileAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode profileEntry = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            HashSet<String> outboundSocketBindings = new HashSet<String>();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (profileEntry.hasDefined("id")) {
                builder.setDescription(profileEntry.get("id").asString());
            }
            if (profileEntry.hasDefined("jndi-name")) {
                builder.setJNDIName(profileEntry.get("jndi-name").asString());
            }
            if (profileEntry.hasDefined("module")) {
                builder.setModuleName(profileEntry.get("module").asString());
            }
            if (profileEntry.hasDefined("transaction")) {
                builder.setTransactionEnlistment(TransactionEnlistmentType.getFromStringValue(profileEntry.get("transaction").asString()));
            }
            if (profileEntry.hasDefined("host")) {
                ModelNode hostModels = profileEntry.get("host");
                for (ModelNode host : hostModels.asList()) {
                    for (ModelNode hostEntry : host.get(0).asList()) {
                        if (!hostEntry.hasDefined("outbound-socket-binding-ref")) continue;
                        String outboundSocketBindingRef = hostEntry.get("outbound-socket-binding-ref").asString();
                        outboundSocketBindings.add(outboundSocketBindingRef);
                    }
                }
            }
            if (profileEntry.hasDefined("security-domain")) {
                builder.setSecurityDomain(profileEntry.get("security-domain").asString());
            }
            this.startNeo4jDriverService(context, builder, outboundSocketBindings);
        }

        private void startNeo4jDriverService(OperationContext context, ConfigurationBuilder builder, Set<String> outboundSocketBindings) throws OperationFailedException {
            if (builder.getJNDIName() != null && builder.getJNDIName().length() > 0) {
                Neo4jClientConnectionService neo4jClientConnectionService = new Neo4jClientConnectionService(builder);
                ServiceName serviceName = ConnectionServiceAccess.serviceName((String)builder.getDescription());
                ContextNames.BindInfo bindingInfo = ContextNames.bindInfoFor((String)builder.getJNDIName());
                final BinderService binderService = new BinderService(bindingInfo.getBindName());
                context.getServiceTarget().addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(Neo4jSubsystemService.serviceName()).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(serviceName, Neo4jClientConnectionService.class, (Injector)new Injector<Neo4jClientConnectionService>(){

                    public void inject(Neo4jClientConnectionService value) throws InjectionException {
                        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue(value.getDriver())));
                    }

                    public void uninject() {
                        binderService.getNamingStoreInjector().uninject();
                    }
                }).install();
                ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)neo4jClientConnectionService);
                serviceBuilder.addDependency(Neo4jSubsystemService.serviceName(), (Injector)new CastingInjector(neo4jClientConnectionService.getNeo4jSubsystemServiceInjectedValue(), Neo4jSubsystemService.class));
                for (String outboundSocketBinding : outboundSocketBindings) {
                    ServiceName outboundSocketBindingDependency = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketBinding, OutboundSocketBinding.class);
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, outboundSocketBindingDependency, OutboundSocketBinding.class, neo4jClientConnectionService.getOutboundSocketBindingInjector(outboundSocketBinding));
                }
                if (builder.getSecurityDomain() != null) {
                    serviceBuilder.addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, neo4jClientConnectionService.getSubjectFactoryInjector());
                }
                serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
    }
}

